/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.wia;

import eu.gnome.morena.wia.SupportedPropertyValues;
import eu.gnome.morena.wia.WIAConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WIAItem
implements WIAConstants {
    private String name;
    private int category;
    private Map<Integer, SupportedPropertyValues> propValues;
    private List<Integer> propList;

    public WIAItem(String string, int n) {
        this.name = string;
        this.category = n;
        this.propValues = new HashMap<Integer, SupportedPropertyValues>();
        this.propList = new ArrayList<Integer>();
    }

    public void addProperty(int n, String string, boolean bl, int n2, int n3, int[] nArray) {
        SupportedPropertyValues supportedPropertyValues = new SupportedPropertyValues(n, string, bl, n2, n3, nArray);
        this.propList.add(n);
        this.propValues.put(n, supportedPropertyValues);
    }

    public boolean isFeeder() {
        return this.category == 3 || this.category == 8 || this.category == 7;
    }

    public boolean isFlatbed() {
        return this.category == 2;
    }

    public List<Integer> getSupportedModes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<Integer> list = this.propValues.get(4103).getList();
        if (list.size() > 0) {
            if (list.contains(0)) {
                arrayList.add(-1);
            }
            if (list.contains(2)) {
                arrayList.add(-8);
            }
            if (list.contains(3)) {
                arrayList.add(8);
            }
        } else {
            list = this.propValues.get(4104).getList();
            if (list.contains(1)) {
                arrayList.add(-1);
            }
            if (list.contains(8)) {
                arrayList.add(-8);
            }
            if (list.contains(24)) {
                arrayList.add(8);
            }
        }
        return arrayList;
    }

    public List<Integer> getSupportedValues(int n) {
        SupportedPropertyValues supportedPropertyValues = this.propValues.get(n);
        if (supportedPropertyValues != null) {
            return supportedPropertyValues.getList();
        }
        return new ArrayList<Integer>();
    }

    public SupportedPropertyValues getProperty(int n) {
        return this.propValues.get(n);
    }

    public List<Integer> getPropertyIds() {
        return this.propList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Item ").append(this.name).append("    of category ").append(this.getCategoryDescription(this.category));
        return stringBuilder.toString();
    }

    private String getCategoryDescription(int n) {
        switch (n) {
            case 1: {
                return "Finished file";
            }
            case 2: {
                return "Flatbed";
            }
            case 3: {
                return "Feeder";
            }
            case 4: {
                return "Film";
            }
            case 5: {
                return "Root";
            }
            case 6: {
                return "Folder";
            }
            case 7: {
                return "Feeder front";
            }
            case 8: {
                return "Feeder back";
            }
            case 9: {
                return "Auto";
            }
        }
        return "Other";
    }
}

