/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.ui;

import eu.gnome.morena.Device;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferListener;
import eu.gnome.morena.ui.ScannerOptionPane;
import eu.gnome.morena.ui.SwingFormPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PreviewPane
extends SwingFormPane {
    private static final long serialVersionUID = 9220550274788645491L;
    private static Dimension MIN_CANVAS_SIZE = new Dimension(300, 400);
    private static int RECT_SIZE = 8;
    private static Color rectColor = Color.PINK;
    private Scanner scanner;
    private ScannerOptionPane optionPane;
    private PreviewCanvas previewCanvas;
    private JButton previewButton;
    private ScannerOptionPane.PAPER_SOURCE sheet;
    private Rectangle frame;
    private Point[] frameCorners;
    private Rectangle[] frameCornerBars;
    private int dragCorner;
    private Point dragPoint;
    private boolean dragging;
    private BufferedImage previewImage;
    private MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getModifiersEx();
            System.out.printf("drag %s (%d, %d)\n", MouseEvent.getModifiersExText(n3), n, n2);
            if (PreviewPane.this.dragging) {
                PreviewPane.this.translateCorner(n - ((PreviewPane)PreviewPane.this).dragPoint.x, n2 - ((PreviewPane)PreviewPane.this).dragPoint.y);
                PreviewPane.this.dragPoint.move(n, n2);
                PreviewPane.this.previewCanvas.repaint();
            }
            super.mouseDragged(mouseEvent);
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getModifiersEx();
            System.out.printf("pressed %s %d, %d\n", MouseEvent.getModifiersExText(n3), n, n2);
            for (int i = 0; i < 4; ++i) {
                if (!PreviewPane.this.frameCornerBars[i].contains(n, n2)) continue;
                PreviewPane.this.dragging = true;
                PreviewPane.this.dragPoint = new Point(n, n2);
                PreviewPane.this.dragCorner = i;
                System.out.printf("dragging corner %d\n", PreviewPane.this.dragCorner);
                break;
            }
            super.mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getModifiersEx();
            System.out.printf("released %s %d, %d\n", MouseEvent.getModifiersExText(n3), n, n2);
            if (PreviewPane.this.dragging) {
                PreviewPane.this.dragging = false;
            }
            super.mouseReleased(mouseEvent);
        }
    };
    TransferListener transferListener = new TransferListener(){

        public void transferFailed(int n, String string) {
        }

        public void transferDone(File file) {
            try {
                PreviewPane.this.previewImage = ImageIO.read(file);
                PreviewPane.this.previewCanvas.repaint();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void transferProgress(int n) {
            System.out.printf("preview progress %d%%\n", n);
        }
    };
    private Action previewAction = new AbstractAction("Preview"){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PreviewPane.this.optionPane.save();
                ((PreviewPane)PreviewPane.this).optionPane.saved = false;
                PreviewPane.this.previewImage = ImageIO.read(new File("C:\\Users\\peter\\AppData\\Local\\Temp\\morena_images\\MorenaImg.BMP"));
                PreviewPane.this.previewCanvas.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    public PreviewPane(Window window, ScannerOptionPane scannerOptionPane) {
        super(window);
        this.optionPane = scannerOptionPane;
        this.previewCanvas = new PreviewCanvas();
        this.previewCanvas.setBackground(Color.WHITE);
        this.previewCanvas.addMouseListener(this.mouseListener);
        this.previewCanvas.addMouseMotionListener(this.mouseMotionListener);
        this.frame = new Rectangle(0, 0, PreviewPane.MIN_CANVAS_SIZE.width - 1, PreviewPane.MIN_CANVAS_SIZE.height - 1);
        this.frameCornerBars = new Rectangle[4];
        this.updateCorners(this.frame);
    }

    public void load(Device device) {
        super.load(device);
        this.scanner = (Scanner)device;
        this.previewButton = new JButton(this.previewAction);
        int n = 0;
        this.add(null, this.previewCanvas, 0, n++, 2, 1, 0, 10, 0, 0, true);
        this.add(null, this.previewButton, 0, n++, 2, 1, 0, 10, 1, 1, true);
    }

    public void save() {
        super.save();
    }

    protected Rectangle getFrameBorder() {
        return this.frame;
    }

    private void updateCorners(Rectangle rectangle) {
        this.frameCornerBars[0] = new Rectangle(rectangle.x, rectangle.y, RECT_SIZE, RECT_SIZE);
        this.frameCornerBars[1] = new Rectangle(rectangle.x + rectangle.width - RECT_SIZE, rectangle.y, RECT_SIZE, RECT_SIZE);
        this.frameCornerBars[2] = new Rectangle(rectangle.x + rectangle.width - RECT_SIZE, rectangle.y + rectangle.height - RECT_SIZE, RECT_SIZE, RECT_SIZE);
        this.frameCornerBars[3] = new Rectangle(rectangle.x, rectangle.y + rectangle.height - RECT_SIZE, RECT_SIZE, RECT_SIZE);
    }

    private void translateCorner(int n, int n2) {
        switch (this.dragCorner) {
            case 0: {
                this.frame.x += n;
                this.frame.y += n2;
                this.frame.width -= n;
                this.frame.height -= n2;
                break;
            }
            case 1: {
                this.frame.width += n;
                this.frame.y += n2;
                this.frame.height -= n2;
                break;
            }
            case 2: {
                this.frame.width += n;
                this.frame.height += n2;
                break;
            }
            case 3: {
                this.frame.x += n;
                this.frame.width -= n;
                this.frame.height += n2;
            }
        }
        System.out.println("frame1 = " + this.frame);
        this.frame.x = Math.max(this.frame.x, 0);
        this.frame.y = Math.max(this.frame.y, 0);
        this.frame.width = Math.min(this.frame.width, PreviewPane.MIN_CANVAS_SIZE.width - 1);
        this.frame.height = Math.min(this.frame.height, PreviewPane.MIN_CANVAS_SIZE.height - 1);
        System.out.println("frame2 = " + this.frame);
        this.updateCorners(this.frame);
        System.out.println("Corner bars " + Arrays.toString(this.frameCornerBars));
    }

    private class PreviewCanvas
    extends JPanel {
        private PreviewCanvas() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (PreviewPane.this.previewImage != null) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                System.out.printf("%d, %d\n", n, n2);
                double d = (double)PreviewPane.this.previewImage.getHeight() / (double)PreviewPane.this.previewImage.getWidth();
                double d2 = (double)PreviewPane.this.previewImage.getWidth() / (double)PreviewPane.this.previewImage.getHeight();
                int n3 = (int)Math.round(d * (double)n);
                if (n3 <= n2) {
                    graphics.drawImage(PreviewPane.this.previewImage, 0, 0, n, n3, this);
                } else {
                    graphics.drawImage(PreviewPane.this.previewImage, 0, 0, (int)Math.round(d2 * (double)n2), n2, this);
                }
                this.paintFrame(graphics, PreviewPane.this.frame);
            }
        }

        private void paintFrame(Graphics graphics, Rectangle rectangle) {
            graphics.setColor(rectColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            for (int i = 0; i < 4; ++i) {
                graphics.fillRect(((PreviewPane)PreviewPane.this).frameCornerBars[i].x, ((PreviewPane)PreviewPane.this).frameCornerBars[i].y, ((PreviewPane)PreviewPane.this).frameCornerBars[i].width, ((PreviewPane)PreviewPane.this).frameCornerBars[i].height);
            }
        }

        public Dimension getPreferredSize() {
            return MIN_CANVAS_SIZE;
        }

        public Dimension getMinimumSize() {
            return MIN_CANVAS_SIZE;
        }
    }
}

