/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.wrapper;

import cat.aoc.scanner.bridge.util.Converter;
import cat.aoc.scanner.bridge.util.PopupMenuBuilder;
import cat.aoc.scanner.bridge.wrapper.DeviceInfo;
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceListChangeListener;
import eu.gnome.morena.Manager;
import eu.gnome.morena.wia.WIADevice;
import eu.gnome.morena.wia.WIAScanner;
import java.awt.Image;
import java.awt.TrayIcon;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ManagerWrapper {
    private static Manager manager = null;
    private static TrayIcon trayIcon = null;
    private static DeviceInfo currentlySelectedDevice = null;
    private static Map<String, DeviceInfo> devicesByUID = new ConcurrentHashMap<String, DeviceInfo>();
    private static Map<String, DeviceInfo> devicesByName = new ConcurrentHashMap<String, DeviceInfo>();

    public static synchronized Manager get() {
        if (manager == null) {
            System.out.println("Establint sessi\u00f3 amb els dispositius d'escaneig");
            manager = Manager.getInstance();
            DeviceListChangeListener deviceListChangeListener = new DeviceListChangeListener(){

                public void deviceConnected(Device device) {
                    if (device != null && device instanceof WIADevice) {
                        System.out.println("Un nou dispositiu ha estat connectat: '" + device + "'");
                        DeviceInfo deviceInfo = Converter.toDeviceInfo((WIAScanner)device);
                        devicesByUID.put(deviceInfo.getUID(), deviceInfo);
                        devicesByName.put(deviceInfo.getName(), deviceInfo);
                        if (currentlySelectedDevice != null && currentlySelectedDevice.getName().equals(deviceInfo.getName())) {
                            currentlySelectedDevice = deviceInfo;
                        }
                        ManagerWrapper.updateTrayMenu();
                    }
                }

                public void deviceDisconnected(Device device) {
                    if (device != null && device instanceof WIADevice) {
                        System.out.println("El dispositiu '" + device + "' ha estat desconnectat");
                        DeviceInfo deviceInfo = Converter.toDeviceInfo((WIAScanner)device);
                        devicesByUID.remove(deviceInfo.getUID());
                        devicesByName.remove(deviceInfo.getName());
                        if (currentlySelectedDevice != null && currentlySelectedDevice.getName().equals(deviceInfo.getName())) {
                            if (devicesByUID.size() > 0) {
                                currentlySelectedDevice = (DeviceInfo)devicesByUID.values().iterator().next();
                            } else {
                                currentlySelectedDevice = null;
                            }
                        }
                        ManagerWrapper.updateTrayMenu();
                    }
                }

                public void listChanged() {
                    System.out.println("La llista de dispositius ha canviat!");
                }
            };
            manager.addDeviceListChangeListener(deviceListChangeListener);
            System.out.println("Listener de dispositius registrat");
            System.out.println("Dispositius registrats al sistema: ");
            List devices = manager.listDevices();
            for (Device device : devices) {
                if (device == null || !(device instanceof WIADevice)) continue;
                DeviceInfo deviceInfo = Converter.toDeviceInfo((WIAScanner)device);
                devicesByUID.put(deviceInfo.getUID(), deviceInfo);
                devicesByName.put(deviceInfo.getName(), deviceInfo);
                if (currentlySelectedDevice != null && deviceInfo.getName().equals(currentlySelectedDevice.getName())) {
                    currentlySelectedDevice = deviceInfo;
                }
                System.out.println("  - " + deviceInfo.getName());
            }
            if (currentlySelectedDevice == null && devicesByUID.size() > 0) {
                currentlySelectedDevice = devicesByUID.values().iterator().next();
            }
            ManagerWrapper.updateTrayMenu();
        }
        return manager;
    }

    private static void updateTrayMenu() {
        if (trayIcon != null) {
            trayIcon.setPopupMenu(PopupMenuBuilder.build());
            System.out.println("Menu actualitzat");
        }
    }

    public static synchronized List<DeviceInfo> getDeviceList() {
        return new LinkedList<DeviceInfo>(devicesByUID.values());
    }

    public static synchronized DeviceInfo getCurrentlyInUse() {
        return currentlySelectedDevice;
    }

    public static synchronized void setCurrentlyInUse(DeviceInfo deviceInfo) {
        currentlySelectedDevice = deviceInfo;
    }

    public static synchronized void free() {
        if (manager != null) {
            System.out.println("Tancant la sessi\u00f3 amb els dispositius d'escaneig");
            try {
                manager.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            manager = null;
            System.out.println("Sessi\u00f3 tancada");
        }
    }

    public static TrayIcon getTrayIcon(Image image) {
        if (trayIcon == null) {
            trayIcon = new TrayIcon(image, "M\u00f2dul de connexi\u00f3 amb el scanner - Consorci AOC");
        }
        return trayIcon;
    }

    public static void setTrayIcon(TrayIcon tIcon) {
        trayIcon = tIcon;
    }
}

