/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.thread;

import cat.aoc.scanner.bridge.items.BinarySendCommand;
import cat.aoc.scanner.bridge.items.ClientAcknowledgeCommand;
import cat.aoc.scanner.bridge.items.Command;
import cat.aoc.scanner.bridge.items.HeartBeatCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;

public class CommandSenderAgent
extends Thread {
    private ScheduledExecutorService executor;
    private volatile Map<String, Session> sessions = new LinkedHashMap<String, Session>();
    private volatile BlockingQueue<Command> commandQueue = new LinkedBlockingQueue<Command>(2000);

    public CommandSenderAgent() {
        this.executor = new ScheduledThreadPoolExecutor(3);
        this.setName("Command sender agent");
        this.setDaemon(true);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Session session;
                LinkedList<String> expired = new LinkedList<String>();
                for (String clientId : CommandSenderAgent.this.sessions.keySet()) {
                    session = (Session)CommandSenderAgent.this.sessions.get(clientId);
                    if (session == null) continue;
                    if (session.isOpen()) {
                        CommandSenderAgent.this.commandQueue.offer(new HeartBeatCommand(clientId));
                        continue;
                    }
                    expired.add(clientId);
                }
                for (String ec : expired) {
                    System.out.println("ScannerBridge : Eliminant connexi\ufffd morta pel client [" + ec + "]");
                    session = (Session)CommandSenderAgent.this.sessions.remove(ec);
                    try {
                        session.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.executor.scheduleAtFixedRate(task, 0L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Command command = this.commandQueue.take();
                    String clientId = command.getClientId();
                    Session session = this.sessions.get(clientId);
                    try {
                        if (session != null) {
                            if (session.isOpen()) {
                                if (command instanceof BinarySendCommand) {
                                    session.getRemote().sendBytes(((BinarySendCommand)command).getPayload());
                                    continue;
                                }
                                session.getRemote().sendString(command.toString());
                                continue;
                            }
                            this.sessions.remove(clientId);
                            continue;
                        }
                        System.out.println("ScannerBridge : No hi ha cap connexi\ufffd per al client >> " + clientId);
                    }
                    catch (IOException o) {
                        System.out.println("ScannerBridge : Error enviant dades cap al client (WebSocket) >> " + o.getMessage());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void sendCommand(Command command) {
        this.commandQueue.offer(command);
    }

    public void addWebSocket(String clientId, Session session) {
        if (session.isOpen()) {
            System.out.println("ScannerBridge : Afegint nova connexi\ufffd amb el client [" + clientId + "]");
            this.sessions.put(clientId, session);
            this.commandQueue.offer(new ClientAcknowledgeCommand(clientId));
        } else {
            System.out.println("ScannerBridge : La connexi\ufffd del client [" + clientId + "] ja es troba tancada");
        }
    }

    public void removeWebSocket(String clientId) {
        System.out.println("ScannerBridge : Eliminant connexi\ufffd del client [" + clientId + "]");
        Session session = this.sessions.remove(clientId);
        if (session != null) {
            try {
                session.close(1, "Client exited");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

