/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.signature.rsa;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.Signature;

public class SunMSCApiRSAWrapper {
    private static final Class<?> spic;

    static {
        Class cspi = null;
        try {
            Signature signature = Signature.getInstance("SHA256withRSA", "SunMSCAPI");
            Field f = signature.getClass().getDeclaredField("sigSpi");
            f.setAccessible(true);
            Object aspi = f.get(signature);
            cspi = aspi.getClass();
        }
        catch (Exception e) {
            cspi = Object.class;
        }
        spic = cspi;
    }

    public static byte[] cipher(String algorithm, byte[] hash, PrivateKey privateKey) throws Exception {
        byte[] rsaBytes = SunMSCApiRSAWrapper.signHash(algorithm, hash, privateKey);
        return SunMSCApiRSAWrapper.convertEndianArray(rsaBytes);
    }

    private static byte[] convertEndianArray(byte[] paramArrayOfByte) {
        if (paramArrayOfByte == null || paramArrayOfByte.length == 0) {
            return paramArrayOfByte;
        }
        byte[] arrayOfByte = new byte[paramArrayOfByte.length];
        int i = 0;
        while (i < paramArrayOfByte.length) {
            arrayOfByte[i] = paramArrayOfByte[paramArrayOfByte.length - i - 1];
            ++i;
        }
        return arrayOfByte;
    }

    private static long getHCryptProvider(PrivateKey privateKey) throws Exception {
        Method getHCryptProvider = privateKey.getClass().getMethod("getHCryptProvider", new Class[0]);
        getHCryptProvider.setAccessible(true);
        return (Long)getHCryptProvider.invoke((Object)privateKey, new Object[0]);
    }

    private static long getHCryptKey(PrivateKey privateKey) throws Exception {
        Method getHCryptKey = privateKey.getClass().getMethod("getHCryptKey", new Class[0]);
        getHCryptKey.setAccessible(true);
        return (Long)getHCryptKey.invoke((Object)privateKey, new Object[0]);
    }

    private static byte[] signHash(String algorithm, byte[] hash, PrivateKey privateKey) throws Exception {
        long hcp = SunMSCApiRSAWrapper.getHCryptProvider(privateKey);
        long hck = SunMSCApiRSAWrapper.getHCryptKey(privateKey);
        Method signHash = spic.getSuperclass().getDeclaredMethod("signHash", Boolean.TYPE, byte[].class, Integer.TYPE, String.class, Long.TYPE, Long.TYPE);
        signHash.setAccessible(true);
        boolean raw = "sun.security.mscapi.RSASignature$RAW".equals(spic.getName());
        return (byte[])signHash.invoke(null, raw, hash, hash.length, algorithm, hcp, hck);
    }
}

