/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.signature.rsa;

import java.security.Key;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.pkcs11.SunPKCS11;

public class KeyStoreService {
    private static KeyStoreService _instance = null;
    private KeyStore keystore;
    private volatile boolean available = false;
    private volatile String providerType = null;
    private Map<String, String> aliases;

    public static synchronized KeyStoreService getInstance() {
        if (_instance == null) {
            _instance = new KeyStoreService();
        }
        return _instance;
    }

    public KeyStoreService() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    KeyStoreService.this.forceLoad();
                    Enumeration<String> aliases = KeyStoreService.this.keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        aliases.nextElement();
                    }
                }
                catch (Exception e) {
                    KeyStoreService.this.available = false;
                }
            }
        };
        t.start();
    }

    private final void forceLoad() throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.providerType = "SunMSCAPI";
            this.keystore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
            this.keystore.load(null, "FAKE_PIN".toCharArray());
            this.available = true;
        } else {
            this.providerType = "SunPKCS11";
            if (Security.getProvider("SunPKCS11") == null) {
                String configName = "/opt/bar/cfg/pkcs11.cfg";
                SunPKCS11 p = new SunPKCS11(configName);
                Security.addProvider(p);
            }
            this.keystore = KeyStore.getInstance("PKCS11", "SunPKCS11");
            this.keystore.load(null, "2007".toCharArray());
            this.available = true;
        }
    }

    public Map<String, String> aliases() throws Exception {
        if (!this.available) {
            throw new Exception("No s'ha pogut accedir al magatzem de claus de signatura");
        }
        Enumeration<String> ksaliases = this.keystore.aliases();
        this.aliases = new LinkedHashMap<String, String>();
        int i = 0;
        while (ksaliases.hasMoreElements()) {
            this.aliases.put(String.valueOf(i), ksaliases.nextElement());
            ++i;
        }
        return this.aliases;
    }

    public Certificate[] getCertificateChain(String alias) throws Exception {
        if (!this.available) {
            throw new Exception("No s'ha pogut accedir al magatzem de claus de signatura");
        }
        return this.keystore.getCertificateChain(alias);
    }

    public Certificate[] getCertificateChainById(String aliasId) throws Exception {
        if (!this.available) {
            throw new Exception("No s'ha pogut accedir al magatzem de claus de signatura");
        }
        return this.keystore.getCertificateChain(this.aliases.get(aliasId));
    }

    public Key getPrivateKey(String alias, String pin) throws Exception {
        if (!this.available) {
            throw new Exception("No s'ha pogut accedir al magatzem de claus de signatura");
        }
        return this.keystore.getKey(alias, pin.toCharArray());
    }

    public Key getPrivateKeyById(String aliasId, String pin) throws Exception {
        if (!this.available) {
            throw new Exception("No s'ha pogut accedir al magatzem de claus de signatura");
        }
        return this.keystore.getKey(this.aliases.get(aliasId), pin.toCharArray());
    }

    public String getKeyStoreType() {
        return this.providerType;
    }

    public void reload() {
        try {
            this.forceLoad();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void installCACertificateIfNeeded() {
        Thread t = new Thread(){

            @Override
            public void run() {
                String osName = System.getProperty("os.name");
                if (osName.startsWith("Windows")) {
                    System.err.println("Verificant si cal instal.lar el certificat de la CA d'aplicacions natives al magatzem de Windows");
                    try {
                        System.err.println("   Obrint magatzem de claus...");
                        KeyStore rootKeystore = KeyStore.getInstance("Windows-ROOT", "SunMSCAPI");
                        rootKeystore.load(null, "FAKE_PIN".toCharArray());
                        System.err.println("   Comprobant la existencia del certificat...");
                        Certificate certificate = rootKeystore.getCertificate("DEV_CA");
                        if (certificate == null) {
                            System.err.println("   El certificat no es troba instal.lat. Procedint a carregar-lo. Windows us demanar\u00e0 autoritzaci\u00f3.");
                            certificate = CertificateFactory.getInstance("X509").generateCertificate(Thread.currentThread().getContextClassLoader().getResourceAsStream("ca.crt"));
                            rootKeystore.setCertificateEntry("DEV_CA", certificate);
                        } else {
                            System.err.println("   El certificat ja es troba instal.lat.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
    }
}

