/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge;

import cat.aoc.scanner.bridge.servlet.ScanServiceWebsocketServlet;
import cat.aoc.scanner.bridge.signature.rsa.KeyStoreService;
import cat.aoc.scanner.bridge.util.ConfigurationUtils;
import cat.aoc.scanner.bridge.wrapper.ManagerWrapper;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.imageio.ImageIO;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ScannerBridge {
    private static final byte[] p = new byte[]{99, 104, 97, 110, 103, 101, 105, 116};
    private static final String KEYSTORE_TYPE_P12 = "PKCS12";
    private static final String KEYSTORE_TYPE_JKS = "JKS";
    private static final String PARAM_KS_PATH = "bridge.module.server.cert.keystore.path";
    private static final String PARAM_KS_TYPE = "bridge.module.server.cert.keystore.type";
    private static final String PARAM_KS_PIN = "bridge.module.server.cert.keystore.pin";
    private static final String PARAM_KS_ALIAS = "bridge.module.server.cert.keystore.alias";
    private static final String PARAM_KS_KEY_PASSWORD = "bridge.module.server.cert.keystore.key.password";

    public static void main(String[] args) throws Exception {
        ConfigurationUtils.addExplicitScannerDeviceTypes();
        KeyStoreService.getInstance().installCACertificateIfNeeded();
        Server server = new Server();
        ScannerBridge.setupTray(server);
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        ServerCertificate serverCertificate = ScannerBridge.getServerCertificateParams();
        if (serverCertificate == null) {
            URL r = Thread.currentThread().getContextClassLoader().getResource("resource");
            Resource resource = URLResource.newResource((URL)r);
            sslContextFactory.setKeyStoreResource(resource);
            sslContextFactory.setKeyStorePassword(new String(p));
            sslContextFactory.setKeyManagerPassword(new String(p));
        } else {
            KeyStore ks;
            System.out.println("[WARN] Establint com a certificat de servidor un certificat proporcionat pel usuari");
            System.out.println("[WARN]   Path : " + serverCertificate.getKeystorePath());
            System.out.println("[WARN]   Tipus: " + serverCertificate.getKeystoreType());
            System.out.println("[WARN]   Alias: " + serverCertificate.getKeystoreAlias());
            if (KEYSTORE_TYPE_P12.equals(serverCertificate.getKeystoreType())) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                sslContextFactory.setKeyStoreType(KEYSTORE_TYPE_P12);
                sslContextFactory.setKeyStoreProvider("BC");
                ks = KeyStore.getInstance(KEYSTORE_TYPE_P12, (Provider)new BouncyCastleProvider());
                ks.load(new FileInputStream(serverCertificate.getKeystorePath()), serverCertificate.getKeystorePin().toCharArray());
                sslContextFactory.setKeyStore(ks);
            } else {
                sslContextFactory.setKeyStoreType(KEYSTORE_TYPE_JKS);
                sslContextFactory.setKeyStoreProvider("SUN");
                ks = KeyStore.getInstance(KEYSTORE_TYPE_JKS);
                ks.load(new FileInputStream(serverCertificate.getKeystorePath()), serverCertificate.getKeystorePin().toCharArray());
                sslContextFactory.setKeyStore(ks);
            }
            sslContextFactory.setKeyStorePassword(serverCertificate.getKeystorePin());
            sslContextFactory.setKeyManagerPassword(serverCertificate.getKeystoreKeyPassword());
            sslContextFactory.setCertAlias(serverCertificate.getKeystoreAlias());
        }
        int serverPort = ScannerBridge.getPortParam();
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        sslConnector.setPort(serverPort);
        server.setConnectors(new Connector[]{sslConnector});
        ServletContextHandler ctx = new ServletContextHandler();
        ctx.setContextPath("/");
        ctx.addServlet(ScanServiceWebsocketServlet.class, "/ctrl");
        server.setHandler((Handler)ctx);
        server.setStopAtShutdown(true);
        server.start();
        server.join();
        if (SystemTray.isSupported()) {
            TrayIcon[] icons;
            SystemTray tray = SystemTray.getSystemTray();
            TrayIcon[] trayIconArray = icons = tray.getTrayIcons();
            int n = icons.length;
            int n2 = 0;
            while (n2 < n) {
                TrayIcon icon = trayIconArray[n2];
                tray.remove(icon);
                ++n2;
            }
        }
    }

    private static int getPortParam() {
        String portParameter = System.getProperty("bridge.module.port");
        if (portParameter != null) {
            try {
                return Integer.parseInt(portParameter);
            }
            catch (NumberFormatException f) {
                System.out.println("El valor del par\u00e0metre 'bridge.module.port' ha de ser un n\u00famero sencer.");
            }
        }
        return 7001;
    }

    private static ServerCertificate getServerCertificateParams() {
        ServerCertificate serverCertificate = null;
        if (System.getProperty(PARAM_KS_PATH) != null && System.getProperty(PARAM_KS_PIN) != null && System.getProperty(PARAM_KS_ALIAS) != null) {
            serverCertificate = new ServerCertificate();
            String ksType = System.getProperty(PARAM_KS_TYPE);
            if (ksType == null) {
                ksType = KEYSTORE_TYPE_P12;
            }
            serverCertificate.setKeystorePath(System.getProperty(PARAM_KS_PATH));
            serverCertificate.setKeystoreType(ksType);
            serverCertificate.setKeystorePin(System.getProperty(PARAM_KS_PIN));
            serverCertificate.setKeystoreAlias(System.getProperty(PARAM_KS_ALIAS));
            serverCertificate.setKeystoreKeyPassword(System.getProperty(PARAM_KS_KEY_PASSWORD));
        }
        return serverCertificate;
    }

    private static void setupTray(Server server) {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            int width = (int)tray.getTrayIconSize().getWidth();
            BufferedImage image = null;
            try {
                image = ImageIO.read(Thread.currentThread().getContextClassLoader().getResourceAsStream("tray_icon_" + width + ".png"));
                ActionListener iconListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println(String.valueOf(e.getActionCommand()) + " : " + e.getID() + " : " + e.getModifiers());
                    }
                };
                TrayIcon trayIcon = new TrayIcon(image, "M\u00f2dul de connexi\u00f3 amb el scanner - Consorci AOC");
                trayIcon.addActionListener(iconListener);
                ManagerWrapper.setTrayIcon(trayIcon);
                tray.add(trayIcon);
            }
            catch (Exception e) {
                System.out.println("No ha estat possible afegir la icona a la safata del sistema operatiu");
            }
        } else {
            System.out.println("No \ufffds possible afegir la icona a la safata del sistema operatiu");
        }
        ManagerWrapper.get();
    }

    public static class ServerCertificate {
        private String keystorePath;
        private String keystoreType;
        private String keystorePin;
        private String keystoreAlias;
        private String keystoreKeyPassword;

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public String getKeystoreType() {
            return this.keystoreType;
        }

        public void setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
        }

        public String getKeystorePin() {
            return this.keystorePin;
        }

        public void setKeystorePin(String keystorePin) {
            this.keystorePin = keystorePin;
        }

        public String getKeystoreAlias() {
            return this.keystoreAlias;
        }

        public void setKeystoreAlias(String keystoreAlias) {
            this.keystoreAlias = keystoreAlias;
        }

        public String getKeystoreKeyPassword() {
            return this.keystoreKeyPassword;
        }

        public void setKeystoreKeyPassword(String keystoreKeyPassword) {
            this.keystoreKeyPassword = keystoreKeyPassword;
        }
    }
}

