/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.service;

import cat.aoc.scanner.bridge.CurrentScanJobHolder;
import cat.aoc.scanner.bridge.service.IScanService;
import cat.aoc.scanner.bridge.service.ScanJob;
import cat.aoc.scanner.bridge.service.ScanJobType;
import cat.aoc.scanner.bridge.util.Latch;
import cat.aoc.scanner.bridge.wrapper.DeviceInfo;
import cat.aoc.scanner.bridge.wrapper.ManagerWrapper;
import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.Manager;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferDoneListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ScanServiceImpl
implements IScanService {
    private static final Map<String, int[]> SIZES = new HashMap<String, int[]>();
    private static final Map<Long, Integer> RESOLUTIONS;
    private static final Map<String, Thread> RUNNING_JOBS;
    public static final int W = 0;
    public static final int H = 1;
    public static final int A4 = 0;
    public static final int A3 = 1;
    public static final String DEFAULT_FORMAT = "A4";
    public static final Long DEFAULT_RESOLUTION;

    static {
        SIZES.put(null, new int[]{827, 1170});
        SIZES.put(DEFAULT_FORMAT, new int[]{827, 1170});
        SIZES.put("A3", new int[]{1170, 1654});
        RESOLUTIONS = new HashMap<Long, Integer>();
        RESOLUTIONS.put(null, 300);
        RESOLUTIONS.put(100L, 100);
        RESOLUTIONS.put(200L, 200);
        RESOLUTIONS.put(300L, 300);
        RUNNING_JOBS = new HashMap<String, Thread>();
        DEFAULT_RESOLUTION = 300L;
    }

    public ScanServiceImpl() {
        Configuration.setLogLevel((Level)Level.INFO);
    }

    @Override
    public void scanDocument(String deviceName, final Long resolution, final String format, final String clientId) throws Exception {
        if ("true".equalsIgnoreCase(System.getProperty("morena.debug"))) {
            Configuration.setLogLevel((Level)Level.ALL);
        }
        if (!RESOLUTIONS.containsKey(resolution)) {
            throw new Exception("Nom\ufffds es suporta com a resoluci\ufffd d'escaneig 100dpi, 200dpi o 300dpi");
        }
        if (!SIZES.containsKey(format)) {
            throw new Exception("Nom\ufffds es suporta com a formats d'escaneig A4 i A3");
        }
        final DeviceInfo jobDeviceInfo = ManagerWrapper.getCurrentlyInUse();
        final Latch latch = new Latch();
        final ScanJob scanJob = new ScanJob(clientId, latch);
        Thread job = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block21: {
                    Manager manager = ManagerWrapper.get();
                    Device selectedDevice = ScanServiceImpl.this.selectDevice(manager);
                    if (selectedDevice != null && selectedDevice instanceof Scanner) {
                        CurrentScanJobHolder.setCurrentScanJob(scanJob);
                        Scanner scanner = (Scanner)selectedDevice;
                        scanner.setMode(16);
                        scanner.setResolution(((Integer)RESOLUTIONS.get(resolution)).intValue());
                        System.out.println("\u00c0rea d'escaneig establerta a : [0, 0]x[" + ((int[])SIZES.get(format))[0] * (Integer)RESOLUTIONS.get(resolution) / 100 + ", " + ((int[])SIZES.get(format))[1] * (Integer)RESOLUTIONS.get(resolution) / 100 + "]");
                        scanner.setFrame(0, 0, ((int[])SIZES.get(format))[0] * (Integer)RESOLUTIONS.get(resolution) / 100, ((int[])SIZES.get(format))[1] * (Integer)RESOLUTIONS.get(resolution) / 100);
                        int feederUnit = scanner.getFeederFunctionalUnit();
                        int flatbedUnit = scanner.getFlatbedFunctionalUnit();
                        int selectedUnit = -1;
                        if (jobDeviceInfo != null) {
                            try {
                                selectedUnit = Integer.parseInt(jobDeviceInfo.getCurrentUnit());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (selectedUnit == -1) {
                            selectedUnit = feederUnit > -1 ? feederUnit : flatbedUnit;
                        }
                        System.out.println("Feeder unit slot  : " + feederUnit);
                        System.out.println("Flatbed unit slot : " + flatbedUnit);
                        System.out.println("Selected unit slot : " + selectedUnit);
                        try {
                            if (selectedUnit == feederUnit) {
                                System.out.println("Iniciant escaneig a scanner de tipus 'Feeder'");
                                scanJob.setType(ScanJobType.FEEDER);
                                if (scanner.isDuplexSupported()) {
                                    scanner.setDuplexEnabled(true);
                                }
                                while (scanJob.hasMoreImages()) {
                                    ScanJob scanJob2 = scanJob;
                                    synchronized (scanJob2) {
                                        selectedDevice.setFileName("mi_" + System.currentTimeMillis());
                                        scanner.startTransfer((TransferDoneListener)scanJob, feederUnit);
                                        scanJob.wait();
                                    }
                                }
                            } else if (selectedUnit == flatbedUnit) {
                                System.out.println("Iniciant escaneig a scanner de tipus 'Flatbed'");
                                scanJob.setType(ScanJobType.FLATBED);
                                latch.locked();
                                scanner.startTransfer((TransferDoneListener)scanJob);
                                latch.await();
                                System.out.println("Enviant senyal de finalitzaci\u00f3 de document");
                                scanJob.manuallyEndScanJob();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            CurrentScanJobHolder.reset();
                            break block21;
                        }
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                break block21;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                CurrentScanJobHolder.reset();
                            }
                        }
                        CurrentScanJobHolder.reset();
                    } else {
                        scanJob.transferFailed(22, "No hi ha cap scanner connectat");
                    }
                }
                System.out.println("Scan thread terminated");
                RUNNING_JOBS.remove(clientId);
            }
        };
        job.setName("Document scan thread");
        job.start();
        RUNNING_JOBS.put(scanJob.getClientId(), job);
    }

    @Override
    public synchronized void stopScanDocument() {
        ScanJob scanJob = CurrentScanJobHolder.getCurrentScanJob();
        scanJob.kill();
        RUNNING_JOBS.get(scanJob.getClientId()).interrupt();
        CurrentScanJobHolder.reset();
    }

    @Override
    public Device selectDevice(Manager manager) {
        return ManagerWrapper.getCurrentlyInUse().getWiaDevice();
    }
}

