/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class Renderer {
    private static final int A4 = 0;
    private static final int[][] SIZES = new int[][]{{2480, 3508}};

    public BufferedImage render(BufferedImage scannedImage) {
        BufferedImage renderedImage = null;
        try {
            try {
                renderedImage = this.transform(scannedImage, SIZES[0][0], SIZES[0][1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (scannedImage != null) {
                    try {
                        scannedImage.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                scannedImage = null;
            }
        }
        finally {
            if (scannedImage != null) {
                try {
                    scannedImage.flush();
                }
                catch (Exception exception) {}
            }
            scannedImage = null;
        }
        return renderedImage;
    }

    private BufferedImage transform(BufferedImage inputImage, int fullPageWidth, int fullPageHeight) throws IOException {
        BufferedImage outputImage = null;
        Graphics renderContext = null;
        try {
            if (inputImage != null) {
                outputImage = new BufferedImage(SIZES[0][0], SIZES[0][1], inputImage.getType());
                int renderedImageWidth = inputImage.getWidth();
                int renderedImageHeight = inputImage.getHeight();
                int renderedImageOffsetX = (fullPageWidth - renderedImageWidth) / 2;
                int renderedImageOffsetY = (fullPageHeight - renderedImageHeight) / 2;
                boolean landscape = false;
                if (renderedImageWidth > renderedImageHeight) {
                    landscape = true;
                    renderedImageOffsetX = fullPageWidth - (fullPageWidth - renderedImageHeight) / 2;
                    renderedImageOffsetY = (fullPageHeight - renderedImageWidth) / 2;
                } else {
                    landscape = false;
                    renderedImageOffsetX = (fullPageWidth - renderedImageWidth) / 2;
                    renderedImageOffsetY = (fullPageHeight - renderedImageHeight) / 2;
                }
                renderContext = (Graphics2D)outputImage.getGraphics();
                renderContext.setColor(Color.WHITE);
                renderContext.fillRect(0, 0, fullPageWidth, fullPageHeight);
                if (landscape) {
                    AffineTransform identity = new AffineTransform();
                    AffineTransform trans = new AffineTransform();
                    trans.setTransform(identity);
                    trans.translate(renderedImageOffsetX, renderedImageOffsetY);
                    trans.rotate(Math.toRadians(90.0));
                    ((Graphics2D)renderContext).drawImage(inputImage, trans, null);
                } else {
                    renderContext.drawImage(inputImage, renderedImageOffsetX, renderedImageOffsetY, renderedImageWidth, renderedImageHeight, null);
                }
            } else {
                outputImage = new BufferedImage(SIZES[0][0], SIZES[0][1], 5);
                renderContext = (Graphics2D)outputImage.getGraphics();
                renderContext.setColor(Color.WHITE);
                renderContext.fillRect(0, 0, fullPageWidth, fullPageHeight);
            }
        }
        finally {
            if (renderContext != null) {
                try {
                    renderContext.dispose();
                }
                catch (Exception exception) {}
            }
        }
        return outputImage;
    }
}

