/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.ui;

import eu.gnome.morena.Device;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.ui.SwingFormPane;
import eu.gnome.morena.wia.SupportedPropertyValues;
import eu.gnome.morena.wia.WIAScanner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class ScannerOptionPane
extends SwingFormPane {
    private static final long serialVersionUID = -4839795326051637411L;
    private static final int[] RESOL_SHORT_LIST = new int[]{50, 75, 100, 150, 200, 350, 600, 1200};
    private Scanner scanner;
    private WIAScanner wiaScanner;
    private Map<Integer, Mode> modesMap;
    private JComboBox<FUNIT> funitComp;
    private JCheckBox duplexComp;
    private JComboBox<Mode> modesComp;
    private JComboBox<Integer> resolComp;
    private JComboBox<PAPER_SOURCE> paperSourceComp;
    private JSlider brightnessComp;
    private JTextField brightnessField;
    private SliderListenerAndVerifier brightnessVerifier;
    private JSlider contrastComp;
    private JTextField contrastField;
    private SliderListenerAndVerifier contrastVerifier;
    private JButton okButton;
    private JButton cancelButton;
    private Action okAction = new AbstractAction("Scan"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(ScannerOptionPane.this.wiaScanner == null || ScannerOptionPane.this.brightnessVerifier.isCorrect && ScannerOptionPane.this.contrastVerifier.isCorrect)) {
                if (ScannerOptionPane.this.brightnessVerifier.isCorrect) {
                    ScannerOptionPane.this.contrastField.setBackground(Color.PINK);
                } else {
                    ScannerOptionPane.this.brightnessField.setBackground(Color.PINK);
                }
            } else {
                ScannerOptionPane.this.save();
                ScannerOptionPane.this.parent.setVisible(false);
            }
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent actionEvent) {
            ScannerOptionPane.this.parent.setVisible(false);
        }
    };

    public ScannerOptionPane(Window window) {
        super(window);
        this.modesMap = new HashMap<Integer, Mode>();
        Mode mode = new Mode(-1, "Black & White (1 bit)");
        this.modesMap.put(-1, mode);
        mode = new Mode(1, "Black & White (1 bit)");
        this.modesMap.put(1, mode);
        mode = new Mode(-8, "Grayscale (8 bit)");
        this.modesMap.put(-8, mode);
        mode = new Mode(-16, "Grayscale (16 bit)");
        this.modesMap.put(-16, mode);
        mode = new Mode(8, "Color (8 bit)");
        this.modesMap.put(8, mode);
        mode = new Mode(16, "Color (16 bit)");
        this.modesMap.put(16, mode);
    }

    public void load(Device device) {
        Serializable serializable;
        super.load(device);
        this.scanner = (Scanner)device;
        this.wiaScanner = device instanceof WIAScanner ? (WIAScanner)device : null;
        Vector<FUNIT> vector = new Vector<FUNIT>();
        if (this.scanner.getFlatbedFunctionalUnit() >= 0) {
            vector.add(FUNIT.FLATBED);
        }
        if (this.scanner.getFeederFunctionalUnit() >= 0) {
            vector.add(FUNIT.FEEDER);
        }
        if (vector.isEmpty()) {
            vector.add(FUNIT.DEFAULT);
        }
        this.funitComp = new JComboBox(vector);
        this.duplexComp = new JCheckBox("Duplex");
        this.duplexComp.setSelected(this.scanner.isDuplexEnabled());
        List<Integer> list = this.scanner.getSupportedModes();
        int n = this.scanner.getMode();
        Mode mode = this.modesMap.get(n);
        Vector<Mode> vector2 = new Vector<Mode>();
        for (Integer n2 : list) {
            Mode mode2 = this.modesMap.get(n2);
            if (mode2 == null) continue;
            vector2.add(mode2);
        }
        this.modesComp = new JComboBox(vector2);
        if (vector2.contains(mode)) {
            this.modesComp.setSelectedItem(mode);
        }
        ArrayList<Integer> arrayList = this.scanner.getSupportedResolutions();
        int n3 = this.scanner.getResolution();
        boolean bl = false;
        if (arrayList.size() > 20) {
            serializable = new ArrayList<Integer>();
            for (int i = 0; i < RESOL_SHORT_LIST.length; ++i) {
                if (!bl && RESOL_SHORT_LIST[i] > n3) {
                    ((ArrayList)serializable).add(n3);
                    bl = true;
                }
                if (!arrayList.contains(RESOL_SHORT_LIST[i])) continue;
                ((ArrayList)serializable).add(RESOL_SHORT_LIST[i]);
            }
            arrayList = serializable;
        }
        this.resolComp = new JComboBox<Integer>(arrayList.toArray(new Integer[arrayList.size()]));
        this.resolComp.setEditable(true);
        this.resolComp.setSelectedItem(n3);
        this.paperSourceComp = new JComboBox<PAPER_SOURCE>(PAPER_SOURCE.values());
        this.okButton = new JButton(this.okAction);
        this.cancelButton = new JButton(this.cancelAction);
        serializable = new JPanel();
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(20, 1, 10, 1));
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(3);
        ((Container)serializable).setLayout(gridLayout);
        ((Container)serializable).add(this.okButton);
        ((Container)serializable).add(this.cancelButton);
        int n4 = 0;
        this.add(null, new JLabel("Source"), 0, n4, 1, 1, 0, 17, 1, 1, true);
        this.add("fu", this.funitComp, 1, n4, 1, 1, 0, 17, 100, 1, true);
        this.add("duplex", this.duplexComp, 2, n4++, 1, 1, 0, 17, 100, 1, this.scanner.isDuplexSupported());
        this.add(null, new JLabel(" "), 0, n4++, 3, 1, 1, 10, 1, 1, true);
        this.add(null, new JLabel("Mode"), 0, n4, 1, 1, 0, 17, 1, 1, true);
        this.add("mode", this.modesComp, 1, n4++, 2, 1, 0, 17, 100, 1, true);
        this.add(null, new JLabel("Resolution"), 0, n4, 1, 1, 0, 17, 1, 1, true);
        this.add("resolution", this.resolComp, 1, n4++, 2, 1, 0, 17, 100, 1, true);
        this.add(null, new JLabel("Page size"), 0, n4, 1, 1, 0, 17, 1, 1, true);
        this.add("pageSize", this.paperSourceComp, 1, n4++, 2, 1, 0, 17, 100, 1, true);
        if (this.wiaScanner != null) {
            int n5;
            this.add(null, new JLabel(" "), 0, n4++, 3, 1, 1, 10, 1, 1, true);
            SupportedPropertyValues supportedPropertyValues = this.wiaScanner.getPropertyValues(6154);
            if (supportedPropertyValues != null && supportedPropertyValues.isRange()) {
                n5 = supportedPropertyValues.getMaxValue() - supportedPropertyValues.getMinValue();
                this.brightnessComp = new JSlider(0, supportedPropertyValues.getMinValue(), supportedPropertyValues.getMaxValue(), this.wiaScanner.getBrightness());
                this.brightnessField = new JTextField(4);
                this.brightnessField.setText(String.valueOf(this.brightnessComp.getValue()));
                this.brightnessVerifier = new SliderListenerAndVerifier(this.brightnessComp, this.brightnessField);
                this.brightnessField.setInputVerifier(this.brightnessVerifier);
                this.brightnessComp.addChangeListener(this.brightnessVerifier);
                this.brightnessComp.setMajorTickSpacing(n5 / 2);
                this.brightnessComp.setPaintTicks(true);
                this.brightnessComp.setPaintLabels(true);
                this.add(null, new JLabel("Brightness", 4), 0, n4++, 3, 1, 0, 17, 1, 1, true);
                this.add(null, this.brightnessComp, 0, n4, 3, 1, 1, 17, 100, 1, true);
                this.add("brightness", this.brightnessField, 3, n4++, 1, 1, 0, 11, 1, 1, true);
            }
            if ((supportedPropertyValues = this.wiaScanner.getPropertyValues(6155)) != null && supportedPropertyValues.isRange()) {
                n5 = supportedPropertyValues.getMaxValue() - supportedPropertyValues.getMinValue();
                this.contrastComp = new JSlider(0, supportedPropertyValues.getMinValue(), supportedPropertyValues.getMaxValue(), this.wiaScanner.getContrast());
                this.contrastField = new JTextField(4);
                this.contrastField.setText(String.valueOf(this.contrastComp.getValue()));
                this.contrastVerifier = new SliderListenerAndVerifier(this.contrastComp, this.contrastField);
                this.contrastField.setInputVerifier(this.contrastVerifier);
                this.contrastComp.addChangeListener(this.contrastVerifier);
                this.contrastComp.setMajorTickSpacing(n5 / 2);
                this.contrastComp.setPaintTicks(true);
                this.contrastComp.setPaintLabels(true);
                this.add(null, new JLabel("Contrast", 4), 0, n4++, 3, 1, 0, 17, 1, 1, true);
                this.add(null, this.contrastComp, 0, n4, 3, 1, 1, 17, 100, 1, true);
                this.add("contrast", this.contrastField, 3, n4++, 1, 1, 0, 10, 1, 1, true);
            }
        }
        this.add(null, new JPanel(), 0, n4++, 4, 1, 0, 10, 100, 100, true);
        this.add(null, (Component)serializable, 0, n4++, 4, 1, 0, 10, 1, 1, true);
    }

    public void save() {
        PAPER_SOURCE pAPER_SOURCE;
        super.save();
        FUNIT fUNIT = (FUNIT)((Object)this.funitComp.getSelectedItem());
        if (fUNIT.equals((Object)FUNIT.FLATBED)) {
            this.scanner.setFunctionalUnit(this.scanner.getFlatbedFunctionalUnit());
        } else if (fUNIT.equals((Object)FUNIT.FEEDER)) {
            this.scanner.setFunctionalUnit(this.scanner.getFeederFunctionalUnit());
            this.scanner.setDuplexEnabled(this.duplexComp.isSelected());
        } else {
            this.scanner.setFunctionalUnit(0);
        }
        if (this.modesComp.getItemCount() > 0) {
            this.scanner.setMode(((Mode)this.modesComp.getSelectedItem()).value);
        }
        int n = (Integer)this.resolComp.getSelectedItem();
        if (this.resolComp.getItemCount() > 0) {
            this.scanner.setResolution(n);
        }
        if ((pAPER_SOURCE = (PAPER_SOURCE)((Object)this.paperSourceComp.getSelectedItem())) != PAPER_SOURCE.Default) {
            this.scanner.setFrame(0, 0, Math.round(pAPER_SOURCE.w * (float)n), Math.round(pAPER_SOURCE.h * (float)n));
        }
        if (this.wiaScanner != null) {
            this.wiaScanner.setBrightness(Integer.parseInt(this.brightnessField.getText()));
            this.wiaScanner.setContrast(Integer.parseInt(this.contrastField.getText()));
        }
        this.saved = true;
    }

    class SliderListenerAndVerifier
    extends InputVerifier
    implements ChangeListener {
        private JSlider sliderComp;
        private JTextComponent showComp;
        private boolean isCorrect;

        public SliderListenerAndVerifier(JSlider jSlider, JTextComponent jTextComponent) {
            this.sliderComp = jSlider;
            this.showComp = jTextComponent;
            this.isCorrect = true;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            this.showComp.setText(String.valueOf(jSlider.getValue()));
            this.showComp.setBackground(Color.WHITE);
        }

        public boolean verify(JComponent jComponent) {
            int n = 0;
            try {
                n = Integer.parseInt(((JTextComponent)jComponent).getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean bl = this.isCorrect = this.sliderComp.getMinimum() <= n && n <= this.sliderComp.getMaximum();
            if (this.isCorrect) {
                this.showComp.setBackground(Color.WHITE);
            } else {
                this.showComp.setBackground(Color.PINK);
            }
            return this.isCorrect;
        }
    }

    class Mode {
        private String desc;
        private int value;

        public Mode(int n, String string) {
            this.value = n;
            this.desc = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.value;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Mode mode = (Mode)object;
            if (!this.getOuterType().equals(mode.getOuterType())) {
                return false;
            }
            return this.value == mode.value;
        }

        public String toString() {
            return this.desc;
        }

        private ScannerOptionPane getOuterType() {
            return ScannerOptionPane.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PAPER_SOURCE {
        Default(0.0f, 0.0f),
        A4(8.27f, 11.67f),
        A5(5.83f, 8.27f),
        Letter(8.5f, 11.0f),
        Legal(8.5f, 14.0f);

        float w;
        float h;

        private PAPER_SOURCE(float f, float f2) {
            this.w = f;
            this.h = f2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FUNIT {
        FLATBED,
        FEEDER,
        DEFAULT;

    }
}

