/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena;

import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceListChangeListener;
import eu.gnome.morena.Version;
import eu.gnome.morena.ica.ICAManager;
import eu.gnome.morena.wia.WIAManager;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import sun.misc.BASE64Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Manager
implements Version {
    protected static String arch;
    protected static String os;
    protected static String verOS;
    protected static int wiaver;
    protected static String vendor;
    protected static String userHome;
    protected static byte[] licenseText;
    protected static byte[] licenseSignature;
    private static Logger logger;
    private static Vector<DeviceListChangeListener> deviceListChangeListeners;
    private boolean fireCalled = false;

    private static void installLibrary(File file, String string) throws Exception {
        int n;
        InputStream inputStream = Manager.class.getClassLoader().getResourceAsStream(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[10240];
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)fileOutputStream).close();
        inputStream.close();
    }

    public static Manager getInstance() {
        if (WIAManager.INSTANCE.available()) {
            return WIAManager.INSTANCE;
        }
        if (ICAManager.INSTANCE.available()) {
            return ICAManager.INSTANCE;
        }
        throw new Error("No Morena7 Manager implementation available");
    }

    protected Manager() {
    }

    public static void info(String string) {
        logger.log(Level.INFO, string);
    }

    public static void warning(String string) {
        logger.log(Level.WARNING, string);
    }

    public static void error(String string) {
        logger.log(Level.SEVERE, string);
    }

    public static void error(String string, Throwable throwable) {
        logger.log(Level.SEVERE, string, throwable);
    }

    public static void debug(String string) {
        logger.log(Level.FINE, string);
    }

    public static void trace(String string) {
        logger.log(Level.FINEST, string);
    }

    public Device selectDevice(Component component) {
        Object[] objectArray;
        Vector<Device> vector = new Vector<Device>();
        if (WIAManager.INSTANCE.available()) {
            vector.addAll(WIAManager.INSTANCE.listDevices());
        }
        if (ICAManager.INSTANCE.available()) {
            vector.addAll(ICAManager.INSTANCE.listDevices());
        }
        if ((objectArray = vector.toArray(new Device[vector.size()])).length == 0) {
            return null;
        }
        return (Device)JOptionPane.showInputDialog(component, "Select device", "Select device", 3, null, objectArray, objectArray[0]);
    }

    public abstract List<Device> listDevices();

    public void close() {
    }

    public void addDeviceListChangeListener(DeviceListChangeListener deviceListChangeListener) {
        deviceListChangeListeners.add(deviceListChangeListener);
    }

    public void removeDeviceListChangeListener(DeviceListChangeListener deviceListChangeListener) {
        deviceListChangeListeners.remove(deviceListChangeListener);
    }

    protected void fireDeviceConnected(Device device) {
        if (!this.fireCalled) {
            this.fireCalled = true;
            for (DeviceListChangeListener deviceListChangeListener : deviceListChangeListeners) {
                deviceListChangeListener.deviceConnected(device);
            }
            this.fireCalled = false;
        }
    }

    protected void fireDeviceDisconnected(Device device) {
        if (!this.fireCalled) {
            this.fireCalled = true;
            for (DeviceListChangeListener deviceListChangeListener : deviceListChangeListeners) {
                deviceListChangeListener.deviceDisconnected(device);
            }
            this.fireCalled = false;
        }
    }

    public boolean available() {
        return WIAManager.INSTANCE.available() || ICAManager.INSTANCE.available();
    }

    static {
        wiaver = 0;
        logger = null;
        logger = Logger.getLogger("morena");
        logger.setUseParentHandlers(false);
        logger.addHandler(new LogHandler());
        logger.setLevel(Configuration.getLogLevel());
        arch = System.getProperty("os.arch").toLowerCase();
        os = System.getProperty("os.name").toLowerCase();
        verOS = System.getProperty("os.version").toLowerCase();
        String string = System.getProperty("wia.version", "2");
        vendor = System.getProperty("java.vm.vendor").toLowerCase();
        userHome = System.getProperty("user.home");
        String string2 = null;
        File file = null;
        try {
            if (os.indexOf("windows") >= 0) {
                if (arch.indexOf("64") >= 0) {
                    if (verOS.startsWith("5") || string.equals("1")) {
                        string2 = System.mapLibraryName("morena64W1_29");
                        wiaver = 1;
                    } else if (verOS.startsWith("6") || verOS.startsWith("10")) {
                        string2 = System.mapLibraryName("morena64W2_29");
                        wiaver = 2;
                    } else {
                        System.err.println("OS version " + verOS + " is not supported!");
                    }
                } else if (verOS.startsWith("5") || string.equals("1")) {
                    string2 = System.mapLibraryName("morena32W1_29");
                    wiaver = 1;
                } else if (verOS.startsWith("6") || verOS.startsWith("10")) {
                    string2 = System.mapLibraryName("morena32W2_29");
                    wiaver = 2;
                } else {
                    System.err.println("OS version " + verOS + " is not supported!");
                }
            } else {
                string2 = System.mapLibraryName("morena_29");
                if (os.indexOf("mac") >= 0 && vendor.indexOf("oracle") >= 0) {
                    string2 = string2.substring(0, string2.lastIndexOf(".")) + ".jnilib";
                }
            }
            file = new File(TMP_DIR, string2);
            Manager.installLibrary(file, string2);
            System.load(file.getAbsolutePath());
            Manager.trace(file.getAbsolutePath() + " loaded...");
        }
        catch (Exception exception) {
            try {
                Manager.trace(file.getAbsolutePath() + " loaded failed: " + exception.getMessage());
                if (!(file.exists() && file.length() != 0L || (file = new File("tmp", string2)).exists() && file.length() != 0L)) {
                    Manager.installLibrary(file, string2);
                }
                System.load(file.getAbsolutePath());
                Manager.trace(file.getAbsolutePath() + " 2. loaded...");
            }
            catch (Exception exception2) {
                System.err.println(string2 + " not found...");
            }
        }
        try {
            int n;
            InputStream inputStream = Version.class.getResourceAsStream("/javatwain.license.properties");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.flush();
            licenseText = byteArrayOutputStream.toByteArray();
            inputStream = Version.class.getResourceAsStream("/javatwain.license.signature");
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.flush();
            licenseSignature = new BASE64Decoder().decodeBuffer(new String(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            throw new Error("License file not found");
        }
        deviceListChangeListeners = new Vector();
    }

    private static class LogHandler
    extends Handler {
        private LogHandler() {
        }

        public void close() throws SecurityException {
        }

        public void flush() {
            System.err.flush();
        }

        public void publish(LogRecord logRecord) {
            System.err.println(logRecord.getMessage());
        }
    }
}

