/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Camera;
import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.Manager;
import eu.gnome.morena.Scanner;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class MorenaExample {
    static Manager manager;
    static String deviceName;
    static int pages;

    public static void main(String[] stringArray) {
        MorenaExample morenaExample = new MorenaExample();
        System.err.println("MorenaExample(" + Arrays.toString(stringArray) + ") ... started at " + new Date());
        try {
            Configuration.setLogLevel(Level.FINEST);
            manager = Manager.getInstance();
            if (stringArray.length == 0) {
                morenaExample.simpleScan();
            } else if (stringArray[0].equalsIgnoreCase("batch")) {
                morenaExample.batchScan();
            } else if (stringArray.length == 1) {
                deviceName = stringArray[0];
                morenaExample.simpleScan();
            } else if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("batch")) {
                deviceName = stringArray[0];
                if (stringArray.length == 3) {
                    pages = Integer.parseInt(stringArray[2]);
                }
                morenaExample.batchScan();
            } else {
                System.err.println("Unrecognized parameters!");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            manager.close();
        }
        System.err.println("Finished.");
    }

    private void simpleScan() throws Exception {
        Device device = MorenaExample.selectDevice();
        if (device != null) {
            Object object;
            if (device instanceof Scanner) {
                object = (Scanner)device;
                object.setMode(8);
                object.setResolution(75);
                object.setFrame(0, 0, 622, 874);
            } else if (device instanceof Camera) {
                // empty if block
            }
            object = SynchronousHelper.scanImage(device);
            System.err.println("scanned image info: size=(" + ((BufferedImage)object).getWidth() + ", " + ((BufferedImage)object).getHeight() + ")   bit mode=" + ((BufferedImage)object).getColorModel().getPixelSize());
            Thread.sleep(30000L);
        }
    }

    private void batchScan() throws Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        Device device = MorenaExample.selectDevice();
        if (device != null && device instanceof Scanner) {
            Scanner scanner = (Scanner)device;
            scanner.setMode(8);
            scanner.setResolution(200);
            int n = scanner.getFeederFunctionalUnit();
            System.err.println("Feeder unit : " + (n >= 0 ? Integer.valueOf(n) : "none found - trying 0") + "  pages=" + pages);
            if (n < 0) {
                n = 0;
            }
            if (scanner.isDuplexSupported()) {
                scanner.setDuplexEnabled(true);
            }
            int n2 = 1;
            ScanSession scanSession = new ScanSession();
            try {
                scanSession.startSession(device, n, pages);
                File file = null;
                while (null != (file = scanSession.getImageFile())) {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    System.err.println("scanned image " + file.getPath() + " : size=(" + bufferedImage.getWidth() + ", " + bufferedImage.getHeight() + ")   bit mode=" + bufferedImage.getColorModel().getPixelSize());
                    if ("jpg".equalsIgnoreCase(ScanSession.getExt(file))) continue;
                    File file2 = new File(file.getParent(), "morena_example_img_" + n2++ + ".jpg");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ImageIO.write((RenderedImage)bufferedImage, "jpeg", fileOutputStream);
                    fileOutputStream.close();
                    arrayList.add(file2);
                }
            }
            catch (Exception exception) {
                if (scanSession.isEmptyFeeder()) {
                    System.err.println("No more sheets in the document feeder");
                }
                exception.printStackTrace();
            }
        }
        System.err.println("Scanning completed - check the images ... waiting 120s");
        Thread.sleep(120000L);
        for (File file : arrayList) {
            file.deleteOnExit();
        }
    }

    private static Device selectDevice() {
        List<Device> list = manager.listDevices();
        Device device = null;
        if (list.size() > 0) {
            if (deviceName != null) {
                for (Device device2 : list) {
                    System.err.println("connected device " + device2);
                    if (!device2.toString().startsWith(deviceName)) continue;
                    device = device2;
                }
            } else {
                device = list.get(0);
            }
        } else {
            System.out.println("No device connected!!!");
        }
        System.err.println("device selected = " + device);
        return device;
    }

    static {
        pages = 0;
    }
}

