/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.service;

import cat.aoc.scanner.bridge.CommandSender;
import cat.aoc.scanner.bridge.items.BinarySendCommand;
import cat.aoc.scanner.bridge.items.EmptyFeederCommand;
import cat.aoc.scanner.bridge.items.PageFailureCommand;
import cat.aoc.scanner.bridge.items.PageReadyCommand;
import cat.aoc.scanner.bridge.items.ProgressCommand;
import cat.aoc.scanner.bridge.service.ScanJobType;
import cat.aoc.scanner.bridge.util.Latch;
import eu.gnome.morena.TransferDoneListener;
import eu.gnome.morena.TransferListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class ScanJob
implements TransferDoneListener,
TransferListener {
    private String clientId;
    private boolean transferDoneCommandExecuted;
    private boolean hasMoreImages;
    private Latch latch;
    private ScanJobType type;
    private boolean killed;

    public ScanJob(String clientId, Latch latch) {
        this.latch = latch;
        this.clientId = clientId;
        this.transferDoneCommandExecuted = false;
        this.hasMoreImages = true;
        this.killed = false;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void transferProgress(int progress) {
        if (!this.killed) {
            ProgressCommand command = new ProgressCommand(this.clientId, progress);
            CommandSender.sendCommand(command);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transferDone(File imageFile) {
        this.transferDoneCommandExecuted = true;
        if (!this.killed) {
            CommandSender.sendCommand(new PageReadyCommand(this.clientId));
            try {
                try {
                    BufferedImage img = ImageIO.read(imageFile);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)img, "jpeg", baos);
                    BinarySendCommand command = new BinarySendCommand(this.clientId, ByteBuffer.wrap(baos.toByteArray()));
                    CommandSender.sendCommand(command);
                    return;
                }
                catch (Exception exception) {
                    imageFile.delete();
                    if (this.type != ScanJobType.FLATBED) return;
                    this.latch.unlocked();
                }
                return;
            }
            finally {
                imageFile.delete();
                if (this.type == ScanJobType.FLATBED) {
                    this.latch.unlocked();
                }
            }
        } else {
            imageFile.delete();
            if (this.type != ScanJobType.FLATBED) return;
            this.latch.unlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFailed(int errorCode, String errorMessage) {
        if (!this.killed) {
            if (!this.transferDoneCommandExecuted) {
                switch (errorCode) {
                    case 0: {
                        CommandSender.sendCommand(new EmptyFeederCommand(this.clientId));
                        break;
                    }
                    default: {
                        CommandSender.sendCommand(new PageFailureCommand(this.clientId, errorMessage));
                    }
                }
                this.hasMoreImages = false;
            } else {
                this.hasMoreImages = true;
            }
            this.transferDoneCommandExecuted = false;
            if (this.type == ScanJobType.FEEDER) {
                ScanJob scanJob = this;
                synchronized (scanJob) {
                    this.notify();
                }
            } else {
                this.latch.unlocked();
            }
        } else {
            this.hasMoreImages = false;
            this.transferDoneCommandExecuted = true;
        }
    }

    public boolean hasMoreImages() {
        return this.hasMoreImages;
    }

    public void manuallyEndScanJob() {
        this.hasMoreImages = false;
        try {
            Thread.sleep(400L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommandSender.sendCommand(new EmptyFeederCommand(this.clientId));
    }

    public void kill() {
        this.killed = true;
        this.hasMoreImages = false;
        this.latch.unlocked();
    }

    public void setType(ScanJobType type) {
        this.type = type;
    }
}

