/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge;

import cat.aoc.scanner.bridge.servlet.ScanServiceWebsocketServlet;
import cat.aoc.scanner.bridge.signature.rsa.KeyStoreService;
import cat.aoc.scanner.bridge.util.ConfigurationUtils;
import cat.aoc.scanner.bridge.wrapper.ManagerWrapper;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ScannerBridge {
    private static final byte[] p = new byte[]{99, 104, 97, 110, 103, 101, 105, 116};

    public static void main(String[] args) throws Exception {
        ConfigurationUtils.addExplicitScannerDeviceTypes();
        KeyStoreService.getInstance().installCACertificateIfNeeded();
        Server server = new Server();
        ScannerBridge.setupTray(server);
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        URL r = Thread.currentThread().getContextClassLoader().getResource("resource");
        Resource resource = URLResource.newResource((URL)r);
        sslContextFactory.setKeyStoreResource(resource);
        sslContextFactory.setKeyStorePassword(new String(p));
        sslContextFactory.setKeyManagerPassword(new String(p));
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        sslConnector.setPort(7001);
        server.setConnectors(new Connector[]{sslConnector});
        ServletContextHandler ctx = new ServletContextHandler();
        ctx.setContextPath("/");
        ctx.addServlet(ScanServiceWebsocketServlet.class, "/ctrl");
        server.setHandler((Handler)ctx);
        server.setStopAtShutdown(true);
        server.start();
        server.join();
        if (SystemTray.isSupported()) {
            TrayIcon[] icons;
            SystemTray tray = SystemTray.getSystemTray();
            TrayIcon[] trayIconArray = icons = tray.getTrayIcons();
            int n = icons.length;
            int n2 = 0;
            while (n2 < n) {
                TrayIcon icon = trayIconArray[n2];
                tray.remove(icon);
                ++n2;
            }
        }
    }

    private static void setupTray(Server server) {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            int width = (int)tray.getTrayIconSize().getWidth();
            BufferedImage image = null;
            try {
                image = ImageIO.read(Thread.currentThread().getContextClassLoader().getResourceAsStream("tray_icon_" + width + ".png"));
                ActionListener iconListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println(String.valueOf(e.getActionCommand()) + " : " + e.getID() + " : " + e.getModifiers());
                    }
                };
                TrayIcon trayIcon = new TrayIcon(image, "M\u00f2dul de connexi\u00f3 amb el scanner - Consorci AOC");
                trayIcon.addActionListener(iconListener);
                ManagerWrapper.setTrayIcon(trayIcon);
                tray.add(trayIcon);
            }
            catch (Exception e) {
                System.out.println("No ha estat possible afegir la icona a la safata del sistema operatiu");
            }
        } else {
            System.out.println("No \ufffds possible afegir la icona a la safata del sistema operatiu");
        }
        ManagerWrapper.get();
    }
}

