/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.wia;

import eu.gnome.morena.wia.WIAConstants;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedPropertyValues
implements WIAConstants {
    private int propId;
    private String desc;
    private int propertyFlag;
    private boolean isCurrentValueSet;
    private int currentValue;
    private int[] values;

    public SupportedPropertyValues(int n, String string, boolean bl, int n2, int n3, int[] nArray) {
        this.propId = n;
        this.desc = string;
        this.isCurrentValueSet = bl;
        this.currentValue = n2;
        this.propertyFlag = n3;
        this.values = nArray;
    }

    public List<Integer> getList() {
        Vector<Integer> vector;
        block3: {
            block2: {
                vector = new Vector<Integer>();
                if (!this.isList()) break block2;
                for (int i = 2; i < this.values.length; ++i) {
                    vector.add(this.values[i]);
                }
                break block3;
            }
            if (!this.isRange()) break block3;
            for (int i = this.values[0]; i <= this.values[2]; i += this.values[3]) {
                vector.add(i);
            }
        }
        return vector;
    }

    public int getDefaultValue() {
        if (this.values.length > 0) {
            if (this.isList()) {
                return this.values[1];
            }
            if (this.isRange()) {
                return this.values[1];
            }
            if (this.isFlag()) {
                return this.values[0];
            }
        }
        return 0;
    }

    public boolean isCurrentValueSet() {
        return this.isCurrentValueSet;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public boolean isFlagSet(int n) {
        return (this.values[0] & n) > 0;
    }

    public boolean isWritable() {
        return (this.propertyFlag & 2) > 0;
    }

    public boolean isList() {
        return (this.propertyFlag & 0x20) > 0 && this.values.length > 2;
    }

    public boolean isRange() {
        return (this.propertyFlag & 0x10) > 0 && this.values.length > 3;
    }

    public boolean isFlag() {
        return (this.propertyFlag & 0x40) > 0 && this.values.length > 1;
    }

    public boolean isNone() {
        return (this.propertyFlag & 8) > 0;
    }

    public int getMaxValue() {
        if (this.isRange()) {
            return this.values[2];
        }
        if (this.isList()) {
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < this.values.length; ++i) {
                if (n >= this.values[i]) continue;
                n = this.values[i];
            }
            return n;
        }
        return Integer.MAX_VALUE;
    }

    public int getMinValue() {
        if (this.isRange()) {
            return this.values[0];
        }
        if (this.isList()) {
            int n = Integer.MAX_VALUE;
            for (int i = 0; i < this.values.length; ++i) {
                if (n <= this.values[i]) continue;
                n = this.values[i];
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public String toString() {
        return this.propId + " " + Arrays.toString(this.values);
    }

    public String print() {
        StringBuilder stringBuilder = new StringBuilder(128);
        String string = this.isCurrentValueSet ? String.format("- 0x%1$-8X (%1$d) ", this.currentValue) : "                         ";
        stringBuilder.append(String.format("%8d - ", this.propId)).append(String.format("%-30s ", this.desc)).append(String.format("%-25s", string)).append(String.format("   %05X ", this.propertyFlag)).append(String.format("%3s ", this.accessFlags(this.propertyFlag)));
        if (this.isList()) {
            stringBuilder.append("list ").append(this.getList()).append(" (").append(this.values[1]).append(")");
        } else if (this.isRange()) {
            stringBuilder.append("range from ").append(this.values[0]).append(" to ").append(this.values[2]).append(" step ").append(this.values[3]).append(" (").append(this.values[1]).append(")");
        } else if (this.isFlag()) {
            stringBuilder.append("flag ").append(String.format("%08X ", this.values[1])).append(" (").append(this.values[0]).append(")");
        } else if (this.isNone()) {
            stringBuilder.append("none");
        } else if ((this.propertyFlag & 0x20) > 0) {
            stringBuilder.append("list empty");
        } else if ((this.propertyFlag & 0x10) > 0) {
            stringBuilder.append("range empty");
        } else if ((this.propertyFlag & 0x40) > 0) {
            stringBuilder.append("flag empty");
        }
        return stringBuilder.toString();
    }

    private String accessFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder(8);
        if ((n & 0x10000) > 0) {
            stringBuilder.append('C');
        }
        if ((n & 1) > 0) {
            stringBuilder.append('R');
        }
        if ((n & 2) > 0) {
            stringBuilder.append('W');
        }
        return stringBuilder.toString();
    }
}

