/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.ui;

import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceUIDialog;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.ui.PreviewPane;
import eu.gnome.morena.ui.ScannerOptionPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class ScannerUIDialog
extends JDialog
implements DeviceUIDialog {
    private static final long serialVersionUID = -8255757619418987701L;
    private boolean usePreview = false;
    Scanner scanner;
    Point location;

    public static ScannerUIDialog createDeviceUI(Object object, Device device) throws Exception {
        if (object instanceof Component && device instanceof Scanner) {
            return new ScannerUIDialog((Component)object, (Scanner)device);
        }
        throw new Exception("Wrong argument types used in createDeviceUI(" + object.getClass().getName() + ", " + device.getClass().getName());
    }

    private ScannerUIDialog(Component component, Scanner scanner) {
        super(ScannerUIDialog.getOwnerWindowForComponent(component), Dialog.ModalityType.APPLICATION_MODAL);
        this.scanner = scanner;
        this.setTitle("Scanning options");
        this.location = ScannerUIDialog.getOwnerWindowForComponent(component).getLocation();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    public boolean display() {
        ScannerOptionPane scannerOptionPane = new ScannerOptionPane(this);
        scannerOptionPane.load(this.scanner);
        if (this.usePreview) {
            JSplitPane jSplitPane = new JSplitPane(1);
            PreviewPane previewPane = new PreviewPane(this, scannerOptionPane);
            previewPane.load(this.scanner);
            jSplitPane.add(scannerOptionPane);
            jSplitPane.add(previewPane);
            this.add(jSplitPane);
        } else {
            this.add(scannerOptionPane);
        }
        this.pack();
        this.location.translate(50, 50);
        this.setLocation(this.location);
        this.setVisible(true);
        return scannerOptionPane.isSaved();
    }

    private static Window getOwnerWindowForComponent(Component component) {
        if (component == null) {
            JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return ScannerUIDialog.getOwnerWindowForComponent(component.getParent());
    }
}

