/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.util;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;

public class Base64 {
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final Map<Character, Integer> DECODE_MAP = new HashMap<Character, Integer>();

    static {
        DECODE_MAP.put(Character.valueOf('A'), 0);
        DECODE_MAP.put(Character.valueOf('B'), 1);
        DECODE_MAP.put(Character.valueOf('C'), 2);
        DECODE_MAP.put(Character.valueOf('D'), 3);
        DECODE_MAP.put(Character.valueOf('E'), 4);
        DECODE_MAP.put(Character.valueOf('F'), 5);
        DECODE_MAP.put(Character.valueOf('G'), 6);
        DECODE_MAP.put(Character.valueOf('H'), 7);
        DECODE_MAP.put(Character.valueOf('I'), 8);
        DECODE_MAP.put(Character.valueOf('J'), 9);
        DECODE_MAP.put(Character.valueOf('K'), 10);
        DECODE_MAP.put(Character.valueOf('L'), 11);
        DECODE_MAP.put(Character.valueOf('M'), 12);
        DECODE_MAP.put(Character.valueOf('N'), 13);
        DECODE_MAP.put(Character.valueOf('O'), 14);
        DECODE_MAP.put(Character.valueOf('P'), 15);
        DECODE_MAP.put(Character.valueOf('Q'), 16);
        DECODE_MAP.put(Character.valueOf('R'), 17);
        DECODE_MAP.put(Character.valueOf('S'), 18);
        DECODE_MAP.put(Character.valueOf('T'), 19);
        DECODE_MAP.put(Character.valueOf('U'), 20);
        DECODE_MAP.put(Character.valueOf('V'), 21);
        DECODE_MAP.put(Character.valueOf('W'), 22);
        DECODE_MAP.put(Character.valueOf('X'), 23);
        DECODE_MAP.put(Character.valueOf('Y'), 24);
        DECODE_MAP.put(Character.valueOf('Z'), 25);
        DECODE_MAP.put(Character.valueOf('a'), 26);
        DECODE_MAP.put(Character.valueOf('b'), 27);
        DECODE_MAP.put(Character.valueOf('c'), 28);
        DECODE_MAP.put(Character.valueOf('d'), 29);
        DECODE_MAP.put(Character.valueOf('e'), 30);
        DECODE_MAP.put(Character.valueOf('f'), 31);
        DECODE_MAP.put(Character.valueOf('g'), 32);
        DECODE_MAP.put(Character.valueOf('h'), 33);
        DECODE_MAP.put(Character.valueOf('i'), 34);
        DECODE_MAP.put(Character.valueOf('j'), 35);
        DECODE_MAP.put(Character.valueOf('k'), 36);
        DECODE_MAP.put(Character.valueOf('l'), 37);
        DECODE_MAP.put(Character.valueOf('m'), 38);
        DECODE_MAP.put(Character.valueOf('n'), 39);
        DECODE_MAP.put(Character.valueOf('o'), 40);
        DECODE_MAP.put(Character.valueOf('p'), 41);
        DECODE_MAP.put(Character.valueOf('q'), 42);
        DECODE_MAP.put(Character.valueOf('r'), 43);
        DECODE_MAP.put(Character.valueOf('s'), 44);
        DECODE_MAP.put(Character.valueOf('t'), 45);
        DECODE_MAP.put(Character.valueOf('u'), 46);
        DECODE_MAP.put(Character.valueOf('v'), 47);
        DECODE_MAP.put(Character.valueOf('w'), 48);
        DECODE_MAP.put(Character.valueOf('x'), 49);
        DECODE_MAP.put(Character.valueOf('y'), 50);
        DECODE_MAP.put(Character.valueOf('z'), 51);
        DECODE_MAP.put(Character.valueOf('0'), 52);
        DECODE_MAP.put(Character.valueOf('1'), 53);
        DECODE_MAP.put(Character.valueOf('2'), 54);
        DECODE_MAP.put(Character.valueOf('3'), 55);
        DECODE_MAP.put(Character.valueOf('4'), 56);
        DECODE_MAP.put(Character.valueOf('5'), 57);
        DECODE_MAP.put(Character.valueOf('6'), 58);
        DECODE_MAP.put(Character.valueOf('7'), 59);
        DECODE_MAP.put(Character.valueOf('8'), 60);
        DECODE_MAP.put(Character.valueOf('9'), 61);
        DECODE_MAP.put(Character.valueOf('-'), 62);
        DECODE_MAP.put(Character.valueOf('_'), 63);
        DECODE_MAP.put(Character.valueOf('+'), 62);
        DECODE_MAP.put(Character.valueOf('/'), 63);
        DECODE_MAP.put(Character.valueOf('='), 255);
    }

    public static final String encode(byte[] input, boolean urlSafe) {
        int size;
        int modulus;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < input.length) {
            int i4;
            int i3;
            int i1 = (input[i] & 0xFC) >> 2;
            int i2 = (input[i] & 3) << 4;
            if (i + 1 < input.length) {
                i2 |= (input[i + 1] & 0xF0) >> 4;
                i3 = (input[i + 1] & 0xF) << 2;
            } else {
                i3 = -1;
            }
            if (i + 2 < input.length) {
                i3 |= (input[i + 2] & 0xC0) >> 6;
                i4 = input[i + 2] & 0x3F;
            } else {
                i4 = -1;
            }
            sb.append(urlSafe ? (char)URL_SAFE_ENCODE_TABLE[i1] : (char)STANDARD_ENCODE_TABLE[i1]);
            sb.append(urlSafe ? (char)URL_SAFE_ENCODE_TABLE[i2] : (char)STANDARD_ENCODE_TABLE[i2]);
            if (i3 != -1) {
                sb.append(urlSafe ? (char)URL_SAFE_ENCODE_TABLE[i3] : (char)STANDARD_ENCODE_TABLE[i3]);
            }
            if (i4 != -1) {
                sb.append(urlSafe ? (char)URL_SAFE_ENCODE_TABLE[i4] : (char)STANDARD_ENCODE_TABLE[i4]);
            }
            i += 3;
        }
        if (!urlSafe && (modulus = (size = sb.length()) % 4) != 0) {
            int j = modulus;
            while (j < 4) {
                sb.append('=');
                ++j;
            }
        }
        return sb.toString();
    }

    public static final String encodeUrlUnsafe(byte[] input) {
        return Base64.encode(input, false);
    }

    public static final String encodeUrlSafe(byte[] input) {
        return Base64.encode(input, true);
    }

    public static final byte[] decode(String input) {
        char[] charinput = input.toCharArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < charinput.length) {
            char cd;
            int bytes = 7;
            char ca = charinput[i];
            char cb = charinput[i + 1];
            char cc = i + 2 < charinput.length ? charinput[i + 2] : (char)'=';
            char c = cd = i + 3 < charinput.length ? charinput[i + 3] : (char)'=';
            if (cd == '=') {
                bytes = 3;
            }
            if (cc == '=') {
                bytes = 1;
            }
            int word = 0;
            word |= DECODE_MAP.get(Character.valueOf(ca)).intValue();
            word <<= 6;
            word |= DECODE_MAP.get(Character.valueOf(cb)).intValue();
            word <<= 6;
            word |= DECODE_MAP.get(Character.valueOf(cc)).intValue();
            word <<= 6;
            word |= DECODE_MAP.get(Character.valueOf(cd)).intValue();
            if ((bytes & 1) > 0) {
                baos.write((byte)((word & 0xFF0000) >> 16));
            }
            if ((bytes & 2) > 0) {
                baos.write((byte)((word & 0xFF00) >> 8));
            }
            if ((bytes & 4) > 0) {
                baos.write((byte)(word & 0xFF));
            }
            i += 4;
        }
        return baos.toByteArray();
    }
}

