/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge.signature.rsa;

import cat.aoc.scanner.bridge.signature.rsa.SunMSCApiRSAWrapper;
import java.security.PrivateKey;
import javax.crypto.Cipher;

public class SHA256withRSAHashSigner {
    private static final String SHA_256_ALG_ID = "SHA-256";
    private static final byte[] SHA_256_DER_OID;

    static {
        byte[] byArray = new byte[19];
        byArray[0] = 48;
        byArray[1] = 49;
        byArray[2] = 48;
        byArray[3] = 13;
        byArray[4] = 6;
        byArray[5] = 9;
        byArray[6] = 96;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = 1;
        byArray[10] = 101;
        byArray[11] = 3;
        byArray[12] = 4;
        byArray[13] = 2;
        byArray[14] = 1;
        byArray[15] = 5;
        byArray[17] = 4;
        byArray[18] = 32;
        SHA_256_DER_OID = byArray;
    }

    public static byte[] signSha256Hash(byte[] digestValue, String keyStoreType, PrivateKey privateKey) throws Exception {
        if ("SunMSCAPI".equals(keyStoreType)) {
            return SunMSCApiRSAWrapper.cipher(SHA_256_ALG_ID, digestValue, privateKey);
        }
        if ("PKCS11".equals(keyStoreType)) {
            byte[] derEncodedDigestValue = new byte[51];
            System.arraycopy(SHA_256_DER_OID, 0, derEncodedDigestValue, 0, SHA_256_DER_OID.length);
            System.arraycopy(digestValue, 0, derEncodedDigestValue, 19, digestValue.length);
            Cipher cipher = Cipher.getInstance("RSA", "PKCS11");
            cipher.init(1, privateKey);
            cipher.update(derEncodedDigestValue);
            return cipher.doFinal();
        }
        byte[] derEncodedDigestValue = new byte[51];
        System.arraycopy(SHA_256_DER_OID, 0, derEncodedDigestValue, 0, SHA_256_DER_OID.length);
        System.arraycopy(digestValue, 0, derEncodedDigestValue, 19, digestValue.length);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        cipher.update(derEncodedDigestValue);
        return cipher.doFinal();
    }
}

