/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge;

import cat.aoc.scanner.bridge.service.IScanService;
import cat.aoc.scanner.bridge.service.ScanServiceFactory;
import cat.aoc.scanner.bridge.servlet.ScanServiceWebsocketServlet;
import cat.aoc.scanner.bridge.signature.rsa.KeyStoreService;
import cat.aoc.scanner.bridge.util.ConfigurationUtils;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ScannerBridge {
    private static final byte[] p = new byte[]{99, 104, 97, 110, 103, 101, 105, 116};
    private static final String FLATBED_LITERAL = "Cristall";
    private static final String FEEDER_LITERAL = "Safata";

    public static void main(String[] args) throws Exception {
        ConfigurationUtils.addExplicitScannerDeviceTypes();
        KeyStoreService.getInstance().installCACertificateIfNeeded();
        Server server = new Server();
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        URL r = Thread.currentThread().getContextClassLoader().getResource("resource");
        Resource resource = URLResource.newResource((URL)r);
        sslContextFactory.setKeyStoreResource(resource);
        sslContextFactory.setKeyStorePassword(new String(p));
        sslContextFactory.setKeyManagerPassword(new String(p));
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        sslConnector.setPort(7001);
        server.setConnectors(new Connector[]{sslConnector});
        IScanService scanService = ScanServiceFactory.getInstance();
        ScannerBridge.setupTray(server, scanService);
        ServletContextHandler ctx = new ServletContextHandler();
        ctx.setContextPath("/");
        ctx.addServlet(ScanServiceWebsocketServlet.class, "/ctrl");
        server.setHandler((Handler)ctx);
        server.setStopAtShutdown(true);
        server.start();
        server.join();
        if (SystemTray.isSupported()) {
            TrayIcon[] icons;
            SystemTray tray = SystemTray.getSystemTray();
            TrayIcon[] trayIconArray = icons = tray.getTrayIcons();
            int n = icons.length;
            int n2 = 0;
            while (n2 < n) {
                TrayIcon icon = trayIconArray[n2];
                tray.remove(icon);
                ++n2;
            }
        }
    }

    private static void setupTray(Server server, final IScanService scanService) {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            int width = (int)tray.getTrayIconSize().getWidth();
            BufferedImage image = null;
            try {
                image = ImageIO.read(Thread.currentThread().getContextClassLoader().getResourceAsStream("tray_icon_" + width + ".png"));
                ActionListener iconListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println(String.valueOf(e.getActionCommand()) + " : " + e.getID() + " : " + e.getModifiers());
                    }
                };
                PopupMenu popup = new PopupMenu();
                TrayIcon trayIcon = new TrayIcon(image, "M\u00f2dul de connexi\u00f3 amb el scanner - Consorci AOC", popup);
                trayIcon.addActionListener(iconListener);
                Map<String, Object> dispositius = scanService.getDeviceInfo();
                final MenuItem current = new MenuItem("Cap dispositiu");
                if (scanService.getCurrentlyActiveDevice() != null) {
                    String name = scanService.getCurrentlyActiveDevice().get("name");
                    Object unit = FEEDER_LITERAL;
                    String curr = scanService.getCurrentlyActiveDevice().get("currentUnit");
                    String feed = scanService.getCurrentlyActiveDevice().get("feeder");
                    unit = curr != null && curr.equals(feed) ? FEEDER_LITERAL : FLATBED_LITERAL;
                    current.setLabel(String.valueOf(name) + " - " + (String)unit);
                }
                current.setFont(new Font("Console", 1, 13));
                popup.add(current);
                popup.addSeparator();
                for (String idDispositiu : dispositius.keySet()) {
                    ActionListener dispositiuActionListener;
                    final Map infoDispositiu = (Map)dispositius.get(idDispositiu);
                    MenuItem nouDispositiu = new MenuItem((String)infoDispositiu.get("name"));
                    nouDispositiu.setFont(new Font("Console", 1, 11));
                    popup.add(nouDispositiu);
                    if (!"-1".equals(infoDispositiu.get("feeder"))) {
                        MenuItem alimentador = new MenuItem("     Safata");
                        dispositiuActionListener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                infoDispositiu.put("currentUnit", (String)infoDispositiu.get("feeder"));
                                scanService.setCurrentlyActiveDevice(infoDispositiu);
                                String name = (String)infoDispositiu.get("name");
                                current.setLabel(String.valueOf(name) + " - " + ScannerBridge.FEEDER_LITERAL);
                                System.out.println("Establert el dispositiu '" + name + "' [" + ScannerBridge.FEEDER_LITERAL + "] com a dispositiu d'escaneig actiu");
                            }
                        };
                        alimentador.addActionListener(dispositiuActionListener);
                        popup.add(alimentador);
                    }
                    if (!"-1".equals(infoDispositiu.get("flatbed"))) {
                        MenuItem flatbed = new MenuItem("     Cristall");
                        dispositiuActionListener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                infoDispositiu.put("currentUnit", (String)infoDispositiu.get("flatbed"));
                                scanService.setCurrentlyActiveDevice(infoDispositiu);
                                String name = (String)infoDispositiu.get("name");
                                current.setLabel(String.valueOf(name) + " - " + ScannerBridge.FLATBED_LITERAL);
                                System.out.println("Establert el dispositiu '" + name + "' [" + ScannerBridge.FLATBED_LITERAL + "] com a dispositiu d'escaneig actiu");
                            }
                        };
                        flatbed.addActionListener(dispositiuActionListener);
                        popup.add(flatbed);
                    }
                    popup.addSeparator();
                }
                ActionListener exitActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        System.exit(0);
                    }
                };
                MenuItem exitItem = new MenuItem("Aturar el m\u00f2dul de connexi\u00f3 amb el scanner");
                exitItem.addActionListener(exitActionListener);
                popup.add(exitItem);
                tray.add(trayIcon);
            }
            catch (Exception e) {
                System.out.println("No ha estat possible afegir la icona a la safata del sistema operatiu");
            }
        } else {
            System.out.println("No \ufffds possible afegir la icona a la safata del sistema operatiu");
        }
    }
}

