/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge;

import cat.aoc.scanner.bridge.CommandSender;
import cat.aoc.scanner.bridge.CurrentScanJobHolder;
import cat.aoc.scanner.bridge.SelectedPINStore;
import cat.aoc.scanner.bridge.items.Command;
import cat.aoc.scanner.bridge.items.DeviceInfoCommand;
import cat.aoc.scanner.bridge.items.ScanPageCommand;
import cat.aoc.scanner.bridge.items.SelectCertificateCommand;
import cat.aoc.scanner.bridge.items.SignatureValueCommand;
import cat.aoc.scanner.bridge.items.SigningCertificateSelection;
import cat.aoc.scanner.bridge.items.StopScanCommand;
import cat.aoc.scanner.bridge.items.UnknownCommand;
import cat.aoc.scanner.bridge.service.ScanServiceFactory;
import cat.aoc.scanner.bridge.signature.rsa.KeyStoreService;
import cat.aoc.scanner.bridge.signature.rsa.SHA256withRSAHashSigner;
import cat.aoc.scanner.bridge.util.Base64;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@WebSocket
public class ScanServiceWebsocket {
    private JSONParser p = new JSONParser();

    @OnWebSocketConnect
    public void handleConnect(Session session) {
        String clientId = UUID.randomUUID().toString();
        CommandSender.addWebSocket(clientId, session);
    }

    @OnWebSocketClose
    public void handleClose(int statusCode, String reason) {
        System.out.println("Connection closed with statusCode=" + statusCode + ", reason=" + reason);
    }

    @OnWebSocketMessage
    public void handleMessage(String message) {
        block37: {
            try {
                Command request = Command.buildCommand((Map<String, Object>)((JSONObject)this.p.parse(message)));
                String commandString = request.getCommand();
                String clientId = request.getClientId();
                if ("stopClient".equals(commandString)) {
                    CommandSender.removeWebSocket(clientId);
                    break block37;
                }
                if ("scanDocument".equals(commandString)) {
                    if (!CurrentScanJobHolder.isInProgress()) {
                        try {
                            Long resolution = (Long)request.get("resolution");
                            String format = (String)request.get("format");
                            ScanServiceFactory.getInstance().scanDocument(null, resolution, format, clientId);
                            ScanPageCommand response = new ScanPageCommand(clientId, "success");
                            CommandSender.sendCommand(response);
                        }
                        catch (Exception e) {
                            CommandSender.sendCommand(new ScanPageCommand(clientId, "failure", e.getMessage()));
                        }
                    } else {
                        CommandSender.sendCommand(new ScanPageCommand(clientId, "failure", "Escaneig en curs"));
                    }
                    break block37;
                }
                if ("requestSigningCertificate".equals(commandString)) {
                    try {
                        Map<String, String> certificateAliases = KeyStoreService.getInstance().aliases();
                        SelectCertificateCommand response = new SelectCertificateCommand(clientId, "success", certificateAliases);
                        CommandSender.sendCommand(response);
                    }
                    catch (Exception e) {
                        CommandSender.sendCommand(new SelectCertificateCommand(clientId, "failure", e.getMessage()));
                    }
                    break block37;
                }
                if ("selectSigningCertificate".equals(commandString)) {
                    try {
                        Object aliasId = request.get("aliasId");
                        if (aliasId == null) {
                            throw new Exception("El \ufffdlies \ufffds obligatori");
                        }
                        Certificate[] signingCertificateChain = KeyStoreService.getInstance().getCertificateChainById((String)aliasId);
                        if (signingCertificateChain == null) {
                            throw new Exception("No s'ha pogut recuperar cap certificate per al \ufffdlies sel\ufffdleccionat");
                        }
                        ArrayList<String> signingCertificateChainBytes = new ArrayList<String>();
                        Certificate[] certificateArray = signingCertificateChain;
                        int n = signingCertificateChain.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Certificate certificate = certificateArray[n2];
                            signingCertificateChainBytes.add(Base64.encodeUrlUnsafe(certificate.getEncoded()));
                            ++n2;
                        }
                        SelectedPINStore.getInstance().storeSelectedPINForClientId(clientId, (String)aliasId);
                        SigningCertificateSelection response = new SigningCertificateSelection(clientId, "success", signingCertificateChainBytes);
                        CommandSender.sendCommand(response);
                    }
                    catch (Exception e) {
                        CommandSender.sendCommand(new SigningCertificateSelection(clientId, "failure", e.getMessage()));
                    }
                    break block37;
                }
                if ("signHash".equals(commandString)) {
                    try {
                        String aliasId = SelectedPINStore.getInstance().retrieveSelectedPINForClientId(clientId);
                        Object digestValueB64 = request.get("digestValue");
                        if (aliasId == null) {
                            throw new Exception("El aliasId \ufffds obligatori");
                        }
                        if (digestValueB64 == null) {
                            throw new Exception("El digestValue \ufffds obligatori");
                        }
                        byte[] digestValue = Base64.decode((String)digestValueB64);
                        KeyStoreService keyStoreService = KeyStoreService.getInstance();
                        Key privateKey = keyStoreService.getPrivateKeyById(aliasId, "2007");
                        byte[] signatureValue = null;
                        try {
                            signatureValue = SHA256withRSAHashSigner.signSha256Hash(digestValue, keyStoreService.getKeyStoreType(), (PrivateKey)privateKey);
                        }
                        catch (Exception se) {
                            KeyStoreService.getInstance().reload();
                            try {
                                privateKey = keyStoreService.getPrivateKeyById(aliasId, "2007");
                                signatureValue = SHA256withRSAHashSigner.signSha256Hash(digestValue, keyStoreService.getKeyStoreType(), (PrivateKey)privateKey);
                            }
                            catch (Exception e) {
                                throw new Exception("No s'ha pogut realitzar la signatura al dispositiu criptogr\ufffdfic");
                            }
                        }
                        SignatureValueCommand response = new SignatureValueCommand(clientId, "success", signatureValue);
                        CommandSender.sendCommand(response);
                    }
                    catch (Exception e) {
                        CommandSender.sendCommand(new SignatureValueCommand(clientId, "failure", e.getMessage()));
                    }
                    break block37;
                }
                if ("scanDocumentStop".equals(commandString)) {
                    try {
                        if (CurrentScanJobHolder.isInProgress()) {
                            try {
                                ScanServiceFactory.getInstance().stopScanDocument();
                                StopScanCommand response = new StopScanCommand(clientId, "success", "Escaneig finalitzat pel usuari");
                                CommandSender.sendCommand(response);
                            }
                            catch (Exception e) {
                                CommandSender.sendCommand(new StopScanCommand(clientId, "failure", e.getMessage()));
                            }
                            break block37;
                        }
                        CommandSender.sendCommand(new StopScanCommand(clientId, "failure", "No hi ha cap escaneig en curs"));
                    }
                    catch (Exception e) {
                        CommandSender.sendCommand(new StopScanCommand(clientId, "failure", e.getMessage()));
                    }
                    break block37;
                }
                if ("requestDeviceInfo".equals(commandString)) {
                    try {
                        DeviceInfoCommand response = new DeviceInfoCommand(clientId, "success");
                        Map<String, Object> deviceInfo = ScanServiceFactory.getInstance().getDeviceInfo();
                        if (deviceInfo == null) {
                            throw new Exception("No s'ha detectat cap dispositiu");
                        }
                        response.setDeviceInfo(deviceInfo);
                        CommandSender.sendCommand(response);
                    }
                    catch (Exception e) {
                        CommandSender.sendCommand(new DeviceInfoCommand(clientId, "failure", e.getMessage()));
                    }
                } else {
                    UnknownCommand response = new UnknownCommand(clientId);
                    CommandSender.sendCommand(response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @OnWebSocketMessage
    public void handleMessage(InputStream is) {
    }

    @OnWebSocketError
    public void handleError(Throwable error) {
        error.printStackTrace();
    }
}

