/*
 * Decompiled with CFR 0.152.
 */
package cat.aoc.scanner.bridge;

import cat.aoc.scanner.bridge.items.Command;
import cat.aoc.scanner.bridge.thread.CommandSenderAgent;
import org.eclipse.jetty.websocket.api.Session;

public class CommandSender {
    private static final CommandSenderAgent senderAgent;

    static {
        CommandSenderAgent agent = new CommandSenderAgent();
        agent.start();
        senderAgent = agent;
    }

    public static synchronized void sendCommand(Command command) {
        if (senderAgent != null) {
            senderAgent.sendCommand(command);
        }
    }

    public static void addWebSocket(String clientId, Session session) {
        if (senderAgent != null) {
            senderAgent.addWebSocket(clientId, session);
        }
    }

    public static void removeWebSocket(String clientId) {
        if (senderAgent != null) {
            senderAgent.removeWebSocket(clientId);
        }
    }
}

