/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena;

import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceUIDialog;
import eu.gnome.morena.Manager;
import eu.gnome.morena.TransferDoneListener;
import java.io.File;
import java.lang.reflect.Method;

public class DeviceBase
implements Device {
    protected static final String IMAGE_DIR = new File(TMP_DIR, "morena_images").getAbsolutePath();
    protected static String FILE_NAME = "morena_img";
    protected long handle;
    protected String description;
    protected TransferDoneListener transferDoneListener;
    protected int functionalUnit;
    protected String fileName;

    protected DeviceBase(String string, long l) {
        this.description = string;
        this.handle = l;
        this.functionalUnit = 0;
        this.fileName = FILE_NAME;
    }

    protected void fireTransferDone(String string) {
        try {
            File file = new File(string);
            Manager.debug("* file transfered -> " + string);
            this.transferDoneListener.transferDone(file);
            if (file.exists()) {
                Configuration.DELETE_POLICY dELETE_POLICY = Configuration.getDeletePolicy();
                if (dELETE_POLICY == Configuration.DELETE_POLICY.DELETE_ON_EXIT) {
                    file.deleteOnExit();
                } else if (dELETE_POLICY == Configuration.DELETE_POLICY.DELETE) {
                    file.delete();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void fireTransferFailed(int n, String string) {
        try {
            Manager.debug(n == 0 ? "* feeder empty" : "* transfer failed - " + string);
            this.transferDoneListener.transferFailed(n, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean setupDevice(Object object) {
        if ((Configuration.getMode() & 1) > 0) {
            return true;
        }
        DeviceUIDialog deviceUIDialog = null;
        try {
            Class<? extends DeviceUIDialog> clazz = Configuration.getScannerUIClass();
            if (clazz != null) {
                Method method = clazz.getMethod("createDeviceUI", Object.class, Device.class);
                deviceUIDialog = (DeviceUIDialog)method.invoke(null, object, this);
            }
        }
        catch (Throwable throwable) {
            StackTraceElement[] stackTraceElementArray;
            StringBuilder stringBuilder = new StringBuilder(1024);
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                stringBuilder.append(stackTraceElement.toString()).append("\n\t\t");
            }
            Manager.error("ERROR: Device dialog cannot be created : \n" + throwable + "\n\t\t" + stringBuilder);
        }
        if (deviceUIDialog != null) {
            boolean bl = deviceUIDialog.display();
            deviceUIDialog.dispose();
            return bl;
        }
        return true;
    }

    public void startTransfer(TransferDoneListener transferDoneListener) throws Exception {
        this.startTransfer(transferDoneListener, this.functionalUnit);
    }

    public void startTransfer() throws Exception {
        if (this.transferDoneListener == null) {
            throw new Exception("No previous call of startTransfer(): parameters not available");
        }
        this.startTransfer(this.transferDoneListener, this.functionalUnit);
    }

    public void startTransfer(TransferDoneListener transferDoneListener, int n) throws Exception {
        this.transferDoneListener = transferDoneListener;
        this.functionalUnit = n;
    }

    public int getFunctionalUnit() {
        return this.functionalUnit;
    }

    public void setFunctionalUnit(int n) {
        this.functionalUnit = n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String toString() {
        return this.description;
    }

    static {
        new File(IMAGE_DIR).mkdirs();
    }
}

