/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceBase;
import eu.gnome.morena.TransferDoneListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SynchronousHelper {
    public static final int WIA_ERROR_PAPER_EMPTY = 417;

    public static BufferedImage scanImage(Device device) throws Exception {
        return SynchronousHelper.scanImage(device, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scanImage(Device device, int n) throws Exception {
        ImageTransferHandler imageTransferHandler;
        ImageTransferHandler imageTransferHandler2 = imageTransferHandler = new ImageTransferHandler();
        synchronized (imageTransferHandler2) {
            ((DeviceBase)device).startTransfer(imageTransferHandler, n);
            while (!imageTransferHandler.transferDone) {
                imageTransferHandler.wait();
            }
        }
        if (imageTransferHandler.image != null) {
            return imageTransferHandler.image;
        }
        throw new Exception(imageTransferHandler.error);
    }

    public static File scanFile(Device device) throws Exception {
        return SynchronousHelper.scanFile(device, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File scanFile(Device device, int n) throws Exception {
        FileTransferHandler fileTransferHandler;
        FileTransferHandler fileTransferHandler2 = fileTransferHandler = new FileTransferHandler();
        synchronized (fileTransferHandler2) {
            ((DeviceBase)device).startTransfer(fileTransferHandler, n);
            while (!fileTransferHandler.transferDone) {
                fileTransferHandler.wait();
            }
        }
        if (fileTransferHandler.imageFile != null) {
            return fileTransferHandler.imageFile;
        }
        throw new Exception(fileTransferHandler.error);
    }

    static class FileTransferHandler
    implements TransferDoneListener {
        File imageFile;
        int code;
        String error;
        boolean transferDone = false;

        FileTransferHandler() {
        }

        public void transferDone(File file) {
            this.imageFile = file;
            this.notifyRequestor();
        }

        public void transferFailed(int n, String string) {
            this.code = n;
            this.error = string;
            this.notifyRequestor();
        }

        private synchronized void notifyRequestor() {
            this.transferDone = true;
            this.notify();
        }
    }

    static class ImageTransferHandler
    implements TransferDoneListener {
        BufferedImage image;
        int code;
        String error;
        boolean transferDone = false;

        ImageTransferHandler() {
        }

        public void transferDone(File file) {
            if (file != null) {
                try {
                    this.image = ImageIO.read(file);
                }
                catch (IOException iOException) {
                    this.error = iOException.getLocalizedMessage();
                }
            }
            this.notifyRequestor();
        }

        public void transferFailed(int n, String string) {
            this.code = n;
            this.error = string;
            this.notifyRequestor();
        }

        private synchronized void notifyRequestor() {
            this.transferDone = true;
            this.notify();
        }
    }
}

