/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceBase;
import eu.gnome.morena.TransferListener;
import eu.gnome.morena.wia.WIAScanner;
import java.io.File;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ScanSession {
    MultiFileTransferHandler th;
    private LinkedBlockingQueue<String> queue;
    boolean transferFinished = false;
    private AtomicInteger blockedThreadCount;
    public static final String EOP = "";

    public void startSession(Device device, int n) throws Exception {
        this.startSession(device, n, 0);
    }

    public void startSession(Device device, int n, int n2) throws Exception {
        this.queue = new LinkedBlockingQueue();
        this.blockedThreadCount = new AtomicInteger(0);
        this.transferFinished = false;
        if (n2 != 0 && device instanceof WIAScanner) {
            ((WIAScanner)device).setPgcount(n2);
        }
        this.th = new MultiFileTransferHandler(n2);
        device.setFileName("mi_" + System.currentTimeMillis());
        ((DeviceBase)device).startTransfer(this.th, n);
    }

    public File getImageFile() {
        String string = this.queue.poll();
        if (string == null && !this.transferFinished) {
            try {
                this.blockedThreadCount.incrementAndGet();
                string = this.queue.take();
                this.blockedThreadCount.decrementAndGet();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (string.isEmpty()) {
            this.releaseBlockedThreads();
        }
        return string == null || string.isEmpty() ? null : new File(string);
    }

    public boolean isEmptyFeeder() {
        return this.th != null ? this.th.code == 0 : false;
    }

    public int getErrorCode() {
        return this.th.code;
    }

    public String getErrorMessage() {
        return this.th.error;
    }

    private void releaseBlockedThreads() {
        int n = this.blockedThreadCount.getAndSet(0);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                try {
                    this.queue.put(EOP);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public static String getExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0 && n + 1 < string.length()) {
            return string.substring(n + 1);
        }
        return EOP;
    }

    class MultiFileTransferHandler
    implements TransferListener {
        int code;
        String error;
        int pages;
        AtomicInteger pcounter;

        public MultiFileTransferHandler(int n) {
            this.pages = n;
            this.pcounter = new AtomicInteger(0);
            this.code = -1;
            this.error = "No error";
        }

        public void transferDone(File file) {
            try {
                ScanSession.this.queue.put(file.getAbsolutePath());
                if (this.pcounter.incrementAndGet() == this.pages) {
                    ScanSession.this.queue.put(ScanSession.EOP);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        public void transferProgress(int n) {
            System.err.println("transfer " + n + "%");
        }

        public void transferFailed(int n, String string) {
            this.code = n;
            this.error = string;
            ScanSession.this.transferFinished = true;
            try {
                ScanSession.this.queue.put(ScanSession.EOP);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

