/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceListChangeListener;
import eu.gnome.morena.Manager;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferListener;
import eu.gnome.morena.wia.WIAScanner;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class MorenaStudioFX7
extends Application {
    HBox imageBox;
    Button removeButton;
    Button acquireButton;
    Button saveButton;
    Button uploadButton;
    CheckBox displayUICheckBox;
    CheckBox adfScan;
    CheckBox duplexScan;
    CheckBox transferProgres;
    ComboBox<Device> deviceComboBox;
    BorderPane statusPane;
    Label status;
    Button cancelButton;
    ProgressBar pbar;
    HBox progressBox;
    DeviceListListener deviceListListener;
    List<Device> liveDevices;
    ObservableList<Device> boundDevices;
    Scanner scanningDevice;
    private Manager manager;
    EventHandler<Event> deviceSelecting = new EventHandler<Event>(){

        public void handle(Event event) {
            System.out.println("Selecting device");
            if ((Configuration.getMode() & 1) == 1) {
                System.out.println("List devices");
                MorenaStudioFX7.this.liveDevices = MorenaStudioFX7.this.manager.listDevices();
            }
        }
    };
    EventHandler<ActionEvent> deviceSelected = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Device device = (Device)MorenaStudioFX7.this.deviceComboBox.getValue();
            if (device instanceof WIAScanner) {
                WIAScanner ws = (WIAScanner)device;
                System.out.println("selected device: " + ws.toString() + " | cap=" + String.format("%02X ", ws.getHandlingCapab()) + " sel=" + String.format("%03X ", ws.getHandlingSelect()));
            }
            if (device != null && device instanceof Scanner) {
                MorenaStudioFX7.this.adfScan.setDisable(((Scanner)device).getFeederFunctionalUnit() < 0);
                MorenaStudioFX7.this.duplexScan.setDisable(!((Scanner)device).isDuplexSupported());
            } else {
                MorenaStudioFX7.this.adfScan.setDisable(true);
                MorenaStudioFX7.this.duplexScan.setDisable(true);
            }
        }
    };
    EventHandler<ActionEvent> removeEvent = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            System.out.println("remove event");
            MorenaStudioFX7.this.imageBox.getChildren().clear();
        }
    };
    EventHandler<ActionEvent> acquireEvent = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            System.out.println("acquire event");
            try {
                MorenaStudioFX7.this.status.setText("Working ...");
                boolean displayUI = MorenaStudioFX7.this.displayUICheckBox.isSelected();
                Device device = (Device)MorenaStudioFX7.this.deviceComboBox.getValue();
                if (device != null) {
                    if (device instanceof Scanner) {
                        int funit;
                        Scanner scanner = (Scanner)device;
                        if (!displayUI) {
                            MorenaStudioFX7.this.enableProgressBar();
                            MorenaStudioFX7.this.scanningDevice = scanner;
                        }
                        int n = funit = MorenaStudioFX7.this.adfScan.isSelected() ? scanner.getFeederFunctionalUnit() : scanner.getFlatbedFunctionalUnit();
                        if (scanner.isDuplexSupported() && MorenaStudioFX7.this.duplexScan.isSelected()) {
                            scanner.setDuplexEnabled(true);
                        } else {
                            scanner.setDuplexEnabled(false);
                        }
                        if (funit < 0) {
                            System.out.println("functional unit type not reported by WIA");
                            funit = 0;
                        }
                        scanner.setMode(8);
                        scanner.setResolution(75);
                        scanner.startTransfer(new FileTransferHandler(), funit);
                    } else {
                        device.startTransfer(new FileTransferHandler());
                    }
                    MorenaStudioFX7.this.status.setText("Selected " + device + " transfering ...");
                } else {
                    MorenaStudioFX7.this.status.setText("No device selected, please select one!");
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
                MorenaStudioFX7.this.status.setText("Failed, try again ...");
            }
        }
    };
    EventHandler<ActionEvent> saveEvent = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
        }
    };
    EventHandler<ActionEvent> uploadEvent = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
        }
    };
    EventHandler<ActionEvent> cancelEvent = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            MorenaStudioFX7.this.scanningDevice.cancelTransfer();
        }
    };

    public static void main(String[] args) {
        System.out.println("MorenaStudioFX7 v1.0.2 started at " + new Date());
        MorenaStudioFX7.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        Configuration.addDeviceType(".*fficejet.*", true);
        Configuration.setMode(1);
        this.manager = Manager.getInstance();
        this.liveDevices = this.manager.listDevices();
        this.deviceListListener = new DeviceListListener();
        this.manager.addDeviceListChangeListener(this.deviceListListener);
        this.boundDevices = FXCollections.observableList(new Vector<Device>(this.liveDevices));
        primaryStage.setTitle("Morena StudioFX");
        StackPane root = new StackPane();
        Text sceneTitle = new Text("Morena Studio 7");
        sceneTitle.setId("welcome-text");
        Image cancelIcon = new Image(MorenaStudioFX7.class.getResourceAsStream("/resource/cancel.png"));
        this.deviceComboBox = new ComboBox();
        this.deviceComboBox.setPrefWidth(200.0);
        this.deviceComboBox.setPromptText("Select device");
        BorderPane appletView = new BorderPane();
        ToolBar toolbar = new ToolBar();
        this.acquireButton = new Button("acquire image");
        toolbar.getItems().add((Object)this.acquireButton);
        this.removeButton = new Button("remove all");
        toolbar.getItems().add((Object)this.removeButton);
        this.saveButton = new Button("save to file");
        this.uploadButton = new Button("upload to server");
        toolbar.getItems().add((Object)new Separator());
        toolbar.getItems().add((Object)new Label("        Device:"));
        toolbar.getItems().add(this.deviceComboBox);
        this.displayUICheckBox = new CheckBox("display UI");
        toolbar.getItems().add((Object)this.displayUICheckBox);
        this.adfScan = new CheckBox("ADF scan");
        toolbar.getItems().add((Object)this.adfScan);
        this.duplexScan = new CheckBox("Duplex");
        toolbar.getItems().add((Object)this.duplexScan);
        this.deviceComboBox.setItems(this.boundDevices);
        this.deviceComboBox.setOnAction(this.deviceSelected);
        this.deviceComboBox.setOnShowing(this.deviceSelecting);
        this.adfScan.setDisable(true);
        this.duplexScan.setDisable(true);
        this.removeButton.setOnAction(this.removeEvent);
        this.acquireButton.setOnAction(this.acquireEvent);
        this.saveButton.setOnAction(this.saveEvent);
        this.uploadButton.setOnAction(this.uploadEvent);
        this.saveButton.setDisable(true);
        this.uploadButton.setDisable(true);
        ScrollPane scrollPane = new ScrollPane();
        this.imageBox = new HBox();
        this.imageBox.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                System.out.println("list changed " + c);
                if (MorenaStudioFX7.this.imageBox.getChildren().size() > 0) {
                    MorenaStudioFX7.this.saveButton.setDisable(false);
                    MorenaStudioFX7.this.uploadButton.setDisable(false);
                } else {
                    MorenaStudioFX7.this.saveButton.setDisable(true);
                    MorenaStudioFX7.this.uploadButton.setDisable(true);
                }
            }
        });
        scrollPane.setContent((Node)this.imageBox);
        this.statusPane = new BorderPane();
        this.status = new Label("status");
        this.status.setAlignment(Pos.CENTER);
        this.pbar = new ProgressBar();
        ImageView cancelView = new ImageView(cancelIcon);
        this.cancelButton = new Button();
        this.cancelButton.setGraphic((Node)cancelView);
        this.cancelButton.setId("cancelButton");
        this.cancelButton.setMinSize(cancelIcon.getWidth() + 2.0, cancelIcon.getHeight() + 2.0);
        this.cancelButton.setPrefSize(cancelIcon.getWidth() + 2.0, cancelIcon.getHeight() + 2.0);
        this.cancelButton.setMaxSize(cancelIcon.getWidth() + 2.0, cancelIcon.getHeight() + 2.0);
        System.out.println(String.valueOf(this.cancelButton.getMaxHeight()) + ", " + this.cancelButton.getMaxWidth());
        this.cancelButton.setOnAction(this.cancelEvent);
        this.progressBox = new HBox();
        this.progressBox.getChildren().add((Object)this.cancelButton);
        this.progressBox.getChildren().add((Object)this.pbar);
        this.progressBox.setAlignment(Pos.CENTER);
        this.progressBox.setSpacing(5.0);
        this.statusPane.setLeft((Node)this.status);
        this.statusPane.setRight((Node)this.progressBox);
        BorderPane.setAlignment((Node)this.status, (Pos)Pos.CENTER_LEFT);
        BorderPane.setMargin((Node)this.status, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        BorderPane.setAlignment((Node)this.progressBox, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.progressBox, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.statusPane.setLeft((Node)this.status);
        this.statusPane.setId("status-bar");
        this.statusPane.setMinHeight(22.0);
        this.statusPane.setPrefHeight(22.0);
        this.statusPane.setMaxHeight(22.0);
        this.disableProgressBar();
        appletView.setTop((Node)toolbar);
        appletView.setCenter((Node)scrollPane);
        appletView.setBottom((Node)this.statusPane);
        BorderPane.setMargin((Node)this.statusPane, (Insets)new Insets(1.0, 0.0, 0.0, 0.0));
        root.setAlignment(Pos.TOP_CENTER);
        StackPane.setMargin((Node)appletView, (Insets)new Insets(30.0, 15.0, 30.0, 15.0));
        root.getChildren().add((Object)sceneTitle);
        root.getChildren().add((Object)appletView);
        Scene scene = new Scene((Parent)root, 1200.0, 720.0);
        primaryStage.setScene(scene);
        URL css = MorenaStudioFX7.class.getResource("/resource/MorenaStudioFX7.css");
        scene.getStylesheets().add((Object)css.toExternalForm());
        primaryStage.show();
    }

    public void stop() throws Exception {
        try {
            this.manager.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void disableProgressBar() {
        this.cancelButton.setDisable(true);
        this.pbar.setDisable(true);
        this.pbar.setProgress(0.0);
    }

    private void enableProgressBar() {
        this.cancelButton.setDisable(false);
        this.pbar.setDisable(false);
    }

    class DeviceListListener
    implements DeviceListChangeListener {
        Vector<Device> devAdded;
        Vector<Device> devRemoved;

        DeviceListListener() {
        }

        @Override
        public void listChanged() {
        }

        @Override
        public void deviceConnected(Device device) {
            MorenaStudioFX7.this.boundDevices.add((Object)device);
            MorenaStudioFX7.this.status.setText("device added : " + device);
        }

        @Override
        public void deviceDisconnected(Device device) {
            MorenaStudioFX7.this.boundDevices.remove((Object)device);
            MorenaStudioFX7.this.status.setText("device removed " + device);
        }
    }

    class FileTransferHandler
    implements TransferListener {
        File imageFile;
        String message;
        boolean transferDone = false;

        FileTransferHandler() {
        }

        @Override
        public void transferDone(File file) {
            this.imageFile = file;
            System.out.println("image file:" + this.imageFile.getAbsolutePath());
            if (!MorenaStudioFX7.this.adfScan.isSelected()) {
                this.transferDone = true;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((FileTransferHandler)FileTransferHandler.this).MorenaStudioFX7.this.imageBox.getChildren().add((Object)new ImageView("file:" + FileTransferHandler.this.imageFile.getAbsolutePath()));
                    if (FileTransferHandler.this.transferDone) {
                        MorenaStudioFX7.this.disableProgressBar();
                        ((FileTransferHandler)FileTransferHandler.this).MorenaStudioFX7.this.status.setText("Transfer done");
                        FileTransferHandler.this.transferDone = false;
                    }
                }
            });
        }

        @Override
        public void transferFailed(int code, String error) {
            this.message = code == 0 ? "Feeder empty" : "Scan error (" + code + ") " + error;
            System.out.println(this.message);
            this.transferDone = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MorenaStudioFX7.this.disableProgressBar();
                    ((FileTransferHandler)FileTransferHandler.this).MorenaStudioFX7.this.status.setText(FileTransferHandler.this.message);
                }
            });
        }

        @Override
        public void transferProgress(int percent) {
            MorenaStudioFX7.this.pbar.setProgress((double)percent / 100.0);
            System.out.println("transfer progress " + percent);
        }
    }
}

