package utils;

import java.io.BufferedWriter;

import com.safelayer.trustedx.client.smartwrapper.SmartChain;
import com.safelayer.trustedx.client.smartwrapper.SmartCrl;
import com.safelayer.trustedx.client.smartwrapper.SmartDecryptResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartEncryptResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartOcsp;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartSignatureResult;
import com.safelayer.trustedx.client.smartwrapper.SmartStamp;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class UtilTrustedX {
	private static final String RMAJOR_SUCCESS = "urn:oasis:names:tc:dss:1.0:resultmajor:Success";
	private static final String RMINOR_SUCCESS = "urn:oasis:names:tc:dss:1.0:resultminor:ValidSignature_OnAllDocuments";

	// Check if the request was success and print of the SOAP results
	// (SmartWrapper)
	
	public static boolean checkSW(String major, String minor, String message) throws Exception {
		boolean rmajor = major.equals(RMAJOR_SUCCESS);
		if (rmajor && ((minor == null) || (minor.equals(RMINOR_SUCCESS)))) {
			return true;
		} else {
			System.out.println("Major: " + major);
			System.out.println("Minor: " + minor);
			if(message != null){
				System.out.println("Message: " + message);
			}
			return false;
		}
	}
	
	public static boolean checkSW(String major, String minor, String message, BufferedWriter out) throws Exception {
		boolean rmajor = major.equals(RMAJOR_SUCCESS);
		if (rmajor && ((minor == null) || (minor.equals(RMINOR_SUCCESS)))) {
			return true;
		} else {
			out.write("** RESULTAT **\n");
			out.write("---------------------\n");
			out.write("Major: " + major+ "\n");
			out.write("Minor: " + minor+ "\n");
			System.out.println("Major: " + major);
			System.out.println("Minor: " + minor);
			if(message != null){
				System.out.println("Message: " + message);
				out.write("Message: " + message+ "\n");
			}
			return false;
		}
	}

	// Prints the Information from a SmartResponse (SmartWrapper)
	public static void printResponse(SmartVerifyResponse svr, BufferedWriter out) throws Exception {
		System.out.println("** RESPOSTA DE LA VALIDACI **");
		System.out.println("------------------------");
		out.write("** RESPOSTA DE LA VALIDACI **\n");
		out.write("-----------------------\n");
		for (int sig = 0; sig < svr.getNumberSignatures(); sig++) {
			System.out.println("Signature num " + sig);
			System.out.println("---------------------");
			out.write("Signature num " + sig+ "\n");
			out.write("---------------------\n");
			SmartSignatureResult signat = svr.getSignature(sig);
			printCert(signat,out);

			// Print of Signature Credentials Information
			for (int crlv = 0; crlv < signat.getNumberCrls(); crlv++) {
				SmartCrl crl = signat.getCrl(crlv);
				printCRL(crl,out);
			}
			for (int ocspv = 0; ocspv < signat.getNumberOcsp(); ocspv++) {
				SmartOcsp ocsp = signat.getOcsp(ocspv);
				printOCSP(ocsp,out);
			}
			for (int tstamp = 0; tstamp < signat.getNumberTimeStamps(); tstamp++) {
				SmartStamp stamp = signat.getStamp(tstamp);
				printTimestamp(stamp,out);
			}
			for (int atstamp = 0; atstamp < signat.getArchiveNumberTimeStamps(); atstamp++) {
				SmartStamp stamp = signat.getArchiveStamp(atstamp);
				printArchiveTimestamp(stamp,out);
			}

			System.out.println("---------------------");
			out.write("---------------------\n");
		}
		System.out.println("---------------------");
		out.write("---------------------\n");
	}
	
	// Prints the Information from a SmartResponse (SmartWrapper)
	public static void printResponse(SmartSignResponse ssr, BufferedWriter out) throws Exception {
		System.out.println("** RESPOSTA DE LA VALIDACI **");
		System.out.println("---------------------");
		System.out.println("Major: " + ssr.getResultMajor());
		System.out.println("Minor: " + ssr.getResultMinor());
		out.write("** RESPOSTA DE LA VALIDACI **\n");
		out.write("---------------------\n");
		out.write("Major: " + ssr.getResultMajor()+ "\n");
		out.write("Minor: " + ssr.getResultMinor()+ "\n");
		if(ssr.getResultMessage() != null){
			System.out.println("Message: " + ssr.getResultMessage());
			out.write("Message: " + ssr.getResultMessage() +"\n");
		}
		System.out.println("Profile: " + ssr.getProfile());
		System.out.println("TimeStamp: " + ssr.getTimeStamp());
		System.out.println("** SIGNATURE **");
		System.out.println("---------------------");
		out.write("Profile: " + ssr.getProfile()+ "\n");
		out.write("TimeStamp: " + ssr.getTimeStamp()+ "\n");
		out.write("---------------------\n");
		out.write("** SIGNATURA **\n");
		out.write("---------------------\n");
		if(ssr.getDocumentWithSignaturePdf() != null){
			System.out.println("Signature: " + ssr.getDocumentWithSignaturePdf());
			out.write("Signature: " + ssr.getDocumentWithSignaturePdf() +"\n");
		}
		if(ssr.getDocumentWithSignatureXml() != null){
			System.out.println("Signature: " + ssr.getDocumentWithSignatureXml());
			out.write("Signature: " + ssr.getDocumentWithSignatureXml() +"\n");
		}
		if(ssr.getDocumentWithSignatureXmlBase64() != null){
			System.out.println("Signature: " + ssr.getDocumentWithSignatureXmlBase64());
			out.write("Signature: " + ssr.getDocumentWithSignatureXmlBase64() +"\n");
		}
		if(ssr.getSignatureBase64() != null) {
			System.out.println("Signature: " + ssr.getSignatureBase64());
			System.out.println("Type: " + ssr.getSignatureBase64Type());
			out.write("Signature: " + ssr.getSignatureBase64() +"\n");
			out.write("Type: " + ssr.getSignatureBase64Type() +"\n");
		}
		if(ssr.getSignatureMime() != null){
			System.out.println("Signature: " + ssr.getSignatureMime());
			System.out.println("Type: " + ssr.getSignatureMimeType());
			out.write("Signature: " + ssr.getSignatureMime() +"\n");
			out.write("Type: " + ssr.getSignatureMimeType() +"\n");
		}
		if(ssr.getSignatureXml() != null){
			System.out.println("Signature: " + ssr.getSignatureXml());
			out.write("Signature: " + ssr.getSignatureXml() +"\n");
		}
		if(ssr.getSignatureXmlBase64() != null){
			System.out.println("Signature: " + ssr.getSignatureXmlBase64());
			out.write("Signature: " + ssr.getSignatureXmlBase64() +"\n");
		}
		System.out.println("---------------------");
		out.write("---------------------\n");
	}
	
	//Prints the Information of a SmartResponse (DE)
	public static void printResponse(SmartDecryptResponse sdr, BufferedWriter out) throws Exception {
		System.out.println("** RESPOSTA DEL DESXIFRAT **");
		System.out.println("---------------------");
		System.out.println("Major: " + sdr.getResultMajor());
		System.out.println("Minor: " + sdr.getResultMinor());
		out.write("** RESPOSTA DEL DESXIFRAT **\n");
		out.write("---------------------\n");
		out.write("Major: " + sdr.getResultMajor() +"\n");
		out.write("Minor: " + sdr.getResultMinor() +"\n");
		
		if(sdr.getResultMessage() != null){
			System.out.println("Message: " + sdr.getResultMessage());
			out.write("Message: " + sdr.getResultMessage() +"\n");
		}
		if(sdr.getDocumentMime() != null){
			System.out.println("Document: " + sdr.getDocumentMime());
			out.write("Document: " + sdr.getDocumentMime() +"\n");
		}
		if(sdr.getDocumentXmlBase64() != null){
			System.out.println("Document: " + sdr.getDocumentXmlBase64());
			out.write("Document: " + sdr.getDocumentXmlBase64() +"\n");
		}
		if(sdr.getDocumentXmlData() != null){
			System.out.println("Document: " + sdr.getDocumentXmlData());
			out.write("Document: " + sdr.getDocumentXmlData() +"\n");
		}
	}
	
	// Prints the Information of a SmartResponse (DE)
	public static void printResponse(SmartEncryptResponse ser, BufferedWriter out) throws Exception {
		System.out.println("** RESPOSTA DEL XIFRAT **");
		System.out.println("---------------------");
		System.out.println("Major: " + ser.getResultMajor());
		System.out.println("Minor: " + ser.getResultMinor());
		out.write("** RESPOSTA DEL XIFRAT **\n");
		out.write("---------------------\n");
		out.write("Major: " + ser.getResultMajor() +"\n");
		out.write("Minor: " + ser.getResultMinor() +"\n\n");
		if(ser.getResultMessage() != null){
			System.out.println("Message: " + ser.getResultMessage());
			out.write("Message: " + ser.getResultMessage() +"\n");
		}

		if(ser.getEnvelopeBase64()!= null){
			System.out.println("Encrypted data: " + ser.getEnvelopeBase64());
			System.out.println("Type: " + ser.getEnvelopeBase64Type());
			out.write("Encrypted data: " + ser.getEnvelopeBase64() +"\n");
			out.write("Type: " + ser.getEnvelopeBase64Type() +"\n");
		}
		if(ser.getEnvelopeMime() != null){
			System.out.println("Encrypted data: " + ser.getEnvelopeMime());
			System.out.println("Type: " + ser.getEnvelopeMimeType());
			out.write("Encrypted data: " + ser.getEnvelopeMime() +"\n");
			out.write("Type: " + ser.getEnvelopeMimeType() +"\n");
		}
		if(ser.getEnvelopeXmlBase64() != null){
			System.out.println("Encrypted data: " + ser.getEnvelopeXmlBase64());
			out.write("Encrypted data: " + ser.getEnvelopeXmlBase64() +"\n");
		}
		if(ser.getEnvelopeXmlData()!= null){
			System.out.println("Encrypted data: " + ser.getEnvelopeXmlData());
			out.write("Encrypted data: " + ser.getEnvelopeXmlData() +"\n");
		}
		
	}

	// Print of Certificate Information
	private static void printCert(SmartSignatureResult ssr, BufferedWriter out) throws Exception {
		System.out.println("** CERTIFICAT **");
		System.out.println("Major: " + ssr.getResultMajor());
		System.out.println("Minor: " + ssr.getResultMinor());
		out.write("** CERTIFICAT **\n");
		out.write("Major: " + ssr.getResultMajor() +"\n");
		out.write("Minor: " + ssr.getResultMinor() +"\n");
		if(ssr.getResultMessage() != null){
			System.out.println("Message: " + ssr.getResultMessage());
			out.write("Message: " + ssr.getResultMessage() +"\n");
		}
		System.out.println("DN: " + ssr.getSignerIdentity());
		System.out.println("Issuer Trust Level: "
				+ ssr.getSignerIssuerTrustLevel());
		System.out.println("Issuer Trust Label: "
				+ ssr.getSignerIssuerTrustLabel());
		out.write("DN: " + ssr.getSignerIdentity() +"\n");
		out.write("Issuer Trust Level: "
				+ ssr.getSignerIssuerTrustLevel() +"\n");
		out.write("Issuer Trust Label: "
				+ ssr.getSignerIssuerTrustLabel() +"\n");
		if(ssr.getSignerCertificateXml() != null){
			System.out.println("XML Cert: " + ssr.getSignerCertificateXml());
			out.write("XML Cert: " + ssr.getSignerCertificateXml() +"\n");
		}
		if(ssr.getSigningAdditionalInfo() != null){
			System.out.println("Additional Info: " + ssr.getSigningAdditionalInfo());
			out.write("Additional Info: " + ssr.getSigningAdditionalInfo() +"\n");
		}
	}

	// Print of CRL Information
	private static void printCRL(SmartCrl sc, BufferedWriter out) throws Exception {
		System.out.println("** CRL **");
		System.out.println("Trust Level: " + sc.getTrustLevel());
		System.out.println("Trust Label: " + sc.getTrustLabel());
		System.out.println("XML CRL: " + sc.getCrlXml());
		out.write("** CRL **\n");
		out.write("Trust Level: " + sc.getTrustLevel() +"\n");
		out.write("Trust Label: " + sc.getTrustLabel() +"\n");
		out.write("XML CRL: " + sc.getCrlXml() +"\n");
	}

	// Print of OCSP Information
	private static void printOCSP(SmartOcsp so, BufferedWriter out) throws Exception {
		System.out.println("** OCSP **");
		System.out.println("Trust Level: " + so.getTrustLevel());
		System.out.println("Trust Label: " + so.getTrustLabel());
		System.out.println("XML OCSP: " + so.getOcspXml());
		out.write("** OCSP **\n");
		out.write("Trust Level: " + so.getTrustLevel() +"\n");
		out.write("Trust Label: " + so.getTrustLabel() +"\n");
		out.write("XML OCSP: " + so.getOcspXml() +"\n");
	}

	// Print of Archived CRL Information
	private static void printArchivedCRL(SmartCrl sac, BufferedWriter out) throws Exception {
		System.out.println("** Archived CRL **");
		System.out.println("Trust Level: " + sac.getTrustLevel());
		System.out.println("Trust Label: " + sac.getTrustLabel());
		System.out.println("XML Archived CRL: " + sac.getCrlXml());
		out.write("** Archived CRL **\n");
		out.write("Trust Level: " + sac.getTrustLevel() +"\n");
		out.write("Trust Label: " + sac.getTrustLabel() +"\n");
		out.write("XML Archived CRL: " + sac.getCrlXml() +"\n");
	}

	// Print of Archived OCSP Information
	private static void printArchivedOCSP(SmartOcsp sao, BufferedWriter out) throws Exception {
		System.out.println("** Archived OCSP **");
		System.out.println("Trust Level: " + sao.getTrustLevel());
		System.out.println("Trust Label: " + sao.getTrustLabel());
		System.out.println("XML Archived OCSP: " + sao.getOcspXml());
		out.write("** Archived OCSP **\n");
		out.write("Trust Level: " + sao.getTrustLevel() +"\n");
		out.write("Trust Label: " + sao.getTrustLabel() +"\n");
		out.write("XML Archived OCSP: " + sao.getOcspXml() +"\n");
	}

	// Print of Chain Information
	private static void printChain(SmartChain sch, BufferedWriter out) throws Exception {
		System.out.println("** Chain **");
		System.out.println("XML Chain: " + sch.getSignerCertificateXml());
		out.write("** Chain **\n");
		out.write("XML Chain: " + sch.getSignerCertificateXml() +"\n");
		
		// Print of Revocation Information
		for (int crl = 0; crl < sch.getNumberCrls(); crl++) {
			printCRL(sch.getCrl(crl),out);
		}
		for (int ocsp = 0; ocsp < sch.getNumberOcsp(); ocsp++) {
			printOCSP(sch.getOcsp(ocsp),out);
		}
	}

	// Print of Timestamp Information
	private static void printTimestamp(SmartStamp sst, BufferedWriter out) throws Exception {
		System.out.println("** TimeStamp **");
		System.out.println("Major: " + sst.getResultMajor());
		System.out.println("Minor: " + sst.getResultMinor());
		out.write("** TimeStamp **\n");
		out.write("Major: " + sst.getResultMajor() +"\n");
		out.write("Minor: " + sst.getResultMinor() +"\n");
		
		if(sst.getResultMessage() != null){
			System.out.println("Message: " + sst.getResultMessage());
			out.write("Message: " + sst.getResultMessage() +"\n");
		}
		System.out.println("Trust Level: " + sst.getTrustLevel());
		out.write("Trust Level: " + sst.getTrustLevel() +"\n");
		if(sst.getTrustLabel() != null){
			System.out.println("Trust Label: " + sst.getTrustLabel());
			out.write("Trust Label: " + sst.getTrustLabel() +"\n");
		}
		if(sst.getInfoXml() != null){
			System.out.println("Info XML: " + sst.getInfoXml());
			out.write("Info XML: " + sst.getInfoXml() +"\n");
		}
		if(sst.getTsaCertificateXml() != null){
			System.out.println("TSA Cert XML: " + sst.getTsaCertificateXml());
			out.write("TSA Cert XML: " + sst.getTsaCertificateXml() +"\n");
		}

		// Print of Chain Certificate in XML
		if (sst.getNumberChainCas() > 0) {
			System.out.println("Chain Cert XML: " + sst.getChainCasXml());
			out.write("Chain Cert XML: " + sst.getChainCasXml() +"\n");
			// Print of Chain Information
			for (int chain = 0; chain < sst.getNumberChainCas(); chain++) {
				printChain(sst.getChain(chain),out);
			}
		}

		// Print of Revocation Values
		for (int crl = 0; crl < sst.getNumberCrls(); crl++) {
			printCRL(sst.getCrl(crl),out);
		}
		for (int ocsp = 0; ocsp < sst.getNumberOcsp(); ocsp++) {
			printOCSP(sst.getOcsp(ocsp),out);
		}
		for (int acrl = 0; acrl < sst.getNumberArchivedCrls(); acrl++) {
			printArchivedCRL(sst.getCrl(acrl),out);
		}
		for (int aocsp = 0; aocsp < sst.getNumberArchivedOcsp(); aocsp++) {
			printArchivedOCSP(sst.getOcsp(aocsp),out);
		}
	}

	// Print of Archived Timestamp Information
	private static void printArchiveTimestamp(SmartStamp ssta, BufferedWriter out) throws Exception {
		System.out.println("** Archive TimeStamp **");
		System.out.println("Major: " + ssta.getResultMajor());
		System.out.println("Minor: " + ssta.getResultMinor());
		System.out.println("Message: " + ssta.getResultMessage());
		System.out.println("Trust Level: " + ssta.getTrustLevel());
		System.out.println("Trust Label: " + ssta.getTrustLabel());
		System.out.println("Info XML: " + ssta.getInfoXml());
		System.out.println("TSA Cert XML: " + ssta.getTsaCertificateXml());
		out.write("** Archive TimeStamp **\n");
		out.write("Major: " + ssta.getResultMajor() +"\n");
		out.write("Minor: " + ssta.getResultMinor() +"\n");
		out.write("Message: " + ssta.getResultMessage() +"\n");
		out.write("Trust Level: " + ssta.getTrustLevel() +"\n");
		out.write("Trust Label: " + ssta.getTrustLabel() +"\n");
		out.write("Info XML: " + ssta.getInfoXml() +"\n");
		out.write("TSA Cert XML: " + ssta.getTsaCertificateXml() +"\n");

		// Print of Chain Certificate in XML
		if (ssta.getNumberChainCas() > 0) {
			System.out.println("Chain Cert XML: " + ssta.getChainCasXml());
			out.write("Chain Cert XML: " + ssta.getChainCasXml() +"\n");
			// Print of Chain Information
			for (int chain = 0; chain < ssta.getNumberChainCas(); chain++) {
				printChain(ssta.getChain(chain),out);
			}
		}

		// Print of Revocation Values
		for (int crl = 0; crl < ssta.getNumberCrls(); crl++) {
			printCRL(ssta.getCrl(crl),out);
		}
		for (int ocsp = 0; ocsp < ssta.getNumberOcsp(); ocsp++) {
			printOCSP(ssta.getOcsp(ocsp),out);
		}
		for (int acrl = 0; acrl < ssta.getNumberArchivedCrls(); acrl++) {
			printArchivedCRL(ssta.getCrl(acrl),out);
		}
		for (int aocsp = 0; aocsp < ssta.getNumberArchivedOcsp(); aocsp++) {
			printArchivedOCSP(ssta.getOcsp(aocsp),out);
		}
	}
	
	
}