package utils;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;

public class UtilFile {
	
	public static String getAlias(String certificate, String keystorePassword) 
		throws Exception {
		String alias = "";
		
		KeyStore ks = KeyStore.getInstance("PKCS12");
        FileInputStream fis = new FileInputStream(new File(certificate));

        try {
        	ks.load(fis, keystorePassword.toCharArray());
        	alias = ks.aliases().nextElement();     
        	
        } finally {
        	fis.close();
        }
		return alias;
	}
	
	public static boolean mkDir(String pathAbsoluto) {
        boolean resultado = false;
        File file = new File(pathAbsoluto);
        
        if (!file.exists()) {
        	
            if (file.isAbsolute()) {
                resultado = file.mkdirs();
            }
        } else {
            resultado=true;
        }
        return resultado;
    }
	
	public static String getFile(String path){
        String fileName = null;
        String separator = File.separator;

        int pos = path.lastIndexOf(separator);
        
        fileName =path.substring(pos+1);

        return fileName;
    }
	
	public static String getFileName(File file){
        String fileName = null;
        String separator = File.separator;
        
        String path = file.getAbsolutePath();

        int pos = path.lastIndexOf(separator);
        int pos2 = path.lastIndexOf(".");

        if(pos2>-1)
                fileName =path.substring(pos+1, pos2);
        else
                fileName =path.substring(pos+1);

        return fileName;
    }
	
	public static List<File> getFiles(String path) {
		
		List<File> fileList = new ArrayList<File>();
		
		File resourcesPath = new File(path);
        String[] resourcesList = resourcesPath.list();
             
        for(String resourcesFile:resourcesList) {
        	resourcesFile = path
        	 	     + System.getProperty("file.separator")
        	 	     + resourcesFile;
        	 
        	if (!((new File(resourcesFile)).isDirectory())) {
        		fileList.add(new File(resourcesFile));
        	}
        }
		
		return fileList;
		
		/*File resourcesPath = new File(path);
		File[] files = resourcesPath.listFiles();
             
        List<File> result = Arrays.asList(files);
        
        for (int i = 0; i < result.size(); i++) {
        	File file = (File)result.get(i);
        	
        	if (!file.isFile()) {
        		result.remove(i);
        		i = i+1;
        	}
        }
        
        return result;*/
	}
	
}
