package utils;

import java.io.File;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class TrustedXConfiguration {

	private static PropertiesConfiguration configuration;
	
	private TrustedXConfiguration(){
		configuration = null;
	}
	
	public static Configuration getConfiguration() {
		if(configuration==null){
			File confFile = new File(System.getProperty("user.dir")+"\\etc\\client.properties");
			configuration = new PropertiesConfiguration();
			configuration.setFile(confFile);

			try {
				configuration.load();
			} catch (ConfigurationException e) {
				e.printStackTrace();
				throw new ConfigurationRuntimeException(e);
			}
		}
		return configuration;
	}
	
}
