package utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import report.XMLFileWriter;


public class GeneraReport {
	
	public static void generateReport(List<GenericMessage> contentList, 
			String reportPath, HashMap<String, String> paramList) 
			throws Exception {
		
		generateLayout(reportPath);
		
		GenericMessage genericMessage;
		
		List<String> attrListName = new ArrayList<String>();
		List<String> attrListValue = new ArrayList<String>();
		
		int index = reportPath.lastIndexOf(System.getProperty("file.separator"));
		String outPath = reportPath.substring(0, index);
		
		index = outPath.lastIndexOf(System.getProperty("file.separator"));
				
		XMLFileWriter report = new XMLFileWriter(reportPath);
		report.openFile(false);
		
		report.writeOpenTag("html");
		
		report.incOffSet();
		report.writeOpenTag("head");
		
		report.incOffSet();
		report.writeSimpleTag("title", paramList.get("title"));
		
		report.decOffSet();
		report.writeCloseTag("head");
		
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("bgcolor");
		attrListValue.add("#FFFFFF");
		report.writeOpenTag("body", attrListName, attrListValue);
		report.incOffSet();
		
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("width");
		attrListValue.add("100%");
		attrListName.add("border");
		attrListValue.add("0");
		attrListName.add("cellpadding");
		attrListValue.add("0");
		attrListName.add("cellspacing");
		attrListValue.add("3");
		attrListName.add("bgcolor");
		attrListValue.add("#FFFFFF");
		report.writeOpenTag("table", attrListName, attrListValue);
		report.incOffSet();
		
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("height");
		attrListValue.add("30");
		attrListName.add("align");
		attrListValue.add("center");
		report.writeOpenTag("tr", attrListName, attrListValue);
		report.incOffSet();
		
		report.writeOpenTag("td");
		report.incOffSet();
		
		report.writeSimpleTag("h3", paramList.get("subTitle"));
		
		report.decOffSet();
		report.writeCloseTag("td");
		
		report.decOffSet();
		report.writeCloseTag("tr");
		
		report.writeOpenTag("tr");
		report.incOffSet();
		
		report.writeOpenTag("td");
		report.incOffSet();
		
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("width");
		attrListValue.add("95%");
		attrListName.add("border");
		attrListValue.add("0");
		attrListName.add("cellpadding");
		attrListValue.add("3");
		attrListName.add("cellspacing");
		attrListValue.add("0");
		attrListName.add("align");
		attrListValue.add("center");
		report.writeOpenTag("table", attrListName, attrListValue);
		report.incOffSet();
		
		
		for (int i = 0; i < contentList.size(); i++) {
			genericMessage = (GenericMessage)contentList.get(i);
			
			//tr
			attrListName.clear();
			attrListValue.clear();
			attrListName.add("height");
			attrListValue.add("30");
			attrListName.add("style");
			
			if (i%2 == 0) { //Numero par
				attrListValue.add("background-color:EEEEFF;");
			} else {
				attrListValue.add("background-color:white;");
			}
			
			report.writeOpenTag("tr", attrListName, attrListValue);
			report.incOffSet();
			
			//td
			attrListName.clear();
			attrListValue.clear();
			attrListName.add("width");
			attrListValue.add("35%");
			report.writeOpenTag("td", attrListName, attrListValue);
			report.incOffSet();
			
			report.writeOpenTag("h4");
			
			attrListName.clear();
			attrListValue.clear();
			
			attrListName.add("href");
			attrListValue.add(genericMessage.getEntity());
			
			attrListName.add("target");
			attrListValue.add("Bottom");
			
			report.writeSimpleTag("a", UtilFile.getFile(genericMessage.getEntity()) + ":", attrListName, attrListValue);
			
			report.writeCloseTag("h4");
			
				
			attrListName.clear();
			attrListValue.clear();
			report.writeSimpleTag("b", "Resposta:");
			
			if (genericMessage.getStatut() == 1) {
				attrListName.add("style");
				attrListValue.add("color:red");
			}
			attrListName.add("href");
			attrListValue.add(genericMessage.getMessage());
			
			attrListName.add("target");
			attrListValue.add("Bottom");
			report.writeSimpleTag("a", UtilFile.getFile(genericMessage.getMessage()), attrListName, attrListValue);
			
			report.decOffSet();
			report.writeCloseTag("td");
			
			
			report.decOffSet();
			report.writeCloseTag("tr");
		}
			
		report.decOffSet();
		report.writeCloseTag("table");
		
		report.decOffSet();
		report.writeCloseTag("td");
		
		report.decOffSet();
		report.writeCloseTag("tr");
		
		report.decOffSet();
		report.writeCloseTag("table");
		
		report.decOffSet();
		report.writeCloseTag("body");
		
		report.decOffSet();
		report.writeCloseTag("html");
		
		
		report.closeFile();
	}

	public static void generateLayout(String reportPath) throws Exception {
		
		int endIndex = reportPath.lastIndexOf(System.getProperty("file.separator"));
		
		String path = reportPath.substring(0, endIndex);
		
		String layout = path + System.getProperty("file.separator") + "Inici.html";
		
		List<String> attrListName = new ArrayList<String>();
		List<String> attrListValue = new ArrayList<String>();
		
		XMLFileWriter report = new XMLFileWriter(layout);
		report.openFile(false);
		
		report.writeOpenTag("html");
		report.incOffSet();
		
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("rows");
		attrListValue.add("75,25");
		report.writeOpenTag("frameset", attrListName, attrListValue);
		report.incOffSet();
		
		//frame
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("src");
		attrListValue.add(UtilFile.getFile(reportPath));
		
		attrListName.add("name");
		attrListValue.add("Top");
		
		report.writeOpenTag("frame", attrListName, attrListValue);
		
		//frame
		attrListName.clear();
		attrListValue.clear();
		attrListName.add("src");
		attrListValue.add("about:blank");
		
		attrListName.add("name");
		attrListValue.add("Bottom");
		
		report.writeOpenTag("frame", attrListName, attrListValue);
		
		
		report.decOffSet();
		report.writeCloseTag("frameset");
		
		report.decOffSet();
		report.writeCloseTag("html");
		
		report.closeFile();
	} 
	
}
