package report;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;


public class XMLFileWriter {
	
	private PrintWriter out = null;
	private String offSet = "";
	private String fileName = "";
	
	
	public XMLFileWriter(String fileName) {
		this.fileName = fileName;
	}
	
	public void incOffSet() {
		offSet += "    "; 
	}
	
	public void decOffSet() {
		if (offSet.length() > 4) {
			offSet = offSet.substring(0, offSet.length()-4);
		} else {
			offSet = "";
		}
	}
	
	public void openFile(boolean control) throws Exception {

		try {
			out = new PrintWriter(new FileWriter(fileName, control));   
	         
	    } catch (Exception e) {
	          //System.out.println("Exception in openFile: " + e.getMessage ());
	          throw e;
	    }	      
	}
	
	public void closeFile() throws Exception {
	      
		try {
			if (out != null) {
				out.close();
			}
	          
		} catch (Exception e) {
	          //System.out.println ( "Exception in closeFile: " + e.getMessage());
	          throw e;
	    }
	}
	
	public void writeLine(String line) throws Exception {
	    
		try {
			out.println(offSet + line);
	        out.flush();
	          
	    } catch ( Exception e ) {
	    	//System.out.println ( "Exception in writeLine: " + e.getMessage () );
	    }
	}
	
	public void writeSimpleTag(String tag, String value) 
		throws Exception {
		List<String> tmp = new ArrayList<String>();
		
		writeSimpleTag(tag, value, tmp, tmp);
	}
	
	public void writeSimpleTag(String tag, String value,
            			 List<String> attrListName, List<String> attrListValue) 
			throws Exception {
		
		try {
			writeOpenTag(tag, attrListName, attrListValue); 
			
			writeTagValue(value);
			 
			writeCloseTag(tag);
			
		} catch ( Exception e ) {
			//System.out.println ("Exception in writeTag: " + e.getMessage ());
		}
	}
	
	public void writeOpenTag(String tag) throws Exception {
		
		List<String> tmp = new ArrayList<String>();
	      
		try {
			writeOpenTag(tag, tmp, tmp);
	      
		} catch ( Exception e ) {
			//System.out.println ("Exception in writeOpenTag: " + e.getMessage ());
			throw e;
		} 
	}
	
	public void writeOpenTag(String tag, List<String> attrListName, List<String> attrListValue) 
			throws Exception {
		
		StringBuffer line = new StringBuffer();
		line.append("<");
		line.append(tag);
		
		for (int i = 0; i < attrListName.size(); i++) {
			line.append(" ");
			line.append((String)attrListName.get(i));
			line.append("=\"");
			line.append((String)attrListValue.get(i));
			line.append("\"");  
		}
		line.append(">");
		
		try {
			writeLine(line.toString());
			
		} catch ( Exception e ) {
			//System.out.println ("Exception in writeOpenTag: " + e.getMessage ());
			throw e;
		}
	}
	
	public void writeCloseTag(String tag) throws Exception {

		String line = "</" + tag + ">";

	    try {
	    	writeLine(line);
	          
	    } catch ( Exception e ) {
	    	//System.out.println ("Exception in writeCloseTag: " + e.getMessage ());
	    }
	}
	
	public void writeTagValue(String value) throws Exception {
		
		try {
			if (value != null && !value.equals("")) {
				writeLine(value);
			}
	          
	    } catch ( Exception e ) {
	    	//System.out.println ("Exception in writeTagValue: " + e.getMessage ());
	    } 
	}

}
