package net.catcert.trustedX.Creation.PDF.CAdES.T;

import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.configuration.Configuration;

import utils.TrustedXConfiguration;
import utils.Util;
import utils.UtilTrustedX;

import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

/**
 * PDF signature generation
 * 
 * @author aalcaide
 */
public class CreateSignaturePDF_CAdES_T_Detached_Visible {

	private static final String path_in = "in/docs_to_sign/";
	private static final String path_out = "out/Signatures/PDF/";

	private static final String filename = "demo-file.pdf";
	
    private static final String pdfSignatureInfo = "<css:PdfSignatureInfo xmlns:css='http://www.safelayer.com/TWS'>" +
    											   "<css:PdfAttributes>"+
    											   "<css:validationMethod>PPKMS</css:validationMethod>"+
    											   "<css:signaturePosition>FIRST</css:signaturePosition>"+
    											   "<css:signatureAlg>DETACHED</css:signatureAlg>"+ //detached
    											   "</css:PdfAttributes>" +
    											   "<css:Appearance>" +
    											   "<css:Rect x0=\"100\" x1=\"300\" y0=\"100\" y1=\"200\"/>" +
    											   "<css:Background>" +
    											   "<css:image encodeType=\"base64\">" +
    											   "<css:data>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</css:data>" +
    											   "<css:imageSize width=\"180\" height=\"100\"/>" +
    											   "<css:position x=\"0\" y=\"0\"/>" +
    											   "</css:image>" +
    											   "</css:Background>" +
    											   "<css:Foreground>" +
    											   "<css:image encodeType=\"base64\">" +
    											   "<css:data>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</css:data>" +
    											   "<css:imageSize width=\"30\" height=\"30\"/>" +
    											   "<css:position x=\"160\" y=\"5\"/>" +
    											   "</css:image>" +
    											   "<css:text>" +
    											   "<css:properties color=\"0 0 0\" fontSize=\"7\"/>" +
    											   "<css:position x=\"0\" y=\"10\"/>" +
    											   "<css:SignatureInfos>" +
    											   "<css:signatureInfo title=\"Autor de la firma: \" id=\"Subject\"/>" +
    											   "<css:signatureInfo title=\"Emisor del certificado: \" id=\"Issuer\"/>" +
    											   "<css:signatureInfo title=\"Nmero de serie: \" id=\"SerialNumber\"/>" +
    											   "<css:signatureInfo title=\"Razn: \" id=\"Reason\"/>" +
    											   "<css:signatureInfo title=\"Localitzacin: \" id=\"Location\"/>" +
    											   "<css:signatureInfo title=\"Informacin de contacto: \" id=\"ContactInfo\"/>" +
    											   "<css:signatureInfo title=\"Fecha de firma: \" id=\"Date\"/>" +
    											   "</css:SignatureInfos>" +
    											   "</css:text>" +
    											   "</css:Foreground>" +
    											   "</css:Appearance>" +
    											   "</css:PdfSignatureInfo>";
		
	public static void main(String[] args) {
		try {
			
			Configuration conf = TrustedXConfiguration.getConfiguration();
			String host = conf.getString("host");
			String distinguishedName = conf.getString("distinguishedname");
			String dipositari = conf.getString("dipositari");
			String rol  = conf.getString("rol");
			
			// Definition of Signature Request endpoint
			SmartSignRequest ssr = new SmartSignRequest(host);
			
			// Add customized header elements for SOAP
			Stub stub = (Stub) ssr.getStub();
			stub.setHeader(null, "Rol", rol);
			stub.setHeader(null, "Dipositari", dipositari);
		    
			// PDF Signature
			ssr.setProfile(Constants.Profile.PDF);
			// Read pdf file
			ssr.setInputPdfBase64Data(Util.readBinaryFileB64(path_in + filename));			
			
			// Key selection using Distinguished Name			
			ssr.setKeySubjectName(distinguishedName);
			
			// CAdES signature type
			ssr.setSignatureType(Constants.SignatureType.CADES);
			// CAdES signature form
			ssr.setSignatureFormat(Constants.SignatureFormat.ES_T);
			
			// Add PDF Signature Information
			ssr.setPdfSignatureInfo(pdfSignatureInfo);

			// Sending the request
			SmartSignResponse ssrs = ssr.send();

			if (UtilTrustedX.checkSW(ssrs.getResultMajor(), ssrs.getResultMinor(), ssrs.getResultMessage())) {
				// Retrieve and write signature data to disk
				String destFilename = path_out + filename.substring(0, filename.lastIndexOf("."))
						+ "_Signed_CAdES_T_Detached_Visible.pdf";
				Util.writeBinaryFileB64(destFilename, ssrs.getDocumentWithSignaturePdf());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
