package net.catcert.trustedX.Creation.BigFiles.XAdES.BES;

import org.apache.axis.client.Stub;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.configuration.Configuration;

import utils.TrustedXConfiguration;
import utils.Util;
import utils.UtilTrustedX;

import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

/**
 * XML Signature Generation
 * 
 * @author aalcaide
 */
public class CreateSignature_XAdES_BES_Enveloped_BigFile {

	private static final String path_in = "in/docs_to_sign/BigFiles/";
	private static final String path_out = "out/Signatures/BigFiles/";
	private static final String filename = "Demo-BigFile.xml";

	public static void main(String[] args) {
		try {

			Configuration conf = TrustedXConfiguration.getConfiguration();
			String host = conf.getString("host");
			String distinguishedName = conf.getString("distinguishedname");
			String dipositari = conf.getString("dipositari");
			String rol  = conf.getString("rol");
			
			// Definition of Signature Request endpoint
			SmartSignRequest ssr = new SmartSignRequest(host);
			
			// Add customized header elements for SOAP
			Stub stub = (Stub) ssr.getStub();
			stub.setHeader(null, "Rol", rol);
			stub.setHeader(null, "Dipositari", dipositari);
		    
			// XML Signature (XAdES)
			ssr.setProfile(Constants.Profile.XADES);
			
			// Referncia al fitxer que cont les dades a signar
			// Parmetres: path (codificat en Base64) del fitxer + tipus de dades del fitxer (Raw o Base64) 
			ssr.setInputXmlBase64File(Base64.encode((path_in + filename).getBytes()), Constants.SourceFormat.RAW);

			// Habilitem la gesti en arxiu de la signatura en la resposta
			ssr.enableDocumentWithSignatureXmlBase64File(Constants.SourceFormat.RAW);
			
			// XAdES signature form
			ssr.setSignatureFormat(Constants.SignatureFormat.BES);
			
			// Signature Placement
			ssr.setSignaturePlacement(Constants.SignaturePlacement.ENVELOPED);
			ssr.setXmlEnvelopedXPathAfter("//*[local-name()='ssc']//*[local-name()='description']");
			
			// Key selection using Distinguished Name
			ssr.setKeySubjectName(distinguishedName);

			// Sending request
			SmartSignResponse ssrs = ssr.send();

			// Retrieveing signature
			if (UtilTrustedX.checkSW(ssrs.getResultMajor(), ssrs.getResultMinor(), ssrs.getResultMessage())) {
				String destFilename = path_out + filename.substring(0, filename.lastIndexOf("."))
				+ "_Signature_XAdES_BES_Enveloped.xml";
				Util.writeBinaryFile(destFilename, ssrs.getDocumentWithSignatureXml().getBytes());
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}