/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.ParserException;
import com.safelayer.trustedx.client.smartwrapper.exception.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisEngine;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.ClassUtils;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmartWrapperUtil {
    static final String CONFIG_FILENAME_PROPERTY = "smartwrapper.propertiesFile";
    static final String DEFAULT_CONFIG_FILENAME = "smartwrapper.properties";

    public static String serialize(Object object, QName qName, String string, String string2) throws SerializationException {
        return SmartWrapperUtil.serialize(object, qName, string, string2, false);
    }

    public static String serialize(Object object, QName qName, String string, String string2, boolean bl) throws SerializationException {
        if (object != null) {
            StringWriter stringWriter = new StringWriter();
            AxisServer axisServer = new AxisServer();
            MessageContext messageContext = new MessageContext((AxisEngine)axisServer);
            SerializationContext serializationContext = new SerializationContext((Writer)stringWriter, messageContext);
            serializationContext.setDoMultiRefs(false);
            serializationContext.setSendDecl(bl);
            if ("http://www.w3.org/2000/09/xmldsig#".equals(string)) {
                serializationContext.getPrefixForURI("http://www.w3.org/2000/09/xmldsig#", "dsig");
            }
            if ("http://www.safelayer.com/TWS".equals(string)) {
                serializationContext.getPrefixForURI("http://www.safelayer.com/TWS", "css");
            }
            if ("http://www.docs.oasis-open.org/dss/2004/06/oasis-dss-1.0-core-schema-wd-27.xsd".equals(string)) {
                serializationContext.getPrefixForURI("http://www.docs.oasis-open.org/dss/2004/06/oasis-dss-1.0-core-schema-wd-27.xsd", "dss");
            }
            if ("http://uri.etsi.org/01903/v1.3.2#".equals(string)) {
                serializationContext.getPrefixForURI("http://uri.etsi.org/01903/v1.3.2#", "xades");
            }
            try {
                serializationContext.serialize(new QName(string, string2), null, object, qName, Boolean.FALSE, Boolean.FALSE);
                stringWriter.flush();
                stringWriter.close();
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
            return stringWriter.toString();
        }
        return null;
    }

    static MessageElement getSubNode(MessageElement messageElement, String string) {
        return SmartWrapperUtil.getSubNode(messageElement, string, 0);
    }

    static MessageElement getSubNode(MessageElement messageElement, String string, int n) {
        Iterator iterator;
        if (messageElement != null && (iterator = messageElement.getChildElements()) != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || !(e instanceof MessageElement)) continue;
                String string2 = ((MessageElement)e).getTagName();
                if (string.indexOf(58) == -1) {
                    string2 = string2.substring(string2.indexOf(58) + 1);
                }
                if (!string.equals(string2)) continue;
                if (n == 0) {
                    return (MessageElement)e;
                }
                --n;
            }
        }
        return null;
    }

    static int countSubNode(MessageElement messageElement, String string) {
        Iterator iterator;
        int n = 0;
        if (messageElement != null && (iterator = messageElement.getChildElements()) != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || !(e instanceof MessageElement)) continue;
                String string2 = ((MessageElement)e).getTagName();
                if (string.indexOf(58) == -1) {
                    string2 = string2.substring(string2.indexOf(58) + 1);
                }
                if (!string.equals(string2)) continue;
                ++n;
            }
        }
        return n;
    }

    static boolean hasSubNode(MessageElement messageElement, String string) {
        Iterator iterator;
        boolean bl = false;
        if (messageElement != null && (iterator = messageElement.getChildElements()) != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || !(e instanceof MessageElement)) continue;
                String string2 = ((MessageElement)e).getTagName();
                if (string.indexOf(58) == -1) {
                    string2 = string2.substring(string2.indexOf(58) + 1);
                }
                if (!string.equals(string2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    static void removeAttributeFromChilds(MessageElement messageElement, String string) {
        Iterator iterator;
        if (messageElement != null && (iterator = messageElement.getChildElements()) != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || !(e instanceof MessageElement)) continue;
                if (((MessageElement)e).hasAttribute(string)) {
                    ((MessageElement)e).removeAttribute(string);
                }
                SmartWrapperUtil.removeAttributeFromChilds((MessageElement)e, string);
            }
        }
    }

    public static MessageElement getMessageElementFromString(String string) throws ParserException {
        if (string != null) {
            Document document;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                document = documentBuilder.parse(byteArrayInputStream);
            }
            catch (Exception exception) {
                throw new ParserException(exception);
            }
            return new MessageElement(document.getDocumentElement());
        }
        return null;
    }

    public static Hashtable getTransportOptions(AxisEngine axisEngine, String string) throws ConfigurationException {
        SimpleTargetedChain simpleTargetedChain;
        try {
            simpleTargetedChain = (SimpleTargetedChain)axisEngine.getConfig().getTransport(new QName(string));
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
        Hashtable hashtable = simpleTargetedChain.getOptions();
        if (hashtable != null) {
            Handler handler = simpleTargetedChain.getPivotHandler();
            hashtable = handler.getOptions();
        }
        return hashtable;
    }

    static String fillSoap(Message message) {
        try {
            byte[] byArray = message.getSOAPPartAsBytes();
            StreamSource streamSource = new StreamSource(new File("resources/tidyxml.xslt"));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            StreamSource streamSource2 = new StreamSource(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(streamSource2, new StreamResult(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8")));
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String serialize(Node node, String string) throws SerializationException {
        return SmartWrapperUtil.serialize(SmartWrapperUtil.getXmlNode(node, string));
    }

    public static String serialize(Node node) throws SerializationException {
        if (node != null) {
            StringWriter stringWriter = new StringWriter();
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndenting(false);
            outputFormat.setOmitXMLDeclaration(true);
            outputFormat.setEncoding("UTF-8");
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.setNamespaces(true);
            try {
                DOMSerializer dOMSerializer = xMLSerializer.asDOMSerializer();
                dOMSerializer.serialize((Element)node);
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
            return stringWriter.toString();
        }
        return null;
    }

    public static Node getXmlNode(Message message, String string) throws Exception {
        if (message != null && string != null && message.getSOAPBody() != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(message.getSOAPPartAsBytes()));
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("*");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!string.equals(node.getLocalName())) continue;
                    return node;
                }
            }
        }
        return null;
    }

    public static Node getXmlBodyNode(Message message, String string) throws Exception {
        NodeList nodeList;
        Node node = SmartWrapperUtil.getXmlNode(message, "Body");
        if (node != null && (nodeList = ((Element)node).getElementsByTagName("*")) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!string.equals(node2.getLocalName())) continue;
                return node2;
            }
        }
        return null;
    }

    public static Node getXmlNode(Node node, String string) {
        if (node != null && string != null) {
            Object object;
            if (string.equals("/")) {
                return node;
            }
            String string2 = string.substring(string.indexOf(47) + 1);
            String string3 = null;
            int n = 0;
            if (string2.indexOf(47) != -1) {
                string3 = string2.substring(string2.indexOf(47), string2.length());
                string2 = string2.substring(0, string2.indexOf(47));
            }
            if (string2.indexOf(40) != -1) {
                object = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41));
                n = new Integer((String)object);
                string2 = string2.substring(0, string2.indexOf(40));
            }
            if ((object = ((Element)node).getElementsByTagName("*")) != null) {
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node2 = object.item(i);
                    if (!string2.equals(node2.getNodeName())) continue;
                    if (n == 0) {
                        if (string3 != null) {
                            return SmartWrapperUtil.getXmlNode(node2, string3);
                        }
                        return node2;
                    }
                    --n;
                }
            }
        }
        return null;
    }

    public static String getXmlNodeAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap;
        String string2 = null;
        if (node != null && string != null && !"".equals(string) && (namedNodeMap = node.getAttributes()) != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!string.equals(node2.getNodeName())) continue;
                string2 = node2.getNodeValue();
                break;
            }
        }
        return string2;
    }

    static String getIpAddress(String string, int n) {
        Object object;
        String string2 = null;
        try {
            object = SmartWrapperUtil.getAddressListFromNetworkInterfaces();
            if (object.size() == 1) {
                string2 = ((InetAddress)object.get(0)).getHostAddress();
            } else if (object.size() > 1 && !SmartWrapperUtil.isLocalHost(string)) {
                string2 = SmartWrapperUtil.getAddressFromSocket(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                object = InetAddress.getLocalHost();
                string2 = ((InetAddress)object).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return string2;
    }

    private static boolean isLocalHost(String string) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException socketException) {
            return false;
        }
    }

    private static List getAddressListFromNetworkInterfaces() throws Exception {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) continue;
                arrayList.add(inetAddress);
            }
        }
        return arrayList;
    }

    private static String getAddressFromSocket(String string, int n) throws Exception {
        Socket socket = new Socket(string, n);
        InetAddress inetAddress = socket.getLocalAddress();
        socket.close();
        return inetAddress.getHostAddress();
    }

    static void addTag(Hashtable hashtable, String string, String string2) {
        String string3 = (String)hashtable.get(string);
        String string4 = " " + string3 + " ";
        if (string4.indexOf(" " + string2 + " ") == -1) {
            string4 = string3 + " " + string2;
            string4 = string4.trim();
            hashtable.put(string, string4);
        }
    }

    static void removeTag(Hashtable hashtable, String string, String string2) {
        String string3;
        String string4 = (String)hashtable.get(string);
        String string5 = " " + string4 + " ";
        if (string5.indexOf(string3 = " " + string2 + " ") != -1) {
            string5 = string5.substring(0, string5.indexOf(string3)) + " " + string5.substring(string5.indexOf(string3) + string3.length());
            string5 = string5.trim();
            hashtable.put(string, string5);
        }
    }

    public static Properties getProperties() throws Exception {
        return SmartWrapperUtil.getProperties(CONFIG_FILENAME_PROPERTY, DEFAULT_CONFIG_FILENAME);
    }

    static Properties getProperties(String string, String string2) throws Exception {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(string3);
        }
        catch (Exception exception) {
            inputStream = ClassUtils.getResourceAsStream((Class)SmartWrapperUtil.class, (String)string3, (boolean)true);
        }
        if (inputStream != null) {
            properties.load(inputStream);
            inputStream.close();
        }
        return properties;
    }

    public static void setProperties(AxisEngine axisEngine, Properties properties) throws ConfigurationException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                String string2;
                if (string.startsWith("req-log.")) {
                    string2 = string.substring("req-log.".length());
                    axisEngine.getConfig().getHandler(new QName("req-log")).getOptions().put(string2, properties.getProperty(string));
                    continue;
                }
                if (string.startsWith("res-log.")) {
                    string2 = string.substring("res-log.".length());
                    axisEngine.getConfig().getHandler(new QName("res-log")).getOptions().put(string2, properties.getProperty(string));
                    continue;
                }
                if (string.startsWith("authN.")) {
                    string2 = string.substring("authN.".length());
                    axisEngine.getConfig().getHandler(new QName("authN")).getOptions().put(string2, properties.getProperty(string));
                    continue;
                }
                axisEngine.getConfig().getHandler(new QName("sender")).getOptions().put(string, properties.getProperty(string));
                if ("Request.loadPath".equals(string)) {
                    string2 = "loadPath";
                    axisEngine.getConfig().getHandler(new QName("req-log")).getOptions().put(string2, properties.getProperty(string));
                }
                if (!"Response.savePath".equals(string)) continue;
                string2 = "loadPath";
                axisEngine.getConfig().getHandler(new QName("res-log")).getOptions().put(string2, properties.getProperty(string));
            }
            catch (org.apache.axis.ConfigurationException configurationException) {
                throw new ConfigurationException(configurationException);
            }
        }
    }

    public static void setProperties(AxisEngine axisEngine) throws ConfigurationException {
        Properties properties = null;
        try {
            properties = SmartWrapperUtil.getProperties();
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
        SmartWrapperUtil.setProperties(axisEngine, properties);
    }
}

