/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSkmListKeysResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.SKM.SKMBindingStub;
import com.safelayer.www.TWS.SKM.SymmetricKeyManagementType;
import com.safelayer.www.TWS.SKM.TWSSKMLocator;
import com.safelayer.www.TWS.SkmListKeysRequestType;
import com.safelayer.www.TWS.SkmListKeysResponseType;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.types.URI;
import org.w3c.dom.Node;

public class SmartSkmListKeysRequest
extends AbstractSmartDataRequest {
    private SKMBindingStub bindingSkm;
    private SkmListKeysRequestType request;
    private boolean userHasCallRequestId = false;

    public SmartSkmListKeysRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartSkmListKeysRequest(String string, Properties properties) throws Exception {
        TWSSKMLocator tWSSKMLocator = new TWSSKMLocator();
        tWSSKMLocator.setSymmetricKeyManagementEndpointAddress(string);
        SymmetricKeyManagementType symmetricKeyManagementType = tWSSKMLocator.getSymmetricKeyManagement();
        this.bindingSkm = (SKMBindingStub)symmetricKeyManagementType;
        SmartWrapperUtil.setProperties(tWSSKMLocator.getEngine(), properties);
        this.request = new SkmListKeysRequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public Stub getStub() {
        return this.bindingSkm;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSkm.setHeader(smartHeader.getInternalObject());
    }

    public void setServicePolicy(String string) throws URI.MalformedURIException {
        this.request.setServicePolicy(new URI(string));
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public SmartSkmListKeysResponse send() throws Exception {
        this.fillRequest();
        SkmListKeysResponseType skmListKeysResponseType = this.bindingSkm.listKeys(this.request);
        Hashtable hashtable = this.getOptions();
        Node node = null;
        Message message = this.bindingSkm._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "ListKeysResponse");
        }
        SmartSkmListKeysResponse smartSkmListKeysResponse = new SmartSkmListKeysResponse(skmListKeysResponseType, hashtable, node);
        return smartSkmListKeysResponse;
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    protected Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingSkm._getCall() != null) {
                String string = this.bindingSkm._getCall().getMessageContext().getTransportName();
                TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
                return SmartWrapperUtil.getTransportOptions(tWSSKMLocator.getEngine(), string);
            }
            TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
            return tWSSKMLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    protected EngineConfiguration getConfig() {
        TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
        return tWSSKMLocator.getEngine().getConfig();
    }
}

