/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.message.MessageElement;
import org.etsi.uri._01903.v1_2_2.EncapsulatedPKIDataType;
import org.w3c.dom.Document;

abstract class SmartRevocationInfo {
    protected EncapsulatedPKIDataType encodedObj;
    protected MessageElement xmlObj;

    SmartRevocationInfo(EncapsulatedPKIDataType encapsulatedPKIDataType, MessageElement messageElement) {
        this.encodedObj = encapsulatedPKIDataType;
        this.xmlObj = messageElement;
    }

    SmartRevocationInfo(MessageElement messageElement) {
        this.encodedObj = null;
        this.xmlObj = messageElement;
    }

    abstract String getNodeName();

    protected String getXml() throws Exception {
        MessageElement messageElement = SmartWrapperUtil.getSubNode(this.xmlObj, this.getNodeName());
        if (messageElement != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(messageElement.toString().getBytes("UTF8")));
            return SmartWrapperUtil.serialize(document.getDocumentElement());
        }
        return null;
    }

    public int getTrustLevel() {
        MessageElement messageElement = SmartWrapperUtil.getSubNode(this.xmlObj, "TrustInfo");
        if (messageElement != null) {
            String string = messageElement.getAttributeValue("TrustLevel");
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getTrustLabel() {
        MessageElement messageElement = SmartWrapperUtil.getSubNode(this.xmlObj, "TrustInfo");
        if (messageElement != null) {
            return messageElement.getAttributeValue("TrustLabel");
        }
        return null;
    }
}

