/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartRegisterResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.trustedx.client.smartwrapper.exception.ParserException;
import java.util.Properties;
import java.util.Random;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.Id;
import org.apache.axis.types.URI;
import org.w3.www._2000._09.xmldsig.KeyInfoType;
import org.w3.www._2002._03.xkms.AuthenticationType;
import org.w3.www._2002._03.xkms.KeyUsageEnum;
import org.w3.www._2002._03.xkms.MessageExtensionAbstractType;
import org.w3.www._2002._03.xkms.NotBoundAuthenticationType;
import org.w3.www._2002._03.xkms.PrototypeKeyBindingType;
import org.w3.www._2002._03.xkms.RegisterRequestType;
import org.w3.www._2002._03.xkms.RegisterResultType;
import org.w3.www._2002._03.xkms.RespondWithEnum;
import org.w3.www._2002._03.xkms.RespondWithOpenEnum;
import org.w3.www._2002._03.xkms.SOAPBindingStub;
import org.w3.www._2002._03.xkms.XKMSPortType;
import org.w3.www._2002._03.xkms.XKMSServiceLocator;

public class SmartRegisterRequest {
    private RegisterRequestType request;
    private SOAPBindingStub bindingKm;
    private static String NODE_TRUSTEDCERT = "TrustedCert";
    private static String NODE_ROOTCERT = "X509Certificate";
    private static String NODE_ROOTFINGER = "KeyName";
    private static String NODE_PKCS12 = "PKCS12Data";
    private static String NODE_X509DATACOLLECTION = "X509DataCollection";
    private static String NODE_X509CERTIFICATE = "X509Certificate";
    private static String NODE_X509DATA = "X509Data";
    private static String PREFIX_CSS = "css";
    private static String PREFIX_DSIG = "dsig";
    private static String URI_SFLY = "http://www.safelayer.com/TWS";
    private static String URI_DS = "http://www.w3.org/2000/09/xmldsig#";
    private static String URI_SERVICE = "urn:safelayer:tws:services:km:2.1";
    private Random random = new Random();
    private static String chars = "abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public SmartRegisterRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartRegisterRequest(String string, Properties properties) throws Exception {
        XKMSServiceLocator xKMSServiceLocator = new XKMSServiceLocator();
        xKMSServiceLocator.setXKMSPortEndpointAddress(string);
        XKMSPortType xKMSPortType = xKMSServiceLocator.getXKMSPort();
        this.bindingKm = (SOAPBindingStub)xKMSPortType;
        SmartWrapperUtil.setProperties(xKMSServiceLocator.getEngine(), properties);
        this.request = new RegisterRequestType();
        this.initDefault();
    }

    void initDefault() {
        this.request.setAuthentication(new AuthenticationType());
        this.setId(this.getRandomString());
        try {
            this.setService(URI_SERVICE);
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
    }

    public Object getInternalObject() {
        return this.request;
    }

    public Stub getStub() {
        return this.bindingKm;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingKm.setHeader(smartHeader.getInternalObject());
    }

    public void setId(String string) {
        this.request.setId(new Id(string));
    }

    void setService(String string) throws URI.MalformedURIException {
        this.request.setService(new URI(string));
    }

    void checkMessageExtension() {
        if (this.request.getMessageExtension() == null) {
            this.request.setMessageExtension(new MessageExtensionAbstractType[0]);
        }
    }

    public void setClaimedIdentity(String string) {
        if (this.request.getMessageExtension() == null) {
            MessageExtensionAbstractType messageExtensionAbstractType = new MessageExtensionAbstractType();
            messageExtensionAbstractType.setClaimedIdentity(string);
            this.request.setMessageExtension(new MessageExtensionAbstractType[]{messageExtensionAbstractType});
        } else {
            this.request.getMessageExtension(0).setClaimedIdentity(string);
        }
    }

    public void setServicePolicy(String string) throws URI.MalformedURIException {
        if (this.request.getMessageExtension() == null) {
            MessageExtensionAbstractType messageExtensionAbstractType = new MessageExtensionAbstractType();
            messageExtensionAbstractType.setServicePolicy(new URI(string));
            this.request.setMessageExtension(new MessageExtensionAbstractType[]{messageExtensionAbstractType});
        } else {
            this.request.getMessageExtension(0).setServicePolicy(new URI(string));
        }
    }

    void checkTrustedCert() {
        MessageElement[] messageElementArray = this.request.getPrototypeKeyBinding().getKeyInfo().get_any();
        if (messageElementArray != null) {
            MessageElement messageElement;
            int n = messageElementArray.length;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                messageElement = messageElementArray[i];
                if (!messageElement.getName().equals(NODE_TRUSTEDCERT)) continue;
                bl = true;
            }
            if (!bl) {
                messageElement = new MessageElement();
                messageElement.setName(NODE_TRUSTEDCERT);
                messageElement.setPrefix(PREFIX_CSS);
                MessageElement[] messageElementArray2 = new MessageElement[n + 1];
                for (int i = 0; i < n; ++i) {
                    messageElementArray2[i] = messageElementArray[i];
                }
                messageElementArray2[n] = messageElement;
                this.request.getPrototypeKeyBinding().getKeyInfo().set_any(messageElementArray2);
            }
        } else {
            MessageElement messageElement = new MessageElement();
            messageElement.setName(NODE_TRUSTEDCERT);
            messageElement.setPrefix(PREFIX_CSS);
            messageElement.setNamespaceURI(URI_SFLY);
            this.request.getPrototypeKeyBinding().getKeyInfo().set_any(new MessageElement[]{messageElement});
        }
    }

    public void setRootCertificate(String string) throws SOAPException {
        this.checkPrototypeKeyBinding();
        this.checkKeyInfo();
        this.checkTrustedCert();
        MessageElement messageElement = new MessageElement();
        messageElement.setName(NODE_ROOTCERT);
        messageElement.setPrefix(PREFIX_DSIG);
        messageElement.setNamespaceURI(URI_SFLY);
        messageElement.setValue(string);
        MessageElement[] messageElementArray = this.request.getPrototypeKeyBinding().getKeyInfo().get_any();
        MessageElement messageElement2 = new MessageElement();
        for (int i = 0; i < messageElementArray.length && !(messageElement2 = messageElementArray[i]).getName().equals(NODE_TRUSTEDCERT); ++i) {
        }
        messageElement2.addChild(messageElement);
    }

    public void setRootFingerPrint(String string) throws SOAPException {
        this.checkPrototypeKeyBinding();
        this.checkKeyInfo();
        this.checkTrustedCert();
        MessageElement messageElement = new MessageElement();
        messageElement.setName(NODE_ROOTFINGER);
        messageElement.setPrefix(PREFIX_CSS);
        messageElement.setNamespaceURI(URI_SFLY);
        messageElement.setValue(string);
        MessageElement[] messageElementArray = this.request.getPrototypeKeyBinding().getKeyInfo().get_any();
        MessageElement messageElement2 = new MessageElement();
        for (int i = 0; i < messageElementArray.length && !(messageElement2 = messageElementArray[i]).getName().equals(NODE_TRUSTEDCERT); ++i) {
        }
        messageElement2.addChild(messageElement);
    }

    void checkKeyInfo() {
        if (this.request.getPrototypeKeyBinding().getKeyInfo() == null) {
            this.request.getPrototypeKeyBinding().setKeyInfo(new KeyInfoType());
        }
    }

    void checkX509DataCollection() {
        MessageElement[] messageElementArray = this.request.getPrototypeKeyBinding().getKeyInfo().get_any();
        if (messageElementArray != null) {
            MessageElement messageElement;
            int n = messageElementArray.length;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                messageElement = messageElementArray[i];
                if (!messageElement.getName().equals(NODE_X509DATACOLLECTION)) continue;
                bl = true;
            }
            if (!bl) {
                messageElement = new MessageElement();
                messageElement.setName(NODE_X509DATACOLLECTION);
                messageElement.setPrefix(PREFIX_CSS);
                MessageElement[] messageElementArray2 = new MessageElement[n + 1];
                for (int i = 0; i < n; ++i) {
                    messageElementArray2[i] = messageElementArray[i];
                }
                messageElementArray2[n] = messageElement;
                this.request.getPrototypeKeyBinding().getKeyInfo().set_any(messageElementArray2);
            }
        } else {
            MessageElement messageElement = new MessageElement();
            messageElement.setName(NODE_X509DATACOLLECTION);
            messageElement.setPrefix(PREFIX_CSS);
            messageElement.setNamespaceURI(URI_SFLY);
            this.request.getPrototypeKeyBinding().getKeyInfo().set_any(new MessageElement[]{messageElement});
        }
    }

    public void setX509Certificate(String string) throws SOAPException {
        this.checkPrototypeKeyBinding();
        this.checkKeyInfo();
        this.checkX509DataCollection();
        MessageElement messageElement = new MessageElement();
        messageElement.setPrefix(PREFIX_DSIG);
        messageElement.setName(NODE_X509DATA);
        messageElement.setNamespaceURI(URI_DS);
        MessageElement messageElement2 = new MessageElement();
        messageElement2.setPrefix(PREFIX_DSIG);
        messageElement2.setName(NODE_X509CERTIFICATE);
        messageElement2.setValue(string);
        messageElement2.setNamespaceURI(URI_DS);
        messageElement.addChild(messageElement2);
        MessageElement[] messageElementArray = this.request.getPrototypeKeyBinding().getKeyInfo().get_any();
        MessageElement messageElement3 = new MessageElement();
        for (int i = 0; i < messageElementArray.length && !(messageElement3 = messageElementArray[i]).getName().equals(NODE_X509DATACOLLECTION); ++i) {
        }
        messageElement3.addChild(messageElement);
    }

    public void setPkcs12Data(String string) throws ParserException {
        this.checkPrototypeKeyBinding();
        this.checkKeyInfo();
        MessageElement[] messageElementArray = this.request.getPrototypeKeyBinding().getKeyInfo().get_any();
        MessageElement messageElement = new MessageElement();
        messageElement.setPrefix(PREFIX_CSS);
        messageElement.setName(NODE_PKCS12);
        messageElement.setNamespaceURI(URI_SFLY);
        messageElement.setValue(string);
        if (messageElementArray != null) {
            int n = messageElementArray.length;
            MessageElement[] messageElementArray2 = new MessageElement[n + 1];
            for (int i = 0; i < n; ++i) {
                messageElementArray2[i] = messageElementArray[i];
            }
            messageElementArray2[n] = messageElement;
            this.request.getPrototypeKeyBinding().getKeyInfo().set_any(messageElementArray2);
        } else {
            this.request.getPrototypeKeyBinding().getKeyInfo().set_any(new MessageElement[]{messageElement});
        }
    }

    void checkAuthentication() {
        if (this.request.getAuthentication().getNotBoundAuthentication() == null) {
            AuthenticationType authenticationType = new AuthenticationType();
            NotBoundAuthenticationType notBoundAuthenticationType = new NotBoundAuthenticationType();
            authenticationType.setNotBoundAuthentication(notBoundAuthenticationType);
            this.request.setAuthentication(authenticationType);
        }
    }

    public void setAuthenticationProtocol(String string) throws URI.MalformedURIException, InvalidValueException {
        this.checkAuthentication();
        String string2 = Translate.putAuthenticationProtocol(string);
        if (string2 == null) {
            string2 = string;
        }
        NotBoundAuthenticationType notBoundAuthenticationType = this.request.getAuthentication().getNotBoundAuthentication();
        notBoundAuthenticationType.setProtocol(new URI(string2));
    }

    public void setAuthenticationValue(String string) throws URI.MalformedURIException, InvalidValueException {
        this.checkAuthentication();
        NotBoundAuthenticationType notBoundAuthenticationType = this.request.getAuthentication().getNotBoundAuthentication();
        notBoundAuthenticationType.setValue(string);
        this.setAuthenticationProtocol("p12pincode");
    }

    public void setRespondWith(String string) throws Exception {
        String string2 = Translate.putRespondWithKm(string);
        if (string2 == null) {
            string2 = string;
        }
        if (this.request.getRespondWith() != null) {
            int n = this.request.getRespondWith().length;
            RespondWithOpenEnum[] respondWithOpenEnumArray = new RespondWithOpenEnum[n + 1];
            for (int i = 0; i < n; ++i) {
                respondWithOpenEnumArray[i] = this.request.getRespondWith(i);
            }
            respondWithOpenEnumArray[n] = new RespondWithOpenEnum();
            respondWithOpenEnumArray[n].setRespondWithEnumValue(RespondWithEnum.fromString((String)string2));
            this.request.setRespondWith(respondWithOpenEnumArray);
        } else {
            RespondWithOpenEnum respondWithOpenEnum = new RespondWithOpenEnum();
            respondWithOpenEnum.setRespondWithEnumValue(RespondWithEnum.fromString((String)string2));
            this.request.setRespondWith(new RespondWithOpenEnum[]{respondWithOpenEnum});
        }
    }

    void checkPrototypeKeyBinding() {
        if (this.request.getPrototypeKeyBinding() == null) {
            this.request.setPrototypeKeyBinding(new PrototypeKeyBindingType());
        }
    }

    public void setKeyUsage(String string) throws InvalidValueException {
        this.checkPrototypeKeyBinding();
        String string2 = Translate.putKeyUsage(string);
        if (string2 == null) {
            string2 = string;
        }
        if (this.request.getPrototypeKeyBinding().getKeyUsage() != null) {
            int n = this.request.getPrototypeKeyBinding().getKeyUsage().length;
            KeyUsageEnum[] keyUsageEnumArray = new KeyUsageEnum[n + 1];
            for (int i = 0; i < n; ++i) {
                keyUsageEnumArray[i] = this.request.getPrototypeKeyBinding().getKeyUsage(i);
            }
            keyUsageEnumArray[n] = KeyUsageEnum.fromString((String)string2);
            this.request.getPrototypeKeyBinding().setKeyUsage(keyUsageEnumArray);
        } else {
            this.request.getPrototypeKeyBinding().setKeyUsage(new KeyUsageEnum[]{KeyUsageEnum.fromString((String)string2)});
        }
    }

    public SmartRegisterResponse send() throws Exception {
        RegisterResultType registerResultType = this.bindingKm.register(this.request);
        return new SmartRegisterResponse(registerResultType);
    }

    void getRandomValue(byte[] byArray) {
        this.random.nextBytes(byArray);
    }

    String getRandomString() {
        char[] cArray = new char[10];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = chars.charAt(this.random.nextInt(chars.length()));
        }
        return new String(cArray);
    }
}

