/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import com.safelayer.trustedx.client.axis.TxHttpTransport;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartLogoutResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.www.TWS.LogoutBindingStub;
import com.safelayer.www.TWS.LogoutRequestType;
import com.safelayer.www.TWS.LogoutResponseType;
import com.safelayer.www.TWS.LogoutType;
import com.safelayer.www.TWS.TWSAALocator;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.message.MessageElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.HexBinary;
import org.apache.axis.types.NCName;
import org.apache.axis.types.URI;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.SecurityTokenReferenceType;

public class SmartLogoutRequest {
    static final boolean DEFAULT_AUTHENTICATIONREFERENCE = false;
    static final String URI_SAML_IDREF = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    private LogoutBindingStub bindingLogout;
    private LogoutRequestType request;
    private SmartHeader header;
    private String txAddress;
    private String assertion;
    Properties properties;
    private boolean authenticationReference;

    public SmartLogoutRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartLogoutRequest(String string, Properties properties) throws Exception {
        this.txAddress = string;
        this.properties = properties;
        TWSAALocator tWSAALocator = new TWSAALocator();
        tWSAALocator.setLogoutTypeEndpointAddress(string);
        LogoutType logoutType = tWSAALocator.getLogoutType();
        this.bindingLogout = (LogoutBindingStub)logoutType;
        SmartWrapperUtil.setProperties(tWSAALocator.getEngine(), properties);
        this.request = new LogoutRequestType();
        this.initDefaultValues();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public Stub getStub() {
        return this.bindingLogout;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingLogout.setHeader(smartHeader.getInternalObject());
        this.header = smartHeader;
    }

    void initDefaultValues() {
        this.setAuthenticationReference(false);
    }

    public void setEntityDn(String string) {
        this.setEntity("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", string);
    }

    public void setEntityUsername(String string) {
        this.setEntity("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", string);
    }

    void setEntity(String string, String string2) {
        NameIdentifierType nameIdentifierType = new NameIdentifierType(string2);
        try {
            nameIdentifierType.setFormat(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.request.setEntity(nameIdentifierType);
    }

    public void setAssertionIdReference(String string) {
        this.assertion = null;
        this.request.setAssertionIDReference(new NCName(string));
    }

    public void setAssertion(String string) {
        this.assertion = string;
    }

    public void setAssertionArtifact(String string) {
        this.assertion = null;
        this.request.setAssertionArtifact(string);
    }

    public void setAuthenticationReference(boolean bl) {
        this.assertion = null;
        this.authenticationReference = bl;
    }

    void fillRequest() throws Exception {
        if (this.authenticationReference) {
            MessageElement messageElement = null;
            String string = null;
            if (this.header != null) {
                MessageElement messageElement2 = this.header.getInternalObject().getRealElement();
                if (SmartWrapperUtil.getSubNode(messageElement2, "SecurityTokenReference") == null) {
                    MessageElement messageElement3 = SmartWrapperUtil.getSubNode(messageElement2, "Assertion");
                    string = messageElement3.getAttributeValue("AssertionID");
                    Iterator iterator = messageElement3.getChildElements();
                    if (iterator != null && iterator.hasNext()) {
                        messageElement = (MessageElement)iterator.next();
                    }
                    if (messageElement != null && string != null) {
                        MessageElement messageElement4 = new MessageElement();
                        messageElement4.setQName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"));
                        messageElement4.setValue(string);
                        messageElement4.addAttribute("", "ValueType", URI_SAML_IDREF);
                        SecurityTokenReferenceType securityTokenReferenceType = this.request.getSecurityTokenReference();
                        if (securityTokenReferenceType == null) {
                            securityTokenReferenceType = new SecurityTokenReferenceType();
                            this.request.setSecurityTokenReference(securityTokenReferenceType);
                        }
                        securityTokenReferenceType.set_any(new MessageElement[]{messageElement4});
                    }
                } else {
                    Object object;
                    Object object2;
                    MessageElement messageElement5 = SmartWrapperUtil.getSubNode(messageElement2, "SecurityTokenReference");
                    string = messageElement5.getAttributeValue("Id");
                    if (string == null) {
                        object2 = new Random();
                        object = new byte[10];
                        ((Random)object2).nextBytes((byte[])object);
                        string = "SecurityToken-" + HexBinary.encode((byte[])object);
                        messageElement5.setAttribute("Id", string);
                    }
                    if ((object2 = messageElement5.getChildElements()) != null && object2.hasNext()) {
                        messageElement = (MessageElement)object2.next();
                    }
                    if (messageElement != null && string != null) {
                        object = new MessageElement();
                        object.setQName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference"));
                        object.setAttribute("URI", "#" + string);
                        SecurityTokenReferenceType securityTokenReferenceType = this.request.getSecurityTokenReference();
                        if (securityTokenReferenceType == null) {
                            securityTokenReferenceType = new SecurityTokenReferenceType();
                            this.request.setSecurityTokenReference(securityTokenReferenceType);
                        }
                        securityTokenReferenceType.set_any(new MessageElement[]{(MessageElement)object});
                    }
                }
            }
        }
    }

    public SmartLogoutResponse send() throws Exception {
        String string;
        Object object;
        this.fillRequest();
        if (this.assertion == null) {
            LogoutResponseType logoutResponseType = this.bindingLogout.logout(this.request);
            Message message = this.bindingLogout._getCall().getResponseMessage();
            return new SmartLogoutResponse(logoutResponseType, message);
        }
        Service service = new Service();
        Call call = (Call)service.createCall();
        SmartWrapperUtil.setProperties(call.getMessageContext().getAxisEngine(), this.properties);
        call.setTargetEndpointAddress(new URL(this.txAddress));
        call.setUseSOAPAction(true);
        call.setSOAPActionURI("Logout");
        call.setTransport((Transport)new TxHttpTransport(call.getTargetEndpointAddress(), "Logout"));
        call.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
        call.setOperationName(new QName("", "Logout"));
        call.setEncodingStyle(null);
        String string2 = "";
        if (this.bindingLogout != null && this.bindingLogout.getHeaders() != null) {
            for (int i = 0; i < this.bindingLogout.getHeaders().length; ++i) {
                string2 = string2 + "<soap:Header>" + this.bindingLogout.getHeaders()[i].toString() + "</soap:Header>";
            }
        }
        String string3 = "<soap:Body><LogoutRequest xmlns=\"http://www.safelayer.com/TWS\">";
        if (this.request.getEntity() != null && (object = this.request.getEntity()) != null) {
            string = SmartWrapperUtil.serialize(object, object.getTypeDesc().getXmlType(), "http://www.safelayer.com/TWS", "entity", false);
            string3 = string3 + string;
        }
        string3 = string3 + this.assertion + "</LogoutRequest></soap:Body>";
        object = "<?xml version=\"1.0\"?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:me=\"http://soapinterop.org/xsd\" xmlns:this=\"http://encoding.test\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n" + string2 + string3 + "</soap:Envelope>\n";
        string = new Message(object);
        call.invoke((Message)string);
        Message message = call.getResponseMessage();
        return new SmartLogoutResponse(null, message);
    }
}

