/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPHeaderElement;
import org.w3c.dom.Element;

public class SmartHeader {
    private SOAPHeaderElement header = new SOAPHeaderElement((Name)new PrefixedQName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse"));
    static final String URI_SAML_IDREF = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    static final String URI_SAML_ARTIFACT = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionArtifact";
    static final String ASSERTION_ID_REF = "saml:AssertionIDReference";
    static final String BINDING = "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";

    public SmartHeader() {
        this.header.setMustUnderstand(true);
    }

    public SOAPHeaderElement getInternalObject() {
        return this.header;
    }

    public void setUsername(String string) throws Exception {
        MessageElement messageElement;
        MessageElement messageElement2 = SmartWrapperUtil.getSubNode(this.header.getRealElement(), "UsernameToken");
        if (messageElement2 == null) {
            messageElement2 = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
            this.header.addChild(messageElement2);
        }
        if ((messageElement = SmartWrapperUtil.getSubNode(messageElement2, "Username")) == null) {
            messageElement = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
            messageElement2.addChild(messageElement);
        }
        messageElement.setObjectValue((Object)string);
    }

    public void setPassword(String string) throws Exception {
        MessageElement messageElement;
        MessageElement messageElement2 = SmartWrapperUtil.getSubNode(this.header.getRealElement(), "UsernameToken");
        if (messageElement2 == null) {
            messageElement2 = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
            this.header.addChild(messageElement2);
        }
        if ((messageElement = SmartWrapperUtil.getSubNode(messageElement2, "Password")) == null) {
            messageElement = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
            messageElement2.addChild(messageElement);
        }
        messageElement.setObjectValue((Object)string);
        if (messageElement.getAttribute("Type") == null) {
            this.setPasswordType("clear");
        }
    }

    public void setPasswordType(String string) throws Exception {
        MessageElement messageElement;
        MessageElement messageElement2;
        String string2 = Translate.putPasswordType(string);
        if (string2 == null) {
            string2 = string;
        }
        if ((messageElement2 = SmartWrapperUtil.getSubNode(this.header.getRealElement(), "UsernameToken")) == null) {
            messageElement2 = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
            this.header.addChild(messageElement2);
        }
        if ((messageElement = SmartWrapperUtil.getSubNode(messageElement2, "Password")) == null) {
            messageElement = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
            messageElement2.addChild(messageElement);
        }
        messageElement.setAttribute("", "Type", string2);
    }

    public void setSecurityTokenReferenceUri(String string, String string2) throws Exception {
        this.header.addChild(SmartHeader.createSecurityTokenReference(string, string2, true));
    }

    public void setSecurityTokenReferenceValue(String string, String string2) throws Exception {
        this.header.addChild(SmartHeader.createSecurityTokenReference(string, string2, false));
    }

    public void setAssertionIDReference(String string) throws Exception {
        this.setSecurityTokenReferenceValue(string, URI_SAML_IDREF);
    }

    public void setAssertionArtifact(String string) throws Exception {
        this.setSecurityTokenReferenceUri(string, URI_SAML_ARTIFACT);
    }

    public void setAssertionIDRefAaBinding(String string, String string2) throws SOAPException {
        this.header.addChild(SmartHeader.createSecurityTokenReferenceSaml(string, URI_SAML_IDREF, string2));
    }

    static MessageElement createSecurityTokenReference(String string, String string2, boolean bl) throws SOAPException {
        MessageElement messageElement = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        MessageElement messageElement2 = new MessageElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference"));
        if (bl) {
            messageElement2.setAttribute("URI", string);
        } else {
            messageElement2.setValue(string);
        }
        messageElement2.addAttribute("", "ValueType", string2);
        messageElement.addChild(messageElement2);
        return messageElement;
    }

    public void setAssertion(String string) throws Exception {
        this.header.addChild(SmartHeader.createAssertion(string));
    }

    public void setSecurityTokenReferenceEmbedded(String string) throws Exception {
        this.header.addChild(SmartHeader.createSecurityTokenEmbedded(string));
    }

    static MessageElement createAssertion(String string) throws Exception {
        MessageElement messageElement = new MessageElement((Element)SmartWrapperUtil.getMessageElementFromString(string));
        return messageElement;
    }

    static MessageElement createSecurityTokenEmbedded(String string) throws Exception {
        MessageElement messageElement = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        MessageElement messageElement2 = new MessageElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Embedded"));
        MessageElement messageElement3 = new MessageElement((Element)SmartWrapperUtil.getMessageElementFromString(string));
        messageElement2.addChild(messageElement3);
        messageElement.addChild(messageElement2);
        return messageElement;
    }

    static MessageElement createSecurityTokenReferenceSaml(String string, String string2, String string3) throws SOAPException {
        MessageElement messageElement = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        MessageElement messageElement2 = new MessageElement("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorityBinding");
        messageElement2.setAttribute("AuthorityKind", ASSERTION_ID_REF);
        messageElement2.setAttribute("Binding", BINDING);
        messageElement2.setAttribute("Location", string3);
        messageElement.addChild(messageElement2);
        MessageElement messageElement3 = new MessageElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"));
        messageElement3.setValue(string);
        messageElement3.addAttribute("", "ValueType", string2);
        messageElement.addChild(messageElement3);
        return messageElement;
    }
}

