/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataResponse;
import com.safelayer.trustedx.client.smartwrapper.DssResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.SoapHeaderProcessor;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.SerializationException;
import com.safelayer.www.TWS.EncryptResponse;
import com.safelayer.www.TWS.FailedRecipientInfo;
import com.safelayer.www.TWS.SuccessRecipientInfo;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SmartEncryptResponse
extends AbstractSmartDataResponse
implements DssResponse {
    private EncryptResponse response;
    private boolean encryptionB64AsXml = false;
    private Node responseHeader;
    private Node responseBody;

    public SmartEncryptResponse(EncryptResponse encryptResponse, Hashtable hashtable, Message message) throws Exception {
        super(hashtable);
        this.response = encryptResponse;
        if (message != null) {
            this.responseHeader = SmartWrapperUtil.getXmlNode(message, "Header");
            this.responseBody = SmartWrapperUtil.getXmlBodyNode(message, "EncryptResponse");
        }
    }

    public Object getInternalObject() {
        return this.response;
    }

    public String getRequestId() {
        return this.response.getRequestID();
    }

    public Node getHeader() throws Exception {
        return this.responseHeader;
    }

    public String getTransactionId() throws Exception {
        return SoapHeaderProcessor.getTransactionId(this.getHeader());
    }

    public String getProfile() {
        if (this.response != null && this.response.getProfile() != null) {
            String string = this.response.getProfile().toString();
            String string2 = Translate.getProfileDe(string);
            if (string2 != null) {
                string = string2;
            }
            return string;
        }
        return null;
    }

    public String getResultMajor() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMajor() != null) {
            return this.response.getResult().getResultMajor().toString();
        }
        return null;
    }

    public String getResultMinor() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMinor() != null) {
            return this.response.getResult().getResultMinor().toString();
        }
        return null;
    }

    public String getResultMessage() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMessage() != null) {
            return this.response.getResult().getResultMessage().get_value();
        }
        return null;
    }

    public String getEnvelopeBase64() {
        if (this.response != null && this.response.getEnvelopedObject() != null && this.response.getEnvelopedObject().getBase64Envelope() != null) {
            return this.response.getEnvelopedObject().getBase64Envelope().toString();
        }
        return null;
    }

    public String getEnvelopeBase64Type() {
        String string;
        String string2 = null;
        if (this.response != null && this.response.getEnvelopedObject() != null && this.response.getEnvelopedObject().getBase64Envelope() != null && (string = Translate.getEnvelopeType(string2 = this.response.getEnvelopedObject().getBase64Envelope().getType().toString())) != null) {
            string2 = string;
        }
        return string2;
    }

    public String getEnvelopeMime() {
        if (this.response != null && this.response.getEnvelopedObject() != null && this.response.getEnvelopedObject().getMimeEnvelope() != null) {
            return this.response.getEnvelopedObject().getMimeEnvelope().toString();
        }
        return null;
    }

    public String getEnvelopeMimeType() {
        String string;
        String string2 = null;
        if (this.response != null && this.response.getEnvelopedObject() != null && this.response.getEnvelopedObject().getMimeEnvelope() != null && (string = Translate.getEnvelopeType(string2 = this.response.getEnvelopedObject().getMimeEnvelope().getType().toString())) != null) {
            string2 = string;
        }
        return string2;
    }

    void setEncryptionB64AsXml(boolean bl) {
        this.encryptionB64AsXml = bl;
    }

    public String getEnvelopeXmlData() throws Exception {
        MessageElement[] messageElementArray;
        if (this.encryptionB64AsXml) {
            String string = this._getEnvelopeXmlBase64();
            String string2 = new String(Base64.decode((String)string));
            if (this.isAxisPlusTag("Base64XMLEnvelope")) {
                String string3 = new String(this.getReferenceFileContent(string2, true));
                if (this.isAxisPlusTagAsBase64("Base64XMLEnvelope")) {
                    return new String(Base64.decode((String)string3));
                }
                return string3;
            }
            return string2;
        }
        if (this.response != null && this.response.getEnvelopedObject() != null && this.response.getEnvelopedObject().getXMLEnvelope() != null && (messageElementArray = this.response.getEnvelopedObject().getXMLEnvelope().get_any()) != null && messageElementArray.length > 0 && messageElementArray[0] != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(messageElementArray[0].toString().getBytes("UTF8")));
            return SmartWrapperUtil.serialize(document.getDocumentElement());
        }
        return null;
    }

    public String getEnvelopeXmlBase64() {
        String string = null;
        if (!this.encryptionB64AsXml) {
            string = this._getEnvelopeXmlBase64();
        }
        return string;
    }

    String _getEnvelopeXmlBase64() {
        if (this.response != null && this.response.getEnvelopedObject() != null && this.response.getEnvelopedObject().getBase64XMLEnvelope() != null) {
            return this.response.getEnvelopedObject().getBase64XMLEnvelope().toString();
        }
        return null;
    }

    public int getNumberSuccessRecipients() {
        int n = 0;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getSuccessRecipientInfo() != null && this.response.getOptionalOutputs().getSuccessRecipientInfo().getRecipient() != null) {
            n = this.response.getOptionalOutputs().getSuccessRecipientInfo().getRecipient().length;
        }
        return n;
    }

    public int getNumberFailedRecipients() {
        int n = 0;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getFailedRecipientInfo() != null && this.response.getOptionalOutputs().getFailedRecipientInfo().getRecipient() != null) {
            n = this.response.getOptionalOutputs().getFailedRecipientInfo().getRecipient().length;
        }
        return n;
    }

    public String getSuccessRecipientInfoXml() throws SerializationException {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getSuccessRecipientInfo() != null) {
            return SmartWrapperUtil.serialize(this.responseBody, "/dss:OptionalOutputs/css:SuccessRecipientInfo");
        }
        return null;
    }

    public String getFailedRecipientInfoXml() throws SerializationException {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getFailedRecipientInfo() != null) {
            return SmartWrapperUtil.serialize(this.responseBody, "/dss:OptionalOutputs/css:FailedRecipientInfo");
        }
        return null;
    }

    public successRecipientInfo getSuccessRecipientInfo() {
        return new successRecipientInfo();
    }

    public failedRecipientInfo getFailedRecipientInfo() {
        return new failedRecipientInfo();
    }

    public class failedRecipientInfo {
        FailedRecipientInfo recipients = null;

        public failedRecipientInfo() {
            if (SmartEncryptResponse.this.response != null && SmartEncryptResponse.this.response.getOptionalOutputs() != null && SmartEncryptResponse.this.response.getOptionalOutputs().getFailedRecipientInfo() != null) {
                this.recipients = SmartEncryptResponse.this.response.getOptionalOutputs().getFailedRecipientInfo();
            }
        }

        public String getRecipient(int n) throws SerializationException {
            return SmartWrapperUtil.serialize(SmartEncryptResponse.this.responseBody, "/dss:OptionalOutputs/css:FailedRecipientInfo/css:Recipient[" + n + "]");
        }
    }

    public class successRecipientInfo {
        SuccessRecipientInfo recipients = null;

        public successRecipientInfo() {
            if (SmartEncryptResponse.this.response != null && SmartEncryptResponse.this.response.getOptionalOutputs() != null && SmartEncryptResponse.this.response.getOptionalOutputs().getSuccessRecipientInfo() != null) {
                this.recipients = SmartEncryptResponse.this.response.getOptionalOutputs().getSuccessRecipientInfo();
            }
        }

        public String getRecipient(int n) throws SerializationException {
            return SmartWrapperUtil.serialize(SmartEncryptResponse.this.responseBody, "/dss:OptionalOutputs/css:SuccessRecipientInfo/css:Recipient(" + n + ")");
        }
    }
}

