/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartEncryptResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.www.TWS.AddEncryptedKeyInfo;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.DE.DEBindingStub;
import com.safelayer.www.TWS.DE.DigitalEncryptionType;
import com.safelayer.www.TWS.DE.TWSDELocator;
import com.safelayer.www.TWS.EncryptRequest;
import com.safelayer.www.TWS.EncryptResponse;
import com.safelayer.www.TWS.EncryptedKeyPlacement;
import com.safelayer.www.TWS.EncryptionType;
import com.safelayer.www.TWS.KeyInfoType;
import com.safelayer.www.TWS.KeySelector;
import com.safelayer.www.TWS.NodeToEncrypt;
import com.safelayer.www.TWS.NodeToEncryptFormat;
import com.safelayer.www.TWS.RecipientType;
import com.safelayer.www.TWS.Recipients;
import com.safelayer.www.TWS.SymmetricAlgorithmType;
import com.safelayer.www.TWS.SymmetricKeyInfo;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.Language;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Data;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Document;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.InputDocuments;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.w3.www._2000._09.xmldsig.X509DataType;

public class SmartEncryptRequest
extends AbstractSmartDataRequest {
    static final String DEFAULT_ENCRYPTIONTYPE = "cms";
    static final boolean DEFAULT_RECIPIENTINFOSUCCESS = false;
    static final boolean DEFAULT_RECIPIENTINFOFAILED = false;
    static final String DEFAULT_XMLADDENCRYPTEDKEYINFO = "X509IssuerSerial";
    static final String DEFAULT_XMLADDENCRYPTEDKEYINFO_WSS = "SecurityTokenReference";
    static final boolean DEFAULT_XMLRETURNBASE64 = false;
    static final String DEFAULT_XMLNODETOENCRYPT = "/";
    static final String DEFAULT_XMLNODETOENCRYPT_WSS = "/soap:Envelope/soap:Body";
    static final String DEFAULT_ENCRYPTEDKEYPLACEMENT = "/xenc:EncryptedData/ds:KeyInfo";
    static final String DEFAULT_XMLKEYXPATHFIRSTCHILDOF = "/";
    static final String URI_NAME_DN = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    static final String URI_NAME_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    static final String DEFAULT_KEYSUBJECTUSAGE = "keyEncipherment";
    static final NodeToEncryptFormat DEFAULT_NODETOENCRYPTFORMAT = NodeToEncryptFormat.CONTENT;
    private DEBindingStub bindingDe;
    private EncryptRequest request;
    private OptionalInputs optionalInputs = null;
    private InputDocuments inputDocs = null;
    private Recipients recipients = null;
    private boolean userHasCallRequestId = false;
    private String xmlFileToDelete = null;
    private boolean userHasCallXmlReturnBase64 = false;

    public SmartEncryptRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartEncryptRequest(String string, Properties properties) throws Exception {
        TWSDELocator tWSDELocator = new TWSDELocator();
        tWSDELocator.setDigitalEncryptionEndpointAddress(string);
        DigitalEncryptionType digitalEncryptionType = tWSDELocator.getDigitalEncryption();
        this.bindingDe = (DEBindingStub)digitalEncryptionType;
        SmartWrapperUtil.setProperties(tWSDELocator.getEngine(), properties);
        this.request = new EncryptRequest();
        this.initRandom();
    }

    public Stub getStub() {
        return this.bindingDe;
    }

    public Object getInternalObject() {
        return this.request;
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.setOptionalInputs(this.optionalInputs);
        }
    }

    void checkInputDocuments() {
        if (this.inputDocs == null) {
            this.inputDocs = new InputDocuments();
            this.setInputDocuments(this.inputDocs);
        }
    }

    void initDefaultCmsValues() throws InvalidValueException {
        this.setEncryptionType(DEFAULT_ENCRYPTIONTYPE);
    }

    void initDefaultXmlValues() throws InvalidValueException {
        this.setXmlReturnBase64(false);
        this.setXmlNodeToEncrypt("/");
        this.setXmlKeyXPathFirstChildOf(DEFAULT_ENCRYPTEDKEYPLACEMENT);
        this.setXmlAddEncryptedKeyInfo(DEFAULT_XMLADDENCRYPTEDKEYINFO);
    }

    void initDefaultWssValues() throws InvalidValueException {
        this.setXmlReturnBase64(false);
        this.setXmlAddEncryptedKeyInfo(DEFAULT_XMLADDENCRYPTEDKEYINFO_WSS);
    }

    public void setEncryptionType(String string) throws InvalidValueException {
        String string2 = Translate.putEncryptionType(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setEncryptionType(EncryptionType.fromValue((URI)new URI(string2)));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setProfile(String string) throws InvalidValueException, Exception {
        String string2 = Translate.putProfileDe(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            this.request.setProfile(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        if ("cmspkcs7".equals(string) || "smime".equals(string)) {
            this.initDefaultCmsValues();
        } else if ("xades".equals(string)) {
            this.initDefaultXmlValues();
        } else if ("wss".equals(string)) {
            this.initDefaultWssValues();
        }
    }

    public void setServicePolicy(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setServicePolicy(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string);
        }
    }

    public void setLanguage(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setLanguage(new Language(string));
    }

    public void setInputBase64Data(String string) throws ConfigurationException {
        this._setInputBase64Data(string, "string", "base64");
    }

    public void setSymmetricAlgorithm(String string) throws InvalidValueException {
        String string2 = Translate.putSymmetricAlgorithm(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        this.checkSymmetricKeyInfo();
        SymmetricKeyInfo symmetricKeyInfo = this.optionalInputs.getSymmetricKeyInfo();
        symmetricKeyInfo.setCEAlgorithm(SymmetricAlgorithmType.fromString((String)string2));
    }

    public void setSymmetricKeyLength(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        this.checkSymmetricKeyInfo();
        SymmetricKeyInfo symmetricKeyInfo = this.optionalInputs.getSymmetricKeyInfo();
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string);
        }
        symmetricKeyInfo.setEffectiveKeyLength(bigInteger);
    }

    public void setSymmetricKey(String string) {
        this.checkOptionalInputs();
        this.checkSymmetricKeyInfo();
        SymmetricKeyInfo symmetricKeyInfo = this.optionalInputs.getSymmetricKeyInfo();
        symmetricKeyInfo.setEncryptionKey(Base64.decode((String)string));
    }

    void checkSymmetricKeyInfo() {
        if (this.optionalInputs.getSymmetricKeyInfo() == null) {
            this.optionalInputs.setSymmetricKeyInfo(new SymmetricKeyInfo());
            this.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setInputBase64DataFile(String string, String string2) throws ConfigurationException {
        this._setInputBase64Data(string, "file", string2);
    }

    void _setInputBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        Base64Data base64Data = new Base64Data(string);
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setInputMime(String string) throws ConfigurationException {
        this._setInputMime(string, "string", "base64");
    }

    public void setInputMimeFile(String string, String string2) throws ConfigurationException {
        this._setInputMime(string, "file", string2);
    }

    void _setInputMime(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("MimeEnvelope", string2, string3);
        this.checkInputDocuments();
        this.inputDocs.setMime(new Base64Binary(string));
    }

    public void setSecurityLabel(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setSecurityLabel(string);
    }

    public void setAddRecipientInfoSuccess(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddRecipientInfoSuccess((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddRecipientInfoSuccess(null);
        }
    }

    public void setAddRecipientInfoFailed(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddRecipientInfoFailed((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddRecipientInfoFailed(null);
        }
    }

    void checkRecipients() {
        if (this.recipients == null) {
            this.recipients = new Recipients();
        }
    }

    void setRecipient(RecipientType recipientType) {
        this.checkOptionalInputs();
        this.checkRecipients();
        if (recipientType != null) {
            Recipients recipients = null;
            if (this.recipients.getRecipient() != null) {
                recipients = new Recipients(new RecipientType[this.recipients.getRecipient().length + 1]);
                for (int i = 0; i < this.recipients.getRecipient().length; ++i) {
                    recipients.setRecipient(i, this.recipients.getRecipient(i));
                }
                recipients.setRecipient(recipients.getRecipient().length - 1, recipientType);
            } else {
                recipients = new Recipients();
                recipients.setRecipient(new RecipientType[]{recipientType});
            }
            this.recipients = recipients;
        }
    }

    public void setKeyCertificate(String string) {
        RecipientType recipientType = new RecipientType();
        org.w3.www._2000._09.xmldsig.KeyInfoType keyInfoType = new org.w3.www._2000._09.xmldsig.KeyInfoType();
        X509DataType x509DataType = new X509DataType();
        keyInfoType.setX509Data(x509DataType);
        x509DataType.setX509Certificate(Base64.decode((String)string));
        recipientType.setKeyInfo(keyInfoType);
        this.setRecipient(recipientType);
    }

    public void setKeyGroup(String string) throws URI.MalformedURIException {
        RecipientType recipientType = new RecipientType();
        NameIdentifierType nameIdentifierType = new NameIdentifierType(string);
        nameIdentifierType.setFormat(new URI(URI_NAME_DN));
        nameIdentifierType.setNameQualifier("");
        recipientType.setKeyGroup(nameIdentifierType);
        this.setRecipient(recipientType);
    }

    public void setKeySubjectName(String string) {
        this.setKeySelectorName(URI_NAME_DN, string);
    }

    public void setKeyEmailAddress(String string) {
        this.setKeySelectorName(URI_NAME_EMAIL, string);
    }

    void setKeySelectorName(String string, String string2) {
        NameIdentifierType nameIdentifierType;
        RecipientType recipientType = new RecipientType();
        KeySelector keySelector = new KeySelector();
        if (keySelector == null) {
            keySelector = new KeySelector();
            recipientType.setKeySelector(keySelector);
        }
        if ((nameIdentifierType = keySelector.getName()) == null) {
            nameIdentifierType = new NameIdentifierType(string2);
            keySelector.setName(nameIdentifierType);
        }
        try {
            nameIdentifierType.setFormat(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        if (keySelector.getKeyUsage() == null) {
            keySelector.setKeyUsage(DEFAULT_KEYSUBJECTUSAGE);
        }
        recipientType.setKeySelector(keySelector);
        this.setRecipient(recipientType);
    }

    void setOptionalInputs(OptionalInputs optionalInputs) {
        this.request.setOptionalInputs(optionalInputs);
    }

    void setInputDocuments(InputDocuments inputDocuments) {
        this.request.setInputDocuments(inputDocuments);
    }

    void fillRequest() throws Exception {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
        if (this.apiShouldCallToXmlReturnBase64()) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        }
        this.optionalInputs.setRecipients(this.recipients);
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingDe.setHeader(smartHeader.getInternalObject());
    }

    public void setInputXmlData(String string) throws Exception {
        if (SmartEncryptRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64File(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw");
        } else {
            this.setInputXmlBase64(Base64.encode((byte[])string.getBytes("UTF-8")));
        }
    }

    public void setInputXmlBase64(String string) throws ConfigurationException {
        this._setInputXmlBase64(string, "string", "base64");
    }

    public void setInputXmlBase64File(String string, String string2) throws ConfigurationException {
        this._setInputXmlBase64(string, "file", string2);
    }

    void _setInputXmlBase64(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        document.setBase64XML(Base64.decode((String)string));
        this.inputDocs.setDocument(document);
    }

    public void setXmlNodeToEncrypt(String string) {
        this.checkOptionalInputs();
        NodeToEncrypt nodeToEncrypt = this.optionalInputs.getNodeToEncrypt();
        if (nodeToEncrypt != null) {
            nodeToEncrypt.setXPath(string);
        } else {
            nodeToEncrypt = new NodeToEncrypt(string, DEFAULT_NODETOENCRYPTFORMAT);
        }
        this.optionalInputs.setNodeToEncrypt(nodeToEncrypt);
    }

    public void setXmlNodeToEncrypt(String string, String string2) {
        this.checkOptionalInputs();
        NodeToEncrypt nodeToEncrypt = new NodeToEncrypt(string, NodeToEncryptFormat.fromString((String)string2));
        this.optionalInputs.setNodeToEncrypt(nodeToEncrypt);
    }

    public void setXmlNodeToEncryptFormat(String string) {
        this.checkOptionalInputs();
        NodeToEncrypt nodeToEncrypt = this.optionalInputs.getNodeToEncrypt();
        if (nodeToEncrypt != null) {
            nodeToEncrypt.setFormat(NodeToEncryptFormat.fromString((String)string));
        } else {
            nodeToEncrypt = new NodeToEncrypt("/", NodeToEncryptFormat.fromString((String)string));
        }
        this.optionalInputs.setNodeToEncrypt(nodeToEncrypt);
    }

    public void setXmlKeyXPathAfter(String string) {
        this.checkOptionalInputs();
        EncryptedKeyPlacement encryptedKeyPlacement = this.optionalInputs.getEncryptedKeyPlacement();
        if (encryptedKeyPlacement == null) {
            encryptedKeyPlacement = new EncryptedKeyPlacement();
            this.optionalInputs.setEncryptedKeyPlacement(encryptedKeyPlacement);
        }
        encryptedKeyPlacement.setXPathAfter(string);
    }

    public void setXmlKeyXPathFirstChildOf(String string) {
        this.checkOptionalInputs();
        EncryptedKeyPlacement encryptedKeyPlacement = this.optionalInputs.getEncryptedKeyPlacement();
        if (encryptedKeyPlacement == null) {
            encryptedKeyPlacement = new EncryptedKeyPlacement();
            this.optionalInputs.setEncryptedKeyPlacement(encryptedKeyPlacement);
        }
        if (string == null) {
            string = "/";
        }
        encryptedKeyPlacement.setXPathFirstChildOf(string);
    }

    public void setXmlKeyXPathBefore(String string) {
        this.checkOptionalInputs();
        EncryptedKeyPlacement encryptedKeyPlacement = this.optionalInputs.getEncryptedKeyPlacement();
        if (encryptedKeyPlacement == null) {
            encryptedKeyPlacement = new EncryptedKeyPlacement();
            this.optionalInputs.setEncryptedKeyPlacement(encryptedKeyPlacement);
        }
        encryptedKeyPlacement.setXPathBefore(string);
    }

    public void setXmlAddEncryptedKeyInfo(String string) {
        this.checkOptionalInputs();
        AddEncryptedKeyInfo addEncryptedKeyInfo = this.optionalInputs.getAddEncryptedKeyInfo();
        if (addEncryptedKeyInfo == null) {
            addEncryptedKeyInfo = new AddEncryptedKeyInfo();
            this.optionalInputs.setAddEncryptedKeyInfo(addEncryptedKeyInfo);
        }
        int n = 1;
        if (addEncryptedKeyInfo.getKeyInfoType() != null) {
            n = addEncryptedKeyInfo.getKeyInfoType().length + 1;
        }
        KeyInfoType[] keyInfoTypeArray = new KeyInfoType[n];
        if (addEncryptedKeyInfo.getKeyInfoType() != null) {
            for (int i = 0; i < addEncryptedKeyInfo.getKeyInfoType().length; ++i) {
                keyInfoTypeArray[i] = addEncryptedKeyInfo.getKeyInfoType(i);
            }
        }
        keyInfoTypeArray[n - 1] = KeyInfoType.fromString((String)string);
        addEncryptedKeyInfo.setKeyInfoType(keyInfoTypeArray);
    }

    public void setXmlReturnBase64(boolean bl) {
        this.userHasCallXmlReturnBase64 = bl;
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setReturnBase64XML(null);
        }
    }

    boolean apiShouldCallToXmlReturnBase64() {
        String string = this.getProfile();
        return !this.userHasCallXmlReturnBase64 && ("xades".equals(string) || "wss".equals(string));
    }

    String getProfile() {
        if (this.request != null && this.request.getProfile() != null) {
            String string = this.request.getProfile().toString();
            String string2 = Translate.getProfile(string);
            if (string2 != null) {
                string = string2;
            }
            return string;
        }
        return null;
    }

    public SmartEncryptResponse send() throws Exception {
        this.fillRequest();
        EncryptResponse encryptResponse = this.bindingDe.encrypt(this.request);
        Hashtable hashtable = this.getOptions();
        Object var3_3 = null;
        Message message = this.bindingDe._getCall().getResponseMessage();
        SmartEncryptResponse smartEncryptResponse = new SmartEncryptResponse(encryptResponse, hashtable, message);
        return smartEncryptResponse;
    }

    protected Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDe._getCall() != null) {
                String string = this.bindingDe._getCall().getMessageContext().getTransportName();
                TWSDELocator tWSDELocator = (TWSDELocator)this.bindingDe._getService();
                return SmartWrapperUtil.getTransportOptions(tWSDELocator.getEngine(), string);
            }
            TWSDELocator tWSDELocator = (TWSDELocator)this.bindingDe._getService();
            return tWSDELocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    protected EngineConfiguration getConfig() {
        TWSDELocator tWSDELocator = (TWSDELocator)this.bindingDe._getService();
        return tWSDELocator.getEngine().getConfig();
    }

    public void enableEnvelopeBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Envelope", "file", string);
    }

    public void enableEnvelopeMimeFile(String string) throws ConfigurationException {
        this.fileResponseTag("MimeEnvelope", "file", string);
    }

    public void enableEnvelopeXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XMLEnvelope", "file", string);
    }

    public void disableEnvelopeBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64Envelope", "string", "base64");
    }

    public void disableEnvelopeXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XMLEnvelope", "string", "base64");
    }

    public void disableEnvelopeMimeFile() throws ConfigurationException {
        this.fileResponseTag("MimeEnvelope", "string", "base64");
    }
}

