/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartDscMetadataResult;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.www.TWS.DscDigitalObject;
import com.safelayer.www.TWS.DscExportResponseType;
import java.util.Hashtable;
import org.apache.axis.encoding.Base64;
import org.w3c.dom.Node;

public class SmartDscExportResponse
extends AbstractSmartDataResponse {
    private DscExportResponseType response;
    private Node node;
    private boolean signatureB64AsXml = false;
    static String TYPE_MIME = "text/mime";
    static String TYPE_PDF = "application/pdf";

    public SmartDscExportResponse(DscExportResponseType dscExportResponseType, Hashtable hashtable, Node node) {
        super(hashtable);
        this.response = dscExportResponseType;
        this.node = node;
    }

    void setSignatureB64AsXml(boolean bl) {
        this.signatureB64AsXml = bl;
    }

    public Object getInternalObject() {
        return this.response;
    }

    public String getRequestId() {
        return this.response.getRequestID();
    }

    public String getResultMajor() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMajor() != null) {
            return this.response.getResult().getResultMajor().toString();
        }
        return null;
    }

    public String getResultMinor() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMinor() != null) {
            return this.response.getResult().getResultMinor().toString();
        }
        return null;
    }

    public String getResultMessage() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMessage() != null) {
            return this.response.getResult().getResultMessage().get_value();
        }
        return null;
    }

    public int getNumberDigitalSignatures() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDigitalSignatures() != null && this.response.getOptionalOutputs().getDigitalSignatures().getDigitalSignature() != null) {
            return this.response.getOptionalOutputs().getDigitalSignatures().getDigitalSignature().length;
        }
        return 0;
    }

    public SmartDigitalSignature getDigitalSignature(int n) throws Exception {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDigitalSignatures() != null && n < this.response.getOptionalOutputs().getDigitalSignatures().getDigitalSignature().length && this.response.getOptionalOutputs().getDigitalSignatures().getDigitalSignature(n) != null) {
            return new SmartDigitalSignature(this.response.getOptionalOutputs().getDigitalSignatures().getDigitalSignature(n), n);
        }
        return null;
    }

    public SmartDigitalDocument getDigitalDocument() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDigitalDocument() != null) {
            return new SmartDigitalDocument();
        }
        return null;
    }

    public class SmartDigitalSignature {
        DscDigitalObject ddo = null;
        int index = 0;

        public SmartDigitalSignature(DscDigitalObject dscDigitalObject, int n) {
            this.ddo = dscDigitalObject;
            this.index = n;
        }

        public SmartDscMetadataResult getMetadata() {
            if (this.ddo != null && this.ddo.getMetadata() != null) {
                return new SmartDscMetadataResult(this.ddo.getMetadata(), SmartDscExportResponse.this.node);
            }
            return null;
        }

        public String getSignatureXml() throws Exception {
            if (SmartDscExportResponse.this.signatureB64AsXml) {
                String string = this._getSignatureXmlBase64();
                if (string != null) {
                    String string2 = new String(Base64.decode((String)string));
                    if (SmartDscExportResponse.this.isAxisPlusTag("Base64XML")) {
                        String string3 = new String(SmartDscExportResponse.this.getReferenceFileContent(string2, true));
                        if (SmartDscExportResponse.this.isAxisPlusTagAsBase64("Base64XML")) {
                            return new String(Base64.decode((String)string3));
                        }
                        return string3;
                    }
                    return string2;
                }
                return null;
            }
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getSignature() != null) {
                return SmartWrapperUtil.serialize(SmartDscExportResponse.this.node, "/dss:OptionalOutputs/DigitalSignatures/css:DigitalSignature(" + this.index + ")/css:Data/dss:SignatureObject/dss:Signature");
            }
            return null;
        }

        String _getSignatureXmlBase64() {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getBase64XMLSignature() != null) {
                return this.ddo.getData().getSignatureObject().getBase64XMLSignature().toString();
            }
            return null;
        }

        public String getSignatureXmlBase64() throws Exception {
            if (!SmartDscExportResponse.this.signatureB64AsXml && this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getBase64XMLSignature() != null) {
                return this.ddo.getData().getSignatureObject().getBase64XMLSignature().toString();
            }
            return null;
        }

        public String getSignatureMime() throws Exception {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getMimeSignature() != null) {
                return this.ddo.getData().getSignatureObject().getMimeSignature().toString();
            }
            return null;
        }

        public String getSignatureMimeType() throws Exception {
            String string;
            String string2 = null;
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getMimeSignature() != null && (string = Translate.getMimeSignatureType(string2 = this.ddo.getData().getSignatureObject().getMimeSignature().getType().toString())) != null) {
                string2 = string;
            }
            return string2;
        }

        public String getSignatureBase64() throws Exception {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getBase64Signature() != null) {
                return this.ddo.getData().getSignatureObject().getBase64Signature().toString();
            }
            return null;
        }

        public String getSignatureBase64Type() throws Exception {
            String string;
            String string2 = null;
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getSignatureObject() != null && this.ddo.getData().getSignatureObject().getBase64Signature() != null && (string = Translate.getSignatureType(string2 = this.ddo.getData().getSignatureObject().getBase64Signature().getType().toString())) != null) {
                string2 = string;
            }
            return string2;
        }
    }

    public class SmartDigitalDocument {
        DscDigitalObject ddo = null;

        public SmartDigitalDocument() {
            if (SmartDscExportResponse.this.response != null && SmartDscExportResponse.this.response.getOptionalOutputs() != null && SmartDscExportResponse.this.response.getOptionalOutputs().getDigitalDocument() != null) {
                this.ddo = SmartDscExportResponse.this.response.getOptionalOutputs().getDigitalDocument();
            }
        }

        public SmartDscMetadataResult getMetadata() {
            if (this.ddo != null && this.ddo.getMetadata() != null) {
                return new SmartDscMetadataResult(this.ddo.getMetadata(), SmartDscExportResponse.this.node);
            }
            return null;
        }

        public String getDocumentBase64Data() {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getDocument() != null && this.ddo.getData().getDocument().getBase64Data() != null && !this.ddo.getData().getDocument().getBase64Data().getMimeType().equals(TYPE_MIME) && !this.ddo.getData().getDocument().getBase64Data().getMimeType().equals(TYPE_PDF)) {
                return this.ddo.getData().getDocument().getBase64Data().toString();
            }
            return null;
        }

        public String getDocumentMime() {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getDocument() != null && this.ddo.getData().getDocument().getBase64Data() != null && this.ddo.getData().getDocument().getBase64Data().getMimeType().equals(TYPE_MIME)) {
                return this.ddo.getData().getDocument().getBase64Data().toString();
            }
            return null;
        }

        public String getDocumentPdfBase64Data() {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getDocument() != null && this.ddo.getData().getDocument().getBase64Data() != null && this.ddo.getData().getDocument().getBase64Data().getMimeType().equals(TYPE_PDF)) {
                return this.ddo.getData().getDocument().getBase64Data().toString();
            }
            return null;
        }

        public String getDocumentXmlData() throws Exception {
            if (SmartDscExportResponse.this.signatureB64AsXml) {
                String string = this._getDocumentXmlBase64();
                String string2 = new String(Base64.decode((String)string));
                if (SmartDscExportResponse.this.isAxisPlusTag("Base64XML")) {
                    String string3 = new String(SmartDscExportResponse.this.getReferenceFileContent(string2, true));
                    if (SmartDscExportResponse.this.isAxisPlusTagAsBase64("Base64XML")) {
                        return new String(Base64.decode((String)string3));
                    }
                    return string3;
                }
                return string2;
            }
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getDocument() != null && this.ddo.getData().getDocument().getXMLData() != null) {
                return this.ddo.getData().getDocument().getXMLData().get_any()[0].toString();
            }
            return null;
        }

        public String getDocumentXmlBase64() throws Exception {
            if (!SmartDscExportResponse.this.signatureB64AsXml && this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getDocument() != null && this.ddo.getData().getDocument().getBase64XML() != null) {
                return Base64.encode((byte[])this.ddo.getData().getDocument().getBase64XML());
            }
            return null;
        }

        String _getDocumentXmlBase64() {
            if (this.ddo != null && this.ddo.getData() != null && this.ddo.getData().getDocument() != null && this.ddo.getData().getDocument().getBase64XML() != null) {
                return Base64.encode((byte[])this.ddo.getData().getDocument().getBase64XML());
            }
            return null;
        }
    }
}

