/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDscExportResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.DSC.DSCBindingStub;
import com.safelayer.www.TWS.DSC.DigitalSignatureCustodyType;
import com.safelayer.www.TWS.DSC.TWSDSCLocator;
import com.safelayer.www.TWS.DeleteArchiveMaterial;
import com.safelayer.www.TWS.DscExportRequestType;
import com.safelayer.www.TWS.DscExportResponseType;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.w3c.dom.Node;

public class SmartDscExportRequest
extends AbstractSmartDataRequest {
    private DscExportRequestType request;
    private DSCBindingStub bindingDsc;
    private OptionalInputs optionalInputs = null;
    private boolean userHasCallRequestId = false;
    private boolean userHasCallXmlReturnBase64 = false;

    public SmartDscExportRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartDscExportRequest(String string, Properties properties) throws Exception {
        this.initRandom();
        this.request = new DscExportRequestType();
        TWSDSCLocator tWSDSCLocator = new TWSDSCLocator();
        tWSDSCLocator.setDigitalSignatureCustodyEndpointAddress(string);
        DigitalSignatureCustodyType digitalSignatureCustodyType = tWSDSCLocator.getDigitalSignatureCustody();
        this.bindingDsc = (DSCBindingStub)digitalSignatureCustodyType;
        SmartWrapperUtil.setProperties(tWSDSCLocator.getEngine(), properties);
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setArchiveReference(String string) throws Exception {
        this.request.setArchiveReference(new URI(string));
    }

    public void setArchiveReferenceId(String string) {
        this.checkOptionalInputs();
        this.request.setArchiveReferenceID(string);
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setServicePolicy(String string) throws Exception {
        this.checkOptionalInputs();
        this.optionalInputs.setServicePolicy(new URI(string));
    }

    public void setDeleteArchiveMaterial(boolean bl) {
        this.checkOptionalInputs();
        if (bl) {
            this.optionalInputs.setDeleteArchiveMaterial(new DeleteArchiveMaterial());
        } else {
            this.optionalInputs.setDeleteArchiveMaterial(null);
        }
    }

    public void setReturnBase64Xml(boolean bl) {
        this.userHasCallXmlReturnBase64 = bl;
        this.checkOptionalInputs();
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        } else {
            this.optionalInputs.setReturnBase64XML(null);
        }
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
        if (this.apiShouldCallToXmlReturnBase64()) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        }
    }

    public SmartDscExportResponse send() throws Exception {
        this.fillRequest();
        DscExportResponseType dscExportResponseType = this.bindingDsc.export(this.request);
        Hashtable hashtable = this.getOptions();
        Node node = null;
        Message message = this.bindingDsc._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "ExportResponse");
        }
        SmartDscExportResponse smartDscExportResponse = new SmartDscExportResponse(dscExportResponseType, hashtable, node);
        if (this.apiShouldCallToXmlReturnBase64()) {
            smartDscExportResponse.setSignatureB64AsXml(true);
        }
        return smartDscExportResponse;
    }

    public void setHeader(SmartHeader smartHeader) {
        if (this.bindingDsc != null) {
            this.bindingDsc.setHeader(smartHeader.getInternalObject());
        }
    }

    boolean apiShouldCallToXmlReturnBase64() {
        return !this.userHasCallXmlReturnBase64;
    }

    protected EngineConfiguration getConfig() {
        if (this.bindingDsc != null) {
            TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
            return tWSDSCLocator.getEngine().getConfig();
        }
        return null;
    }

    protected Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDsc != null) {
                if (this.bindingDsc._getCall() != null) {
                    String string = this.bindingDsc._getCall().getMessageContext().getTransportName();
                    TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                    return SmartWrapperUtil.getTransportOptions(tWSDSCLocator.getEngine(), string);
                }
                TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                return tWSDSCLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
            }
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
        return null;
    }

    public void enableSignatureBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Signature", "file", string);
    }

    public void disableSignatureBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64Signature", "string", "base64");
    }

    public void enableSignatureMimeFile(String string) throws ConfigurationException {
        this.fileResponseTag("MimeSignature", "file", string);
    }

    public void disableSignatureMimeFile() throws ConfigurationException {
        this.fileResponseTag("MimeSignature", "string", "base64");
    }

    public void enableSignatureXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XMLSignature", "file", string);
    }

    public void disableSignatureXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XMLSignature", "string", "base64");
    }

    public void enableDocumentBase64DataFile(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Data", "file", string);
    }

    public void disableDocumentBase64DataFile() throws ConfigurationException {
        this.fileResponseTag("Base64Data", "string", "base64");
    }

    public void enableDocumentMimeFile(String string) throws ConfigurationException {
        this.fileResponseTag("Mime", "file", string);
    }

    public void disableDocumentMimeFile() throws ConfigurationException {
        this.fileResponseTag("Mime", "string", "base64");
    }

    public void enableDocumentXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XML", "file", string);
    }

    public void disableDocumentXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XML", "string", "base64");
    }
}

