/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDscArchiveResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.www.TWS.AdditionalMetadata;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.CustomMetadata;
import com.safelayer.www.TWS.DSC.DSCBindingStub;
import com.safelayer.www.TWS.DSC.DigitalSignatureCustodyType;
import com.safelayer.www.TWS.DSC.TWSDSCLocator;
import com.safelayer.www.TWS.DocumentItem;
import com.safelayer.www.TWS.DscArchiveRequestType;
import com.safelayer.www.TWS.DscArchiveResponseType;
import com.safelayer.www.TWS.MimeSignature;
import com.safelayer.www.TWS.SearchKeywords;
import com.safelayer.www.TWS.UpdateSignature;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Data;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Signature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Document;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.InputDocuments;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignatureObject;
import org.w3c.dom.Node;

public class SmartDscArchiveRequest
extends AbstractSmartDataRequest {
    static final String DEFAULT_SIGNATUREMIMETYPE = "smime3";
    static final String DEFAULT_SIGNATURETYPE = "cms";
    private DscArchiveRequestType request;
    private DSCBindingStub bindingDsc;
    private OptionalInputs optionalInputs = null;
    private InputDocuments inputDocs = null;
    private SearchKeywords searchKeywords = null;
    private String xmlFileToDelete = null;
    private String signatureFileToDelete = null;
    private boolean userHasCallRequestId = false;

    public SmartDscArchiveRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartDscArchiveRequest(String string, Properties properties) throws Exception {
        this.initRandom();
        this.request = new DscArchiveRequestType();
        TWSDSCLocator tWSDSCLocator = new TWSDSCLocator();
        tWSDSCLocator.setDigitalSignatureCustodyEndpointAddress(string);
        DigitalSignatureCustodyType digitalSignatureCustodyType = tWSDSCLocator.getDigitalSignatureCustody();
        this.bindingDsc = (DSCBindingStub)digitalSignatureCustodyType;
        SmartWrapperUtil.setProperties(tWSDSCLocator.getEngine(), properties);
    }

    public Object getInternalObject() {
        return this.request;
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    void checkInputDocuments() {
        if (this.inputDocs == null) {
            this.inputDocs = new InputDocuments();
            this.request.setInputDocuments(this.inputDocs);
        }
    }

    public void setInputDocumentReference(String string) throws Exception {
        this.checkInputDocuments();
        this.inputDocs.setDocumentReference(new URI(string));
    }

    public void setInputDocumentReferenceId(String string) {
        this.checkInputDocuments();
        this.inputDocs.setDocumentReferenceID(string);
    }

    public void setInputPdfBase64Data(String string) throws ConfigurationException {
        this._setInputPdfBase64Data(string, "string", "base64");
    }

    public void setInputPdfBase64DataFile(String string, String string2) throws ConfigurationException {
        this._setInputPdfBase64Data(string, "file", string2);
    }

    void _setInputPdfBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        Base64Data base64Data = new Base64Data(string);
        base64Data.setMimeType("application/pdf");
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setInputMime(String string) throws ConfigurationException {
        this._setInputMime(string, "string", "base64");
    }

    public void setInputMimeFile(String string, String string2) throws ConfigurationException {
        this._setInputMime(string, "file", string2);
    }

    void _setInputMime(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Mime", string2, string3);
        this.checkInputDocuments();
        this.inputDocs.setMime(new Base64Binary(string));
    }

    public void setInputBase64Data(String string) throws Exception {
        this._setInputBase64Data(string, "string", "base64");
    }

    public void setInputBase64DataFile(String string, String string2) throws Exception {
        this._setInputBase64Data(string, "file", string2);
    }

    void _setInputBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        Base64Data base64Data = new Base64Data(string);
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setInputXmlBase64(String string) throws Exception {
        this._setInputXmlBase64(string, "string", "base64", null);
    }

    public void setInputXmlBase64(String string, String string2) throws Exception {
        this._setInputXmlBase64(string, "string", "base64", string2);
    }

    public void setInputXmlBase64File(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64(string, "file", string2, string3);
    }

    public void setInputXmlBase64File(String string, String string2) throws Exception {
        this._setInputXmlBase64(string, "file", string2, null);
    }

    void _setInputXmlBase64(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() == null) {
            Document document = new Document();
            document.setBase64XML(Base64.decode((String)string));
            if (string4 != null) {
                document.setRefURI(string4);
            }
            this.inputDocs.setDocument(document);
        } else {
            Document document = this.inputDocs.getDocument();
            document.setBase64XML(Base64.decode((String)string));
            if (string4 != null) {
                document.setRefURI(string4);
            }
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputXmlData(String string) throws Exception {
        this._setInputXmlData(string, null);
    }

    public void setInputXmlData(String string, String string2) throws Exception {
        this._setInputXmlData(string, string2);
    }

    void _setInputXmlData(String string, String string2) throws Exception {
        if (SmartDscArchiveRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this._setInputXmlBase64(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "file", "raw", string2);
        } else {
            this._setInputXmlBase64(string, "string", "base64", string2);
        }
    }

    public void setInputRefUri(String string) throws URI.MalformedURIException {
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() != null) {
            Document document = this.inputDocs.getDocument();
            document.setRefURI(string);
            this.inputDocs.setDocument(document);
        } else {
            Document document = new Document();
            document.setRefURI(string);
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputXmlBase64Item(int n, String string) throws Exception {
        this._setInputXmlBase64Item(n, string, null);
    }

    public void setInputXmlBase64Item(int n, String string, String string2) throws Exception {
        this._setInputXmlBase64Item(n, string, string2);
    }

    void _setInputXmlBase64Item(int n, String string, String string2) throws Exception {
        this.fileRequestTag("Base64XML", "string", "base64");
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string2 != null) {
            documentItem.setRefURI(string2);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, null);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, string3);
    }

    void _setInputXmlBase64FileItem(int n, String string, String string2, String string3) throws Exception {
        this.fileRequestTag("Base64XML", "file", string2);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string3 != null) {
            documentItem.setRefURI(string3);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputXmlBase64Item(String string) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", null);
    }

    public void setInputXmlBase64Item(String string, String string2) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", string2);
    }

    public void setInputXmlBase64FileItem(String string, String string2) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, null);
    }

    public void setInputXmlBase64FileItem(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, string3);
    }

    void _setInputXmlBase64Item(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string4 != null) {
            documentItem.setRefURI(string4);
        }
        if (this.inputDocs.getDocumentItem() == null) {
            this._setInputDocumentItem(0, documentItem);
        } else {
            this._setInputDocumentItem(this.inputDocs.getDocumentItem().length, documentItem);
        }
    }

    public void setInputXmlDataItem(int n, String string) throws Exception {
        this._setInputXmlDataItem(n, string, null);
    }

    public void setInputXmlDataItem(int n, String string, String string2) throws Exception {
        this._setInputXmlDataItem(n, string, string2);
    }

    void _setInputXmlDataItem(int n, String string, String string2) throws Exception {
        if (SmartDscArchiveRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64FileItem(n, Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw", string2);
        } else {
            this.setInputXmlBase64Item(n, Base64.encode((byte[])string.getBytes("UTF-8")), string2);
        }
    }

    public void setInputXmlDataItem(String string) throws Exception {
        this._setInputXmlDataItem(string, null);
    }

    public void setInputXmlDataItem(String string, String string2) throws Exception {
        this._setInputXmlDataItem(string, string2);
    }

    void _setInputXmlDataItem(String string, String string2) throws Exception {
        if (SmartDscArchiveRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64FileItem(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw", string2);
        } else {
            this.setInputXmlBase64Item(Base64.encode((byte[])string.getBytes("UTF-8")), string2);
        }
    }

    public void setInputBase64DataItem(int n, String string) throws Exception {
        this._setInputBase64DataItem(n, string, null);
    }

    public void setInputBase64DataItem(int n, String string, String string2) throws Exception {
        this._setInputBase64DataItem(n, string, string2);
    }

    void _setInputBase64DataItem(int n, String string, String string2) throws Exception {
        this.fileRequestTag("Base64Data", "string", "base64");
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64Data(new Base64Data(string));
        if (string2 != null) {
            documentItem.setRefURI(string2);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputBase64DataItem(String string) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", null);
    }

    public void setInputBase64DataItem(String string, String string2) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", string2);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, null);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, string3);
    }

    void _setInputBase64DataFileItem(int n, String string, String string2, String string3) throws Exception {
        this.fileRequestTag("Base64Data", "file", string2);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64Data(new Base64Data(string));
        if (string3 != null) {
            documentItem.setRefURI(string3);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputBase64DataFileItem(String string, String string2) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, null);
    }

    public void setInputBase64DataFileItem(String string, String string2, String string3) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, string3);
    }

    void _setInputBase64DataItem(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64Data(new Base64Data(string));
        if (string4 != null) {
            documentItem.setRefURI(string4);
        }
        if (this.inputDocs.getDocumentItem() == null) {
            this._setInputDocumentItem(0, documentItem);
        } else {
            this._setInputDocumentItem(this.inputDocs.getDocumentItem().length, documentItem);
        }
    }

    void _setInputDocumentItem(int n, DocumentItem documentItem) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem2 = this.inputDocs.getDocumentItem(n);
            if (documentItem2.getRefURI() != null && documentItem.getRefURI() == null) {
                documentItem.setRefURI(documentItem2.getRefURI());
            }
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setInputRefUriItem(int n, String string) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setRefURI(string);
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem = this.inputDocs.getDocumentItem(n);
            documentItem.setRefURI(string);
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setRefURI(string);
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setSignatureXml(String string) throws Exception {
        if (SmartDscArchiveRequest.isBig(string)) {
            if (this.signatureFileToDelete != null) {
                this.removeReference(this.signatureFileToDelete);
                this.signatureFileToDelete = null;
            }
            this.signatureFileToDelete = this.setReferenceContent(string.getBytes());
            this.setSignatureXmlBase64File(Base64.encode((byte[])this.signatureFileToDelete.getBytes()), "raw");
        } else {
            this.setSignatureXmlBase64(Base64.encode((byte[])string.getBytes("UTF-8")));
        }
    }

    public void setSignatureXmlBase64File(String string, String string2) throws ConfigurationException {
        this._setSignatureXmlBase64(string, "file", string2);
    }

    void _setSignatureXmlBase64(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64XMLSignature", string2, string3);
        SignatureObject signatureObject = new SignatureObject();
        signatureObject.setBase64XMLSignature(new Base64Binary(string));
        this.request.setSignatureObject(signatureObject);
    }

    public void setSignatureBase64(String string) throws Exception {
        this._setSignatureBase64(string, "string", "base64");
    }

    public void setSignatureBase64File(String string, String string2) throws ConfigurationException {
        this._setSignatureBase64(string, "file", string2);
    }

    void _setSignatureBase64(String string, String string2, String string3) throws ConfigurationException {
        Base64Signature base64Signature;
        this.fileRequestTag("Base64Signature", string2, string3);
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((base64Signature = signatureObject.getBase64Signature()) == null) {
            base64Signature = new Base64Signature(string);
            signatureObject.setBase64Signature(base64Signature);
            try {
                this.setSignatureBase64Type(DEFAULT_SIGNATURETYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        } else {
            URI uRI = base64Signature.getType();
            if (uRI != null) {
                base64Signature = new Base64Signature(string);
                base64Signature.setType(uRI);
            } else {
                try {
                    this.setSignatureBase64Type(DEFAULT_SIGNATURETYPE);
                }
                catch (InvalidValueException invalidValueException) {
                    invalidValueException.printStackTrace();
                }
            }
            signatureObject.setBase64Signature(base64Signature);
        }
    }

    public void setSignatureXmlBase64(String string) throws Exception {
        this._setSignatureXmlBase64(string, "string", "base64");
    }

    public void setSignatureBase64Type(String string) throws InvalidValueException {
        Base64Signature base64Signature;
        URI uRI;
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((base64Signature = signatureObject.getBase64Signature()) == null) {
            base64Signature = new Base64Signature();
            signatureObject.setBase64Signature(base64Signature);
        }
        base64Signature.setType(uRI);
    }

    public void setSignatureMime(String string) throws Exception {
        this._setSignatureMime(string, "string", "base64");
    }

    public void setSignatureMimeFile(String string, String string2) throws ConfigurationException {
        this._setSignatureMime(string, "file", string2);
    }

    void _setSignatureMime(String string, String string2, String string3) throws ConfigurationException {
        MimeSignature mimeSignature;
        this.fileRequestTag("MimeSignature", string2, string3);
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((mimeSignature = signatureObject.getMimeSignature()) == null) {
            mimeSignature = new MimeSignature(string);
            signatureObject.setMimeSignature(mimeSignature);
            try {
                this.setSignatureMimeType(DEFAULT_SIGNATUREMIMETYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        } else {
            mimeSignature = new MimeSignature(string);
            URI uRI = mimeSignature.getType();
            if (uRI != null) {
                mimeSignature.setType(uRI);
            }
            signatureObject.setMimeSignature(mimeSignature);
        }
    }

    public void setSignatureMimeType(String string) throws InvalidValueException {
        MimeSignature mimeSignature;
        URI uRI;
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((mimeSignature = signatureObject.getMimeSignature()) == null) {
            mimeSignature = new MimeSignature();
            signatureObject.setMimeSignature(mimeSignature);
        }
        mimeSignature.setType(uRI);
    }

    public void setServicePolicy(String string) throws URI.MalformedURIException {
        this.checkOptionalInputs();
        this.optionalInputs.setServicePolicy(new URI(string));
    }

    public void setUpdateSignature(boolean bl) {
        this.checkOptionalInputs();
        if (bl) {
            this.optionalInputs.setUpdateSignature(new UpdateSignature());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setUpdateSignature(null);
        }
    }

    public void setRetentionPeriod(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setRetentionPeriod(string);
    }

    public void setSearchKeyword(String string) {
        this.checkOptionalInputs();
        this.checkSearchKeywords();
        if (this.searchKeywords.getSearchKeyword() != null) {
            String[] stringArray = this.searchKeywords.getSearchKeyword();
            String[] stringArray2 = new String[this.searchKeywords.getSearchKeyword().length + 1];
            for (int i = 0; i < this.searchKeywords.getSearchKeyword().length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray2[this.searchKeywords.getSearchKeyword().length] = string;
            this.searchKeywords.setSearchKeyword(stringArray2);
        } else {
            this.searchKeywords.setSearchKeyword(new String[]{string});
        }
    }

    void checkSearchKeywords() {
        if (this.searchKeywords == null) {
            this.searchKeywords = new SearchKeywords();
            this.optionalInputs.setSearchKeywords(this.searchKeywords);
        }
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    void checkAdditionalMetadata() {
        if (this.optionalInputs != null && this.request.getOptionalInputs().getAdditionalMetadata() == null) {
            this.optionalInputs.setAdditionalMetadata(new AdditionalMetadata());
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setAddCustomMetadata(String string, String string2) throws Exception {
        this.checkOptionalInputs();
        this.checkAdditionalMetadata();
        AdditionalMetadata additionalMetadata = this.optionalInputs.getAdditionalMetadata();
        CustomMetadata[] customMetadataArray = null;
        CustomMetadata customMetadata = new CustomMetadata();
        customMetadata.setName(string);
        customMetadata.setValue(string2);
        if (additionalMetadata.getCustomMetadata() == null) {
            additionalMetadata.setCustomMetadata(new CustomMetadata[]{customMetadata});
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        } else {
            customMetadataArray = additionalMetadata.getCustomMetadata();
            CustomMetadata[] customMetadataArray2 = new CustomMetadata[customMetadataArray.length + 1];
            for (int i = 0; i < customMetadataArray.length; ++i) {
                customMetadataArray2[i] = customMetadataArray[i];
            }
            customMetadataArray2[customMetadataArray.length] = customMetadata;
            additionalMetadata.setCustomMetadata(customMetadataArray2);
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        }
    }

    public void setAddCustomMetadataName(int n, String string) throws Exception {
        this.checkOptionalInputs();
        this.checkAdditionalMetadata();
        AdditionalMetadata additionalMetadata = this.optionalInputs.getAdditionalMetadata();
        CustomMetadata[] customMetadataArray = additionalMetadata.getCustomMetadata();
        if (customMetadataArray == null) {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setName(string);
            additionalMetadata.setCustomMetadata(new CustomMetadata[]{customMetadata});
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        } else if (customMetadataArray.length > n) {
            this.optionalInputs.getAdditionalMetadata().getCustomMetadata(n).setName(string);
        } else {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setName(string);
            CustomMetadata[] customMetadataArray2 = new CustomMetadata[customMetadataArray.length + 1];
            for (int i = 0; i < customMetadataArray.length; ++i) {
                customMetadataArray2[i] = customMetadataArray[i];
            }
            customMetadataArray2[customMetadataArray.length] = customMetadata;
            additionalMetadata.setCustomMetadata(customMetadataArray2);
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        }
    }

    public void setAddCustomMetadataValue(int n, String string) throws Exception {
        this.checkOptionalInputs();
        this.checkAdditionalMetadata();
        AdditionalMetadata additionalMetadata = this.optionalInputs.getAdditionalMetadata();
        CustomMetadata[] customMetadataArray = additionalMetadata.getCustomMetadata();
        if (customMetadataArray == null) {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setValue(string);
            additionalMetadata.setCustomMetadata(new CustomMetadata[]{customMetadata});
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        } else if (customMetadataArray.length > n) {
            this.optionalInputs.getAdditionalMetadata().getCustomMetadata(n).setValue(string);
        } else {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setValue(string);
            CustomMetadata[] customMetadataArray2 = new CustomMetadata[customMetadataArray.length + 1];
            for (int i = 0; i < customMetadataArray.length; ++i) {
                customMetadataArray2[i] = customMetadataArray[i];
            }
            customMetadataArray2[customMetadataArray.length] = customMetadata;
            additionalMetadata.setCustomMetadata(customMetadataArray2);
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        }
    }

    public SmartDscArchiveResponse send() throws Exception {
        this.fillRequest();
        DscArchiveResponseType dscArchiveResponseType = this.bindingDsc.archive(this.request);
        Hashtable hashtable = this.getOptions();
        Node node = null;
        Message message = this.bindingDsc._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "ArchiveResponse");
        }
        SmartDscArchiveResponse smartDscArchiveResponse = new SmartDscArchiveResponse(dscArchiveResponseType, hashtable, node);
        return smartDscArchiveResponse;
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    public void setHeader(SmartHeader smartHeader) {
        if (this.bindingDsc != null) {
            this.bindingDsc.setHeader(smartHeader.getInternalObject());
        }
    }

    protected EngineConfiguration getConfig() {
        if (this.bindingDsc != null) {
            TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
            return tWSDSCLocator.getEngine().getConfig();
        }
        return null;
    }

    protected Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDsc != null) {
                if (this.bindingDsc._getCall() != null) {
                    String string = this.bindingDsc._getCall().getMessageContext().getTransportName();
                    TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                    return SmartWrapperUtil.getTransportOptions(tWSDSCLocator.getEngine(), string);
                }
                TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                return tWSDSCLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
            }
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
        return null;
    }

    protected void finalize() {
        if (this.xmlFileToDelete != null) {
            this.removeReference(this.xmlFileToDelete);
            this.xmlFileToDelete = null;
        }
        if (this.signatureFileToDelete != null) {
            this.removeReference(this.signatureFileToDelete);
            this.signatureFileToDelete = null;
        }
    }
}

