/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDecryptResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.Base64Envelope;
import com.safelayer.www.TWS.DE.DEBindingStub;
import com.safelayer.www.TWS.DE.DigitalEncryptionType;
import com.safelayer.www.TWS.DE.TWSDELocator;
import com.safelayer.www.TWS.DecryptRequest;
import com.safelayer.www.TWS.DecryptResponse;
import com.safelayer.www.TWS.EnvelopedObject;
import com.safelayer.www.TWS.MimeEnvelope;
import com.safelayer.www.TWS.SymmetricAlgorithmType;
import com.safelayer.www.TWS.SymmetricKeyInfo;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.Language;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.AnyType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;

public class SmartDecryptRequest
extends AbstractSmartDataRequest {
    DecryptRequest request = new DecryptRequest();
    private DEBindingStub bindingDe;
    private OptionalInputs optionalInputs = null;
    private EnvelopedObject envelope = null;
    private String xmlFileToDelete = null;
    private boolean userHasCallRequestId = false;
    static final boolean DEFAULT_XMLRETURNBASE64 = false;
    static final boolean DEFAULT_XMLREMOVEENCRYPTEDKEYS = false;
    static final boolean DEFAULT_ADDSYMMETRICALGORITHM = false;
    static final boolean DEFAULT_ADDTHISRECIPIENTINFO = false;
    static final boolean DEFAULT_ADDOTHERRECIPIENTINFO = false;
    static final String DEFAULT_ENCRYPTIONTYPE = "cms";

    public SmartDecryptRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartDecryptRequest(String string, Properties properties) throws Exception {
        TWSDELocator tWSDELocator = new TWSDELocator();
        tWSDELocator.setDigitalEncryptionEndpointAddress(string);
        DigitalEncryptionType digitalEncryptionType = tWSDELocator.getDigitalEncryption();
        this.bindingDe = (DEBindingStub)digitalEncryptionType;
        SmartWrapperUtil.setProperties(tWSDELocator.getEngine(), properties);
        this.request = new DecryptRequest();
        this.initRandom();
        try {
            this.initDefaultValues();
        }
        catch (InvalidValueException invalidValueException) {
            invalidValueException.printStackTrace();
        }
    }

    public Stub getStub() {
        return this.bindingDe;
    }

    public Object getInternalObject() {
        return this.request;
    }

    void setEnvelopedObject(EnvelopedObject envelopedObject) {
        this.request.setEnvelopedObject(envelopedObject);
    }

    void setOptionalInputs(OptionalInputs optionalInputs) {
        this.request.setOptionalInputs(optionalInputs);
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.setOptionalInputs(this.optionalInputs);
        }
    }

    void checkEnvelopedObject() {
        if (this.envelope == null) {
            this.envelope = new EnvelopedObject();
            this.setEnvelopedObject(this.envelope);
        }
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingDe.setHeader(smartHeader.getInternalObject());
    }

    void initDefaultValues() throws InvalidValueException {
        this.setAddOtherRecipientInfo(false);
        this.setAddThisRecipientInfo(false);
        this.setAddSymmetricAlgorithm(false);
    }

    void initDefaultXmlValues() {
        this.setRemoveEncryptedKeys(false);
    }

    public void setProfile(String string) throws InvalidValueException, Exception {
        String string2 = Translate.putProfileDd(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            this.request.setProfile(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        if ("xades".equals(string)) {
            this.initDefaultXmlValues();
        }
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setLanguage(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setLanguage(new Language(string));
    }

    public void setServicePolicy(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setServicePolicy(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string);
        }
    }

    public void setAddThisRecipientInfo(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddThisRecipientInfo((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddThisRecipientInfo(null);
        }
    }

    public void setAddOtherRecipientInfo(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddOtherRecipientInfo((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddOtherRecipientInfo(null);
        }
    }

    public void setSymmetricAlgorithm(String string) throws InvalidValueException {
        String string2 = Translate.putSymmetricAlgorithm(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        this.checkSymmetricKeyInfo();
        SymmetricKeyInfo symmetricKeyInfo = this.optionalInputs.getSymmetricKeyInfo();
        symmetricKeyInfo.setCEAlgorithm(SymmetricAlgorithmType.fromString((String)string2));
    }

    public void setSymmetricKeyLength(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        this.checkSymmetricKeyInfo();
        SymmetricKeyInfo symmetricKeyInfo = this.optionalInputs.getSymmetricKeyInfo();
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string);
        }
        symmetricKeyInfo.setEffectiveKeyLength(bigInteger);
    }

    public void setSymmetricKey(String string) {
        this.checkOptionalInputs();
        this.checkSymmetricKeyInfo();
        SymmetricKeyInfo symmetricKeyInfo = this.optionalInputs.getSymmetricKeyInfo();
        symmetricKeyInfo.setEncryptionKey(Base64.decode((String)string));
    }

    void checkSymmetricKeyInfo() {
        if (this.optionalInputs.getSymmetricKeyInfo() == null) {
            this.optionalInputs.setSymmetricKeyInfo(new SymmetricKeyInfo());
            this.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setSecurityLabel(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setSecurityLabel(string);
    }

    public void setAddSymmetricAlgorithm(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddSymmetricAlgorithm((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddSymmetricAlgorithm(null);
        }
    }

    public void setRemoveEncryptedKeys(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setRemoveEncryptedKeys((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setRemoveEncryptedKeys(null);
        }
    }

    public void setXmlReturnBase64(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setReturnBase64XML(null);
        }
    }

    public void setEnvelopeXml(String string) throws Exception {
        if (SmartDecryptRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setEnvelopeXmlBase64File(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw");
        } else {
            this._setEnvelopeXml(string);
        }
    }

    void _setEnvelopeXml(String string) throws Exception {
        this.checkEnvelopedObject();
        MessageElement messageElement = SmartWrapperUtil.getMessageElementFromString(string);
        this.envelope.setXMLEnvelope(new AnyType(new MessageElement[]{messageElement}));
    }

    public void setEnvelopeXmlBase64File(String string, String string2) throws ConfigurationException {
        this._setEnvelopeXmlBase64(string, "file", string2);
    }

    public void setEnvelopeXmlBase64(String string) throws ConfigurationException {
        this._setEnvelopeXmlBase64(string, "string", "base64");
    }

    void _setEnvelopeXmlBase64(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64XMLEnvelope", string2, string3);
        this.checkEnvelopedObject();
        Base64Binary base64Binary = new Base64Binary(string);
        this.envelope.setBase64XMLEnvelope(base64Binary);
    }

    public void setEnvelopeBase64(String string) throws ConfigurationException, URI.MalformedURIException {
        this._setEnvelopeBase64(string, "string", "base64");
    }

    public void setEnvelopeBase64File(String string, String string2) throws ConfigurationException, URI.MalformedURIException {
        this._setEnvelopeBase64(string, "file", string2);
    }

    void _setEnvelopeBase64(String string, String string2, String string3) throws ConfigurationException, URI.MalformedURIException {
        this.fileRequestTag("Base64Envelope", string2, string3);
        this.checkEnvelopedObject();
        Base64Envelope base64Envelope = new Base64Envelope(string);
        this.envelope.setBase64Envelope(base64Envelope);
        this.setEnvelopeBase64Type(DEFAULT_ENCRYPTIONTYPE);
    }

    public void setEnvelopeMimeBase64(String string) throws ConfigurationException, URI.MalformedURIException {
        this._setEnvelopeMimeBase64(string, "string", "base64");
    }

    public void setEnvelopeMimeBase64File(String string, String string2) throws ConfigurationException, URI.MalformedURIException {
        this._setEnvelopeMimeBase64(string, "file", string2);
    }

    void _setEnvelopeMimeBase64(String string, String string2, String string3) throws ConfigurationException, URI.MalformedURIException {
        this.fileRequestTag("MimeEnvelope", string2, string3);
        this.checkEnvelopedObject();
        MimeEnvelope mimeEnvelope = new MimeEnvelope(string);
        this.envelope.setMimeEnvelope(mimeEnvelope);
        this.setEnvelopeMimeBase64Type(DEFAULT_ENCRYPTIONTYPE);
    }

    public void setEnvelopeBase64Type(String string) throws URI.MalformedURIException {
        this.checkEnvelopedObject();
        String string2 = Translate.putEnvelopeTypeDd(string);
        if (string2 == null) {
            string2 = string;
        }
        this.envelope.getBase64Envelope().setType(new URI(string2));
    }

    public void setEnvelopeMimeBase64Type(String string) throws URI.MalformedURIException {
        this.checkEnvelopedObject();
        String string2 = Translate.getEnvelopeTypeDd(string);
        if (string2 == null) {
            string2 = string;
        }
        this.envelope.getMimeEnvelope().setType(new URI(string2));
    }

    public SmartDecryptResponse send() throws Exception {
        this.fillRequest();
        DecryptResponse decryptResponse = this.bindingDe.decrypt(this.request);
        Hashtable hashtable = this.getOptions();
        Object var3_3 = null;
        Message message = this.bindingDe._getCall().getResponseMessage();
        SmartDecryptResponse smartDecryptResponse = new SmartDecryptResponse(decryptResponse, hashtable, message);
        return smartDecryptResponse;
    }

    void fillRequest() throws Exception {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    protected Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDe._getCall() != null) {
                String string = this.bindingDe._getCall().getMessageContext().getTransportName();
                TWSDELocator tWSDELocator = (TWSDELocator)this.bindingDe._getService();
                return SmartWrapperUtil.getTransportOptions(tWSDELocator.getEngine(), string);
            }
            TWSDELocator tWSDELocator = (TWSDELocator)this.bindingDe._getService();
            return tWSDELocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    protected EngineConfiguration getConfig() {
        TWSDELocator tWSDELocator = (TWSDELocator)this.bindingDe._getService();
        return tWSDELocator.getEngine().getConfig();
    }

    public void enableEnvelopeBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Data", "file", string);
    }

    public void disableEnvelopeBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64Data", "string", "base64");
    }

    public void enableEnvelopeMimeBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Mime", "file", string);
    }

    public void disableEnvelopeMimeBase64File() throws ConfigurationException {
        this.fileResponseTag("Mime", "string", "base64");
    }

    public void enableEnvelopeXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XML", "file", string);
    }

    public void disableEnvelopeXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XML", "string", "base64");
    }
}

