/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import assertion._0._1.SAML.tc.names.oasis.ActionType;
import assertion._0._1.SAML.tc.names.oasis.EvidenceType;
import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import assertion._0._1.SAML.tc.names.oasis.SubjectType;
import com.safelayer.trustedx.client.axis.TxHttpTransport;
import com.safelayer.trustedx.client.smartwrapper.SmartAuthZResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.www.TWS.SamlProtocolBindingStub;
import com.safelayer.www.TWS.SamlProtocolType;
import com.safelayer.www.TWS.TWSAALocator;
import java.net.URL;
import java.util.Properties;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.HexBinary;
import org.apache.axis.types.Id;
import org.apache.axis.types.NCName;
import org.apache.axis.types.URI;
import org.w3c.dom.Node;
import protocol._0._1.SAML.tc.names.oasis.AuthorizationDecisionQueryType;
import protocol._0._1.SAML.tc.names.oasis.RequestType;
import protocol._0._1.SAML.tc.names.oasis.ResponseType;

public class SmartAuthZRequest {
    private SamlProtocolBindingStub bindingSamlP;
    private RequestType request;
    private boolean userHasCallRequestId = false;
    private Random random;
    private String assertion;
    private String txAddress;
    private Properties properties;

    public SmartAuthZRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartAuthZRequest(String string, Properties properties) throws Exception {
        this.txAddress = string;
        this.properties = properties;
        TWSAALocator tWSAALocator = new TWSAALocator();
        tWSAALocator.setSamlProtocolTypeEndpointAddress(string);
        SamlProtocolType samlProtocolType = tWSAALocator.getSamlProtocolType();
        this.bindingSamlP = (SamlProtocolBindingStub)samlProtocolType;
        SmartWrapperUtil.setProperties(tWSAALocator.getEngine(), properties);
        this.request = new RequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSamlP.setHeader(smartHeader.getInternalObject());
    }

    AuthorizationDecisionQueryType checkAuthorizationDecisionQuery() {
        AuthorizationDecisionQueryType authorizationDecisionQueryType = this.request.getAuthorizationDecisionQuery();
        if (authorizationDecisionQueryType == null) {
            authorizationDecisionQueryType = new AuthorizationDecisionQueryType();
            this.request.setAuthorizationDecisionQuery(authorizationDecisionQueryType);
        }
        return authorizationDecisionQueryType;
    }

    public void setRequestId(String string) {
        this.request.setRequestID(new Id("_" + string));
        this.userHasCallRequestId = true;
    }

    public void setResource(String string) throws InvalidValueException {
        try {
            this.checkAuthorizationDecisionQuery().setResource(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setAction(String string) {
        this.checkAuthorizationDecisionQuery().setAction(new ActionType[]{new ActionType(string)});
    }

    public void setSubjectDn(String string) {
        this.setSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", string);
    }

    public void setSubjectUsername(String string) {
        this.setSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", string);
    }

    void setSubject(String string, String string2) {
        NameIdentifierType nameIdentifierType = new NameIdentifierType(string2);
        try {
            nameIdentifierType.setFormat(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        AuthorizationDecisionQueryType authorizationDecisionQueryType = this.checkAuthorizationDecisionQuery();
        SubjectType subjectType = authorizationDecisionQueryType.getSubject();
        if (subjectType == null) {
            subjectType = new SubjectType();
            authorizationDecisionQueryType.setSubject(subjectType);
        }
        subjectType.setNameIdentifier(nameIdentifierType);
    }

    public void setAssertionIdReference(String string) {
        this.assertion = null;
        AuthorizationDecisionQueryType authorizationDecisionQueryType = this.checkAuthorizationDecisionQuery();
        EvidenceType evidenceType = authorizationDecisionQueryType.getEvidence();
        if (evidenceType == null) {
            evidenceType = new EvidenceType();
            authorizationDecisionQueryType.setEvidence(evidenceType);
        }
        evidenceType.setAssertionIDReference(new NCName(string));
    }

    public void setAssertion(String string) {
        this.assertion = string;
    }

    synchronized void initRandom() {
        this.random = new Random();
    }

    synchronized void getRandomValue(byte[] byArray) {
        this.random.nextBytes(byArray);
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            byte[] byArray = new byte[10];
            this.getRandomValue(byArray);
            this.setRequestId(HexBinary.encode((byte[])byArray));
            this.userHasCallRequestId = false;
        }
    }

    public SmartAuthZResponse send() throws Exception {
        String string;
        Object object;
        this.fillRequest();
        if (this.assertion == null) {
            ResponseType responseType = this.bindingSamlP.samlProtocol(this.request);
            Node node = null;
            Message message = this.bindingSamlP._getCall().getResponseMessage();
            if (message != null) {
                node = SmartWrapperUtil.getXmlBodyNode(message, "Response");
            }
            return new SmartAuthZResponse(responseType, node);
        }
        Service service = new Service();
        Call call = (Call)service.createCall();
        SmartWrapperUtil.setProperties(call.getMessageContext().getAxisEngine(), this.properties);
        call.setTargetEndpointAddress(new URL(this.txAddress));
        call.setUseSOAPAction(true);
        call.setSOAPActionURI("AuthZ");
        call.setTransport((Transport)new TxHttpTransport(call.getTargetEndpointAddress(), "AuthZ"));
        call.setOperationName(new QName("", "AuthZ"));
        call.setEncodingStyle(null);
        call.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
        String string2 = "";
        if (this.bindingSamlP != null && this.bindingSamlP.getHeaders() != null) {
            for (int i = 0; i < this.bindingSamlP.getHeaders().length; ++i) {
                string2 = string2 + "<soap:Header>" + this.bindingSamlP.getHeaders()[i].toString() + "</soap:Header>";
            }
        }
        String string3 = "<soap:Body><Request xmlns='urn:oasis:names:tc:SAML:1.0:protocol'";
        if (this.request.getRequestID() != null) {
            string3 = string3 + " RequestID='" + this.request.getRequestID() + "'";
        }
        string3 = string3 + "><AuthorizationDecisionQuery xmlns:ns1='urn:oasis:names:tc:SAML:1.0:protocol'";
        if (this.request.getAuthorizationDecisionQuery() != null && this.request.getAuthorizationDecisionQuery().getResource() != null) {
            string3 = string3 + " Resource='" + this.request.getAuthorizationDecisionQuery().getResource().toString() + "'";
        }
        string3 = string3 + " xsi:type='ns1:AuthorizationDecisionQueryType'>";
        if (this.request.getAuthorizationDecisionQuery() != null) {
            if (this.request.getAuthorizationDecisionQuery().getSubject() != null && (object = this.request.getAuthorizationDecisionQuery().getSubject().getNameIdentifier()) != null) {
                string = SmartWrapperUtil.serialize(object, object.getTypeDesc().getXmlType(), "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier", false);
                string3 = string3 + "<ns2:Subject xmlns:ns2='urn:oasis:names:tc:SAML:1.0:assertion'>" + string + "</ns2:Subject>";
            }
            if (this.request.getAuthorizationDecisionQuery().getAction() != null && this.request.getAuthorizationDecisionQuery().getAction().length >= 1 && this.request.getAuthorizationDecisionQuery().getAction(0) != null) {
                string3 = string3 + "<ns3:Action xmlns:ns3='urn:oasis:names:tc:SAML:1.0:assertion' xsi:type='ns3:ActionType'>" + this.request.getAuthorizationDecisionQuery().getAction(0).get_value() + "</ns3:Action>";
            }
        }
        string3 = string3 + "<ns4:Evidence xmlns:ns4='urn:oasis:names:tc:SAML:1.0:assertion' xsi:type='ns4:EvidenceType'>" + this.assertion + "</ns4:Evidence>" + "</AuthorizationDecisionQuery>" + "</Request>" + "</soap:Body>";
        object = "<?xml version=\"1.0\"?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:me=\"http://soapinterop.org/xsd\" xmlns:this=\"http://encoding.test\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n" + string2 + string3 + "</soap:Envelope>\n";
        string = new Message(object);
        call.invoke((Message)string);
        Node node = null;
        Message message = call.getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "Response");
        }
        return new SmartAuthZResponse(null, node);
    }
}

