/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import com.safelayer.trustedx.client.smartwrapper.SmartAuthNResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidOrderException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.trustedx.client.smartwrapper.exception.ParserException;
import com.safelayer.www.TWS.AgentAuthNData;
import com.safelayer.www.TWS.AuthNBindingStub;
import com.safelayer.www.TWS.AuthNRequestType;
import com.safelayer.www.TWS.AuthNResponseType;
import com.safelayer.www.TWS.AuthNType;
import com.safelayer.www.TWS.Credentials;
import com.safelayer.www.TWS.DirectType;
import com.safelayer.www.TWS.TWSAALocator;
import java.net.URI;
import java.util.Properties;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.AttributedString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.BinarySecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.EncodedString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.PasswordString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.SecurityTokenReferenceType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.UsernameTokenType;

public class SmartAuthNRequest {
    static final String DEFAULT_RESPONDWITH = "assertion";
    static final String DEFAULT_REQUESTTYPE = "agent";
    static final boolean DEFAULT_AUTHORITATIVE = false;
    static final String DEFAULT_PASSWORDTYPE = "clear";
    static final String BINARY_SECURITY_TOKEN_CERT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    static final String BINARY_SECURITY_TOKEN_SIGN = "urn:ietf:rfc:3369";
    static final String HMAC_ALG = "HmacSHA1";
    AuthNBindingStub bindingAuthN;
    AuthNRequestType request;
    String secret;
    byte[] randBytes = new byte[20];
    String created;
    String agentId;
    String ipAddress;
    String host;
    int port;

    public SmartAuthNRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartAuthNRequest(String string, Properties properties) throws Exception {
        URI uRI = new URI(string);
        this.host = uRI.getHost();
        this.port = uRI.getPort();
        TWSAALocator tWSAALocator = new TWSAALocator();
        tWSAALocator.setAuthNTypeEndpointAddress(string);
        AuthNType authNType = tWSAALocator.getAuthNType();
        this.bindingAuthN = (AuthNBindingStub)authNType;
        SmartWrapperUtil.setProperties(tWSAALocator.getEngine(), properties);
        this.request = new AuthNRequestType();
        try {
            this.initDefaultValues();
        }
        catch (InvalidValueException invalidValueException) {
            invalidValueException.printStackTrace();
        }
    }

    public Object getInternalObject() {
        return this.request;
    }

    public Stub getStub() {
        return this.bindingAuthN;
    }

    public Service getService() {
        return this.bindingAuthN._getService();
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingAuthN.setHeader(smartHeader.getInternalObject());
    }

    void initDefaultValues() throws InvalidValueException {
        this.setRequestType(DEFAULT_REQUESTTYPE);
        this.setRespondWith(DEFAULT_RESPONDWITH);
        this.setIpAddress();
        try {
            this.setAuthoritative(false);
        }
        catch (InvalidOrderException invalidOrderException) {
            invalidOrderException.printStackTrace();
        }
    }

    public void setEntityDn(String string) {
        this.setEntity("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", string);
    }

    public void setEntityUsername(String string) {
        this.setEntity("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", string);
    }

    void setEntity(String string, String string2) {
        NameIdentifierType nameIdentifierType = new NameIdentifierType(string2);
        try {
            nameIdentifierType.setFormat(new org.apache.axis.types.URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.request.setEntity(nameIdentifierType);
    }

    public void setPolicy(String string) throws InvalidValueException {
        org.apache.axis.types.URI uRI;
        try {
            uRI = new org.apache.axis.types.URI(string);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        if (this.request.getAgent() != null) {
            this.request.getAgent().setAuthPolicy(uRI);
        } else if (this.request.getDirect() != null) {
            this.request.getDirect().setAuthPolicy(uRI);
        }
    }

    public void setRespondWith(String string) throws InvalidValueException {
        String string2 = Translate.putRespondWith(string);
        if (string2 == null) {
            string2 = string;
        }
        String string3 = "";
        String string4 = string2;
        if (string2.indexOf(58) != -1) {
            string3 = string2.substring(0, string2.indexOf(58));
            string4 = string2.substring(string2.indexOf(58) + 1);
        }
        QName qName = new QName(string3, string4);
        if (this.request.getAgent() != null) {
            this.request.getAgent().setRespondWith(qName);
        } else if (this.request.getDirect() != null) {
            this.request.getDirect().setRespondWith(qName);
        }
    }

    public void setRequestType(String string) throws InvalidValueException {
        if (DEFAULT_REQUESTTYPE.equals(string)) {
            this.request.setDirect(null);
            if (this.request.getAgent() == null) {
                this.request.setAgent(new AgentAuthNData());
            }
            this.setRand();
            this.setCreated();
        } else if ("direct".equals(string)) {
            this.request.setAgent(null);
            if (this.request.getDirect() == null) {
                this.request.setDirect(new DirectType());
            }
        } else {
            throw new InvalidValueException(string);
        }
    }

    public void setAgentId(String string) throws InvalidOrderException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        this.request.getAgent().setAgentId(string);
        this.agentId = string;
    }

    public void setSecret(String string) throws InvalidOrderException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        this.secret = string;
    }

    void setIpAddress() {
        try {
            this.setIpAddress(SmartWrapperUtil.getIpAddress(this.host, this.port));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setIpAddress(String string) throws InvalidOrderException, InvalidValueException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        if (string == null) {
            throw new InvalidValueException(string);
        }
        this.request.getAgent().setIpAddr(string);
        this.ipAddress = string;
    }

    public void setMethod(String string) throws InvalidOrderException, InvalidValueException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        try {
            this.request.getAgent().setAuthMethod(new org.apache.axis.types.URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setAuthoritative(boolean bl) throws InvalidOrderException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        this.request.getAgent().setAuthoritative(new Boolean(bl));
    }

    public void setUsernameTokenUsername(String string) throws InvalidOrderException {
        UsernameTokenType usernameTokenType;
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        Credentials credentials = this.request.getAgent().getCredentials();
        if (credentials == null) {
            credentials = new Credentials();
            this.request.getAgent().setCredentials(credentials);
        }
        if ((usernameTokenType = credentials.getUsernameToken()) == null) {
            usernameTokenType = new UsernameTokenType();
            credentials.setUsernameToken(usernameTokenType);
        }
        usernameTokenType.setUsername(new AttributedString(string));
    }

    public void setUsernameTokenPassword(String string) throws InvalidOrderException {
        PasswordString passwordString;
        UsernameTokenType usernameTokenType;
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        Credentials credentials = this.request.getAgent().getCredentials();
        if (credentials == null) {
            credentials = new Credentials();
            this.request.getAgent().setCredentials(credentials);
        }
        if ((usernameTokenType = credentials.getUsernameToken()) == null) {
            usernameTokenType = new UsernameTokenType();
            credentials.setUsernameToken(usernameTokenType);
        }
        if ((passwordString = usernameTokenType.getPassword()) == null) {
            passwordString = new PasswordString(string);
            usernameTokenType.setPassword(passwordString);
            try {
                this.setUsernameTokenPwdType(DEFAULT_PASSWORDTYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
            catch (InvalidOrderException invalidOrderException) {
                invalidOrderException.printStackTrace();
            }
        } else {
            passwordString.set_value(new AttributedString(string));
        }
    }

    public void setUsernameTokenPwdType(String string) throws InvalidOrderException, InvalidValueException {
        PasswordString passwordString;
        UsernameTokenType usernameTokenType;
        org.apache.axis.types.URI uRI;
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        String string2 = Translate.putPasswordType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new org.apache.axis.types.URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        Credentials credentials = this.request.getAgent().getCredentials();
        if (credentials == null) {
            credentials = new Credentials();
            this.request.getAgent().setCredentials(credentials);
        }
        if ((usernameTokenType = credentials.getUsernameToken()) == null) {
            usernameTokenType = new UsernameTokenType();
            credentials.setUsernameToken(usernameTokenType);
        }
        if ((passwordString = usernameTokenType.getPassword()) == null) {
            passwordString = new PasswordString();
            usernameTokenType.setPassword(passwordString);
        }
        passwordString.setType(uRI);
    }

    public void setBinarySecurityTokenCert(String string) throws InvalidOrderException {
        this.setBinarySecurityToken(string, BINARY_SECURITY_TOKEN_CERT);
    }

    public void setBinarySecurityTokenSign(String string) throws InvalidOrderException {
        this.setBinarySecurityToken(string, BINARY_SECURITY_TOKEN_SIGN);
    }

    void setBinarySecurityToken(String string, String string2) throws InvalidOrderException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        Credentials credentials = this.request.getAgent().getCredentials();
        if (credentials == null) {
            credentials = new Credentials();
            this.request.getAgent().setCredentials(credentials);
        }
        EncodedString encodedString = new EncodedString(string);
        BinarySecurityTokenType binarySecurityTokenType = credentials.getBinarySecurityToken();
        if (binarySecurityTokenType == null) {
            binarySecurityTokenType = new BinarySecurityTokenType(encodedString);
            credentials.setBinarySecurityToken(binarySecurityTokenType);
        } else {
            binarySecurityTokenType.set_value(encodedString);
        }
        try {
            binarySecurityTokenType.setValueType(new org.apache.axis.types.URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
    }

    public void setSecurityTokenReferenceXmlSign(String string) throws ParserException, InvalidOrderException {
        if (this.request.getAgent() == null) {
            throw new InvalidOrderException("setRequestType");
        }
        Credentials credentials = this.request.getAgent().getCredentials();
        if (credentials == null) {
            credentials = new Credentials();
            this.request.getAgent().setCredentials(credentials);
        }
        SecurityTokenReferenceType securityTokenReferenceType = new SecurityTokenReferenceType();
        MessageElement messageElement = SmartWrapperUtil.getMessageElementFromString(string);
        securityTokenReferenceType.set_any(new MessageElement[]{messageElement});
        credentials.setSecurityTokenReference(securityTokenReferenceType);
    }

    void setRand() {
        if (this.request.getAgent() != null) {
            Random random = new Random();
            random.nextBytes(this.randBytes);
            this.request.getAgent().setRand(this.randBytes);
        }
    }

    void setCreated() {
        this.created = new Long(System.currentTimeMillis()).toString();
        this.request.getAgent().setCreated(this.created);
    }

    void setAuth() throws Exception {
        if (this.agentId == null) {
            throw new InvalidOrderException("setAgentId");
        }
        if (this.secret == null) {
            throw new InvalidOrderException("setSecret");
        }
        if (this.request.getAgent() != null) {
            this.request.getAgent().setAuth(SmartAuthNRequest.calculateHMAC(this.agentId, this.randBytes, this.created, this.ipAddress, this.secret));
        }
    }

    static byte[] calculateHMAC(String string, byte[] byArray, String string2, String string3, String string4) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(Base64.decode((String)string4), HMAC_ALG);
        Mac mac = Mac.getInstance(HMAC_ALG);
        mac.init(secretKeySpec);
        mac.update(string.getBytes());
        mac.update(Base64.encode((byte[])byArray).getBytes());
        mac.update(string2.getBytes());
        mac.update(string3.getBytes());
        return mac.doFinal();
    }

    void fillRequest() throws Exception {
        if (this.request.getAgent() != null) {
            this.setAuth();
        }
    }

    public SmartAuthNResponse send() throws Exception {
        this.fillRequest();
        AuthNResponseType authNResponseType = this.bindingAuthN.authN(this.request);
        Message message = this.bindingAuthN._getCall().getResponseMessage();
        return new SmartAuthNResponse(authNResponseType, message);
    }
}

