/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import assertion._0._1.SAML.tc.names.oasis.AttributeDesignatorType;
import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import assertion._0._1.SAML.tc.names.oasis.SubjectType;
import com.safelayer.trustedx.client.smartwrapper.SmartAttributeQueryResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.www.TWS.SamlProtocolBindingStub;
import com.safelayer.www.TWS.SamlProtocolType;
import com.safelayer.www.TWS.TWSAALocator;
import java.util.Properties;
import java.util.Random;
import org.apache.axis.Message;
import org.apache.axis.types.HexBinary;
import org.apache.axis.types.Id;
import org.apache.axis.types.URI;
import org.w3c.dom.Node;
import protocol._0._1.SAML.tc.names.oasis.AttributeQueryType;
import protocol._0._1.SAML.tc.names.oasis.RequestType;
import protocol._0._1.SAML.tc.names.oasis.ResponseType;

public class SmartAttributeQueryRequest {
    private SamlProtocolBindingStub bindingSamlP;
    private RequestType request;
    private boolean userHasCallRequestId = false;
    private Random random;

    public SmartAttributeQueryRequest(String string) throws Exception {
        this(string, SmartWrapperUtil.getProperties());
    }

    public SmartAttributeQueryRequest(String string, Properties properties) throws Exception {
        TWSAALocator tWSAALocator = new TWSAALocator();
        tWSAALocator.setSamlProtocolTypeEndpointAddress(string);
        SamlProtocolType samlProtocolType = tWSAALocator.getSamlProtocolType();
        this.bindingSamlP = (SamlProtocolBindingStub)samlProtocolType;
        SmartWrapperUtil.setProperties(tWSAALocator.getEngine(), properties);
        this.request = new RequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSamlP.setHeader(smartHeader.getInternalObject());
    }

    public void setRequestId(String string) {
        this.request.setRequestID(new Id("_" + string));
        this.userHasCallRequestId = true;
    }

    public void setSubjectDn(String string) {
        this.setSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", string);
    }

    public void setSubjectUsername(String string) {
        this.setSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", string);
    }

    void checkAttributeQuery() {
        if (this.request.getAttributeQuery() == null) {
            this.request.setAttributeQuery(new AttributeQueryType());
        }
    }

    void setSubject(String string, String string2) {
        NameIdentifierType nameIdentifierType = new NameIdentifierType(string2);
        try {
            nameIdentifierType.setFormat(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.checkAttributeQuery();
        SubjectType subjectType = this.request.getAttributeQuery().getSubject();
        if (subjectType == null) {
            subjectType = new SubjectType();
            this.request.getAttributeQuery().setSubject(subjectType);
        }
        subjectType.setNameIdentifier(nameIdentifierType);
    }

    public void setAttributeDesignator(String string) throws URI.MalformedURIException {
        this.checkAttributeQuery();
        AttributeDesignatorType attributeDesignatorType = new AttributeDesignatorType();
        String string2 = null;
        String string3 = null;
        if (string.startsWith("{")) {
            string2 = string.substring(string.indexOf("{") + 1, string.indexOf("}"));
            string3 = string.substring(string.indexOf("}") + 1, string.length());
        } else {
            string2 = "";
            string3 = string;
        }
        attributeDesignatorType.setAttributeNamespace(new URI(string2));
        attributeDesignatorType.setAttributeName(string3);
        if (this.request.getAttributeQuery().getAttributeDesignator() == null) {
            this.request.getAttributeQuery().setAttributeDesignator(new AttributeDesignatorType[]{attributeDesignatorType});
        } else {
            AttributeDesignatorType[] attributeDesignatorTypeArray = this.request.getAttributeQuery().getAttributeDesignator();
            AttributeDesignatorType[] attributeDesignatorTypeArray2 = new AttributeDesignatorType[attributeDesignatorTypeArray.length + 1];
            for (int i = 0; i < attributeDesignatorTypeArray.length; ++i) {
                attributeDesignatorTypeArray2[i] = attributeDesignatorTypeArray[i];
            }
            attributeDesignatorTypeArray2[attributeDesignatorTypeArray.length] = attributeDesignatorType;
            this.request.getAttributeQuery().setAttributeDesignator(attributeDesignatorTypeArray2);
        }
    }

    public SmartAttributeQueryResponse send() throws Exception {
        this.fillRequest();
        ResponseType responseType = this.bindingSamlP.samlProtocol(this.request);
        Node node = null;
        Message message = this.bindingSamlP._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "Response");
        }
        return new SmartAttributeQueryResponse(responseType, node);
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            byte[] byArray = new byte[10];
            this.getRandomValue(byArray);
            this.setRequestId(HexBinary.encode((byte[])byArray));
            this.userHasCallRequestId = false;
        }
    }

    synchronized void initRandom() {
        this.random = new Random();
    }

    synchronized void getRandomValue(byte[] byArray) {
        this.random.nextBytes(byArray);
    }
}

