/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SflySslSocketFactory
extends SSLSocketFactory {
    private ArrayList<String> DISABLED_PROTOCOLS = new ArrayList<String>(Arrays.asList("SSLv2Hello", "SSLv3"));
    private ArrayList<String> ENABLED_PROTOCOLS = new ArrayList<String>(Arrays.asList("TLSv1.1", "TLSv1.2"));
    private SSLSocketFactory sslSocketFactory;
    private boolean enableTls10;

    public SflySslSocketFactory(boolean bl) {
        this((SSLSocketFactory)SSLSocketFactory.getDefault(), bl);
    }

    public SflySslSocketFactory(SSLSocketFactory sSLSocketFactory, boolean bl) {
        this.sslSocketFactory = sSLSocketFactory;
        this.enableTls10 = bl;
        this.initProtocolLists();
    }

    private void initProtocolLists() {
        if (this.enableTls10) {
            this.ENABLED_PROTOCOLS.add(0, "TLSv1");
        } else {
            this.DISABLED_PROTOCOLS.add("TLSv1");
        }
    }

    public static SocketFactory getDefault() {
        return new SflySslSocketFactory(false);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, string, n, bl);
        this.configureProtocols(sSLSocket);
        return sSLSocket;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket();
        this.configureProtocols(sSLSocket);
        return sSLSocket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(inetAddress, n);
        this.configureProtocols(sSLSocket);
        return sSLSocket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(inetAddress, n, inetAddress2, n2);
        this.configureProtocols(sSLSocket);
        return sSLSocket;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(string, n);
        this.configureProtocols(sSLSocket);
        return sSLSocket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(string, n, inetAddress, n2);
        this.configureProtocols(sSLSocket);
        return sSLSocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    private List<String> enableOnlyIfSupported(List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        arrayList.removeAll(list);
        ArrayList<String> arrayList2 = new ArrayList<String>(list);
        arrayList2.addAll(list2);
        if (!arrayList.isEmpty()) {
            arrayList2.removeAll(arrayList);
        }
        return arrayList2;
    }

    private List<String> removeDuplicatesKeepingInsertionOrder(List<String> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(linkedHashSet);
        return arrayList;
    }

    private void configureProtocols(SSLSocket sSLSocket) {
        List<String> list = new ArrayList<String>();
        Collections.addAll(list, sSLSocket.getSupportedProtocols());
        list = this.enableOnlyIfSupported(list, this.ENABLED_PROTOCOLS);
        list.removeAll(this.DISABLED_PROTOCOLS);
        List<String> list2 = this.removeDuplicatesKeepingInsertionOrder(list);
        sSLSocket.setEnabledProtocols(list2.toArray(new String[list2.size()]));
    }
}

