/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.Base64UnPackFilter;
import com.safelayer.trustedx.client.axis.TagInfo;
import com.safelayer.trustedx.client.axis.TxAxisClientException;
import com.safelayer.trustedx.client.axis.TxHttpTransport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.types.HexBinary;
import org.apache.axis.utils.JavaUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TxLoggerHandler
extends BasicHandler {
    private Transformer transformer;
    private XMLReader reader;
    private Random random;
    private Logger log = Logger.getLogger((String)TxLoggerHandler.class.getName());

    public TxLoggerHandler() throws Exception {
        long l = System.currentTimeMillis();
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        long l2 = System.currentTimeMillis();
        this.log.debug((Object)("Create SAX stuff :" + (l2 - l)));
        this.random = new Random();
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        try {
            this.options = this.getOptions();
            String string = (String)this.options.get("active");
            if (string == null || !"false".equals(string)) {
                Message message = messageContext.getCurrentMessage();
                byte[] byArray = message.getSOAPPartAsBytes();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                byte[] byArray2 = new byte[10];
                this.random.nextBytes(byArray2);
                String string2 = HexBinary.encode((byte[])byArray2);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                stringBuffer.append("-");
                stringBuffer.append("TxLogger");
                this.name = stringBuffer.toString();
                String string3 = (String)this.options.get(TxHttpTransport.getParam("savePath", null));
                boolean bl = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("overwrite", null)));
                stringBuffer = new StringBuffer();
                if (string3 != null && string3.length() > 0) {
                    stringBuffer.append(string3);
                    stringBuffer.append(File.separator);
                }
                stringBuffer.append(this.name);
                stringBuffer.append(".xml");
                File file = new File(stringBuffer.toString());
                if (file.canRead() && !bl) {
                    throw new TxAxisClientException("LogFileAlreadyExists");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.handleMessage(byteArrayInputStream, fileOutputStream);
            }
        }
        catch (Exception exception) {
            throw new AxisFault("TxLoggerError", (Throwable)exception);
        }
    }

    protected void handleMessage(InputStream inputStream, OutputStream outputStream) throws Exception {
        long l = System.currentTimeMillis();
        Base64UnPackFilter base64UnPackFilter = new Base64UnPackFilter(this.reader);
        String string = (String)this.options.get(TxHttpTransport.getParam("loadPath", null));
        base64UnPackFilter.setLoadPath(string);
        String string2 = (String)this.options.get(TxHttpTransport.getParam("tags", null));
        base64UnPackFilter.setTags(this.genHashTableOfTags(string2));
        SAXSource sAXSource = new SAXSource(base64UnPackFilter, new InputSource(inputStream));
        this.transformer.transform(sAXSource, new StreamResult(outputStream));
        outputStream.close();
        inputStream.close();
        long l2 = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseLog :" + (l2 - l)));
    }

    protected Hashtable genHashTableOfTags(String string) throws Exception {
        Hashtable<String, TagInfo> hashtable = new Hashtable<String, TagInfo>();
        String string2 = null;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            string2 = (String)this.options.get(TxHttpTransport.getParam("asBase64", string3));
            if (string2 != null) {
                bl = JavaUtils.isTrue((String)string2);
            }
            TagInfo tagInfo = new TagInfo();
            tagInfo.setHandleAsBase64(bl);
            hashtable.put(string3, tagInfo);
        }
        return hashtable;
    }
}

