/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.Base64PackFilter;
import com.safelayer.trustedx.client.axis.Base64UnPackFilter;
import com.safelayer.trustedx.client.axis.SendSoapHttpStream;
import com.safelayer.trustedx.client.axis.TagInfo;
import com.safelayer.trustedx.client.axis.TxAxisClientException;
import com.safelayer.trustedx.client.axis.TxHttpTransport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.MimeHeaders;
import org.apache.axis.utils.JavaUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TxHttpSender
extends BasicHandler {
    private Transformer transformer;
    private XMLReader reader;
    private Logger log = Logger.getLogger((String)TxHttpSender.class.getName());

    public TxHttpSender() throws Exception {
        long l = System.currentTimeMillis();
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        long l2 = System.currentTimeMillis();
        this.log.debug((Object)("Create SAX stuff :" + (l2 - l)));
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        Socket socket = null;
        try {
            Message message;
            this.options = this.getOptions();
            if (this.options == null) {
                message = (SimpleTargetedChain)messageContext.getAxisEngine().getConfig().getTransport(new QName("", messageContext.getTransportName()));
                this.options = message.getOptions();
            }
            message = messageContext.getRequestMessage();
            String string = messageContext.getSOAPActionURI();
            javax.xml.soap.MimeHeaders mimeHeaders = message.getMimeHeaders();
            SendSoapHttpStream sendSoapHttpStream = new SendSoapHttpStream();
            this.configureHttp(sendSoapHttpStream, messageContext);
            sendSoapHttpStream.init();
            socket = sendSoapHttpStream.getSocket();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                hashtable.put(mimeHeader.getName().toLowerCase(), mimeHeader.getValue());
            }
            hashtable.put("SOAPAction".toLowerCase(), string);
            OutputStream outputStream = sendSoapHttpStream.initChunkedTransfer(socket, hashtable, null, "POST");
            byte[] byArray = message.getSOAPPartAsBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.handleRequest(byteArrayInputStream, outputStream);
            int n = SendSoapHttpStream.initProcessResponse(socket);
            if (!SendSoapHttpStream.isSuccesfulStatus(n) && !SendSoapHttpStream.isInternalErrorStatus(n)) {
                throw new TxAxisClientException("HttpResponseNotExpected");
            }
            Hashtable hashtable2 = new Hashtable();
            InputStream inputStream = SendSoapHttpStream.getTransferInputStream(socket, hashtable2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.handleResponse(inputStream, byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            socket.close();
            MimeHeaders mimeHeaders2 = new MimeHeaders();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                mimeHeaders2.addHeader(string2, (String)hashtable2.get(string2));
            }
            Message message2 = new Message((Object)byArray2, false, (javax.xml.soap.MimeHeaders)mimeHeaders2);
            message2.setMessageType("response");
            messageContext.setResponseMessage(message2);
        }
        catch (Exception exception) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new AxisFault("TxHttpSenderError", (Throwable)exception);
        }
    }

    protected void configureHttp(SendSoapHttpStream sendSoapHttpStream, MessageContext messageContext) throws Exception {
        String string = messageContext.getStrProp("transport.url");
        sendSoapHttpStream.setUrl(string);
        int n = messageContext.getTimeout();
        String string2 = (String)this.options.get(TxHttpTransport.getParam("Timeout", null));
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        sendSoapHttpStream.setTimeout(n);
        boolean bl = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("active", "Truststore")));
        sendSoapHttpStream.setUseTrustStore(bl);
        String string3 = (String)this.options.get(TxHttpTransport.getParam("path", "Truststore"));
        String string4 = (String)this.options.get(TxHttpTransport.getParam("password", "Truststore"));
        sendSoapHttpStream.setTrustPath(string3);
        sendSoapHttpStream.setTrustPwd(string4);
        boolean bl2 = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("active", "Keystore")));
        sendSoapHttpStream.setUseKeystore(bl2);
        String string5 = (String)this.options.get(TxHttpTransport.getParam("path", "Keystore"));
        String string6 = (String)this.options.get(TxHttpTransport.getParam("password", "Keystore"));
        String string7 = (String)this.options.get(TxHttpTransport.getParam("type", "Keystore"));
        sendSoapHttpStream.setKeyPath(string5);
        sendSoapHttpStream.setKeyPwd(string6);
        sendSoapHttpStream.setKeyType(string7);
        boolean bl3 = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("active", "Proxy")));
        sendSoapHttpStream.setProxy(bl3);
        String string8 = (String)this.options.get(TxHttpTransport.getParam("host", "Proxy"));
        String string9 = (String)this.options.get(TxHttpTransport.getParam("port", "Proxy"));
        String string10 = (String)this.options.get(TxHttpTransport.getParam("username", "Proxy"));
        String string11 = (String)this.options.get(TxHttpTransport.getParam("password", "Proxy"));
        sendSoapHttpStream.setProxyHost(string8);
        sendSoapHttpStream.setProxyPort(string9);
        if (string10 != null && string11 != null) {
            sendSoapHttpStream.setProxyUserInfo(string10 + ":" + string11);
        }
        boolean bl4 = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("allowCriticalExts", "Ssl")));
        sendSoapHttpStream.setAllowCriticalExtensions(bl4);
        boolean bl5 = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("noValidation", "Ssl")));
        sendSoapHttpStream.setUseNoValidation(bl5);
        String string12 = (String)this.options.get(TxHttpTransport.getParam("validation", "Ssl"));
        sendSoapHttpStream.setValidationAlg(string12);
    }

    protected Hashtable genHashTableOfTags(String string, boolean bl) throws Exception {
        Hashtable<String, TagInfo> hashtable = new Hashtable<String, TagInfo>();
        String string2 = null;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            string2 = bl ? (String)this.options.get(TxHttpTransport.getReqParam("asBase64", string3)) : (String)this.options.get(TxHttpTransport.getRespParam("asBase64", string3));
            if (string2 != null) {
                bl2 = JavaUtils.isTrue((String)string2);
            }
            TagInfo tagInfo = new TagInfo();
            tagInfo.setHandleAsBase64(bl2);
            hashtable.put(string3, tagInfo);
        }
        return hashtable;
    }

    protected void handleRequest(InputStream inputStream, OutputStream outputStream) throws Exception {
        long l = System.currentTimeMillis();
        Base64UnPackFilter base64UnPackFilter = new Base64UnPackFilter(this.reader);
        String string = (String)this.options.get(TxHttpTransport.getReqParam("loadPath", null));
        base64UnPackFilter.setLoadPath(string);
        String string2 = (String)this.options.get(TxHttpTransport.getReqParam("tags", null));
        base64UnPackFilter.setTags(this.genHashTableOfTags(string2, true));
        SAXSource sAXSource = new SAXSource(base64UnPackFilter, new InputSource(inputStream));
        this.transformer.transform(sAXSource, new StreamResult(outputStream));
        outputStream.close();
        inputStream.close();
        long l2 = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseReq :" + (l2 - l)));
    }

    protected void handleResponse(InputStream inputStream, OutputStream outputStream) throws Exception {
        long l = System.currentTimeMillis();
        Base64PackFilter base64PackFilter = new Base64PackFilter(this.reader);
        String string = (String)this.options.get(TxHttpTransport.getRespParam("savePath", null));
        base64PackFilter.setSavePath(string);
        String string2 = (String)this.options.get(TxHttpTransport.getRespParam("tags", null));
        base64PackFilter.setTags(this.genHashTableOfTags(string2, false));
        boolean bl = JavaUtils.isTrue(this.options.get(TxHttpTransport.getRespParam("useRandomId", null)));
        base64PackFilter.setUseRandomId(bl);
        base64PackFilter.setAtrReqId("RequestID");
        boolean bl2 = JavaUtils.isTrue(this.options.get(TxHttpTransport.getRespParam("overwrite", null)));
        base64PackFilter.setOverwrite(bl2);
        SAXSource sAXSource = new SAXSource(base64PackFilter, new InputSource(inputStream));
        this.transformer.transform(sAXSource, new StreamResult(outputStream));
        outputStream.close();
        inputStream.close();
        long l2 = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseResponse :" + (l2 - l)));
    }
}

